/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.date;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang3.Range;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.spi.AbstractFunction;

public class TimestampFunction
extends AbstractFunction {
    public TimestampFunction() {
        super("Date", "TIMESTAMP", Range.is((Comparable)Integer.valueOf(1)), "Returns a time stamp from the arguments", "TIMESTAMP {{timestamp}} ", new String[]{"timestamp - a string with a date/time"}, "Timestamp", true);
    }

    public boolean allowConstantFolding() {
        return true;
    }

    public Object call(Interpreter interpreter, Object[] args) {
        Object date_obj = this.getObject(args, 0);
        if (date_obj instanceof Date) {
            return new Timestamp(((Date)date_obj).getTime());
        }
        String date = this.getStr(args, 0);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date x0 = df.parse(date);
            Timestamp x = new Timestamp(x0.getTime());
            return x;
        }
        catch (Exception x0) {
            df = new SimpleDateFormat("yyyy-MM-dd");
            try {
                Date x02 = df.parse(date);
                Timestamp x = new Timestamp(x02.getTime());
                return x;
            }
            catch (Exception ex) {
                throw new RuntimeException("Can't parse timestamp value '" + date + "' expected format 'yyyy-MM-dd HH:mm:ss'.", ex);
            }
        }
    }

    public String template() {
        Timestamp now = new Timestamp(System.currentTimeMillis());
        return "TIMESTAMP '{{" + now.toString() + "}}'";
    }
}

