/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.repr;

import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.ExpressionEvaluatorLocator;
import org.gvsig.expressionevaluator.ExpressionEvaluatorManager;
import org.gvsig.expressionevaluator.ReprMethod;

public class ReprObject
implements ReprMethod {
    public String getName() {
        return this.getClass().getSimpleName();
    }

    public boolean isApplicable(Object value) {
        return true;
    }

    public String repr(Object value) {
        if (value == null) {
            return "NULL";
        }
        try {
            if (value instanceof Object[]) {
                ExpressionEvaluatorManager manager = ExpressionEvaluatorLocator.getExpressionEvaluatorManager();
                StringBuilder builder = new StringBuilder();
                builder.append("[");
                boolean first = true;
                for (Object item : (Object[])value) {
                    if (first) {
                        first = false;
                    } else {
                        builder.append(",");
                    }
                    builder.append(manager.getReprMethod(item).repr(item));
                }
                builder.append("]");
                return builder.toString();
            }
        }
        catch (Exception ex) {
            return "[" + value.toString() + "]";
        }
        return "'" + StringUtils.replace((String)value.toString(), (String)"'", (String)"''") + "'";
    }
}

