/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.json.serializers;

import javax.json.JsonObject;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.json.JsonManager;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.json.JsonObjectBuilderImpl;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.DataType;
import org.gvsig.tools.dataTypes.DataTypesManager;
import org.gvsig.tools.dataTypes.impl.DefaultDataType;

public class DataTypeSerializer
implements JsonManager.JsonSerializer {
    public Class getObjectClass() {
        return DefaultDataType.class;
    }

    public Object toObject(JsonObject json) {
        try {
            DataTypesManager manager = ToolsLocator.getDataTypesManager();
            String typeName = json.getString("name", null);
            if (StringUtils.isBlank((CharSequence)typeName)) {
                int type = json.getInt("type");
                return manager.get(type);
            }
            return manager.get(typeName);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public JsonObjectBuilder toJsonBuilder(Object value) {
        JsonObjectBuilderImpl builder = new JsonObjectBuilderImpl();
        builder.add_class(value);
        this.addAll(builder, value);
        return builder;
    }

    private void addAll(JsonObjectBuilder target, Object source) {
        DataType dataType = (DataType)source;
        target.add("name", dataType.getName());
        target.add("type", dataType.getType());
        target.add("subtype", dataType.getSubtype());
    }
}

