/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl.task;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.task.JTasksStatus;
import org.gvsig.tools.swing.api.task.JTasksStatusList;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.task.TaskStatus;
import org.gvsig.tools.task.TaskStatusManager;

public class DefaultJTasksStatus
extends JTasksStatus
implements Observer {
    private static final long serialVersionUID = 245436792193991920L;
    private TaskStatusManager manager = null;
    private JLabel label = null;
    private JProgressBar progressBar = null;
    private JButton showAllTaskStatusButton = null;
    private int maxLabelSize = 25;

    public DefaultJTasksStatus() {
        this(ToolsLocator.getTaskStatusManager());
    }

    public DefaultJTasksStatus(TaskStatusManager manager) {
        this.bind(manager);
        this.createComponents();
    }

    public void setMaxLabelSize(int maxLabelSize) {
        this.maxLabelSize = maxLabelSize;
    }

    public int getMaxLabelSize() {
        return this.maxLabelSize;
    }

    public JComponent asJComponent() {
        return this;
    }

    public void bind(TaskStatusManager manager) {
        if (this.manager != null) {
            this.manager.deleteObserver((Observer)this);
        }
        this.manager = manager;
        if (this.manager != null) {
            this.manager.addObserver((Observer)this);
        }
    }

    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        return new Dimension(270, d.height);
    }

    private void createComponents() {
        this.label = new JLabel();
        this.progressBar = new JProgressBar(1, 100);
        this.progressBar.setPreferredSize(new Dimension(40, 10));
        this.progressBar.setIndeterminate(true);
        this.progressBar.setBorderPainted(true);
        this.progressBar.setVisible(false);
        this.showAllTaskStatusButton = new JButton();
        this.showAllTaskStatusButton.setPreferredSize(new Dimension(16, 16));
        this.showAllTaskStatusButton.setBorderPainted(false);
        this.showAllTaskStatusButton.setIcon(this.getIcon("showAllTaskStatusButton.png"));
        this.showAllTaskStatusButton.setVisible(false);
        this.showAllTaskStatusButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JTasksStatusList dialog = ToolsSwingLocator.getTaskStatusSwingManager().createJTasksStatusList(DefaultJTasksStatus.this.manager);
                WindowManager wm = ToolsSwingLocator.getWindowManager();
                wm.showWindow((JComponent)dialog, "Tasks", WindowManager.MODE.TOOL);
            }
        });
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.fill = 3;
        c.weightx = 0.0;
        c.ipadx = 1;
        this.add(this.label, c);
        c.gridx = 1;
        c.fill = 1;
        c.weightx = 1.0;
        this.add(this.progressBar, c);
        c.gridx = 2;
        c.fill = 3;
        c.weightx = 0.0;
        this.add(this.showAllTaskStatusButton);
    }

    private ImageIcon getIcon(String name) {
        URL iconurl = ((Object)((Object)this)).getClass().getResource(name);
        if (iconurl == null) {
            return new ImageIcon();
        }
        return new ImageIcon(iconurl);
    }

    public void update(final Observable observable, final Object notification) {
        if (notification != null && !(notification instanceof TaskStatus)) {
            return;
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DefaultJTasksStatus.this.update(observable, notification);
                }
            });
            return;
        }
        TaskStatus taskStatus = (TaskStatus)notification;
        if (taskStatus == null && (taskStatus = this.manager.getRunningTaskStatusMostRecent()) == null) {
            this.label.setText("");
            this.label.setToolTipText("");
            this.progressBar.setVisible(false);
            this.showAllTaskStatusButton.setVisible(false);
            return;
        }
        if (!taskStatus.isRunning()) {
            TaskStatus taskStatus2 = this.manager.getRunningTaskStatusMostRecent();
            if (taskStatus2 == null) {
                this.label.setText("");
                this.label.setToolTipText("");
                this.progressBar.setVisible(false);
                this.showAllTaskStatusButton.setVisible(false);
                return;
            }
            taskStatus = taskStatus2;
        }
        String label1 = taskStatus.getMessage();
        String label2 = taskStatus.getLabel();
        String title = taskStatus.getTitle();
        if (title == null) {
            title = "Progress";
        }
        label2 = StringUtils.isEmpty((CharSequence)label2) ? title : title + "\n" + label2;
        this.label.setText(StringUtils.abbreviateMiddle((String)label1, (String)"...", (int)this.maxLabelSize));
        this.label.setToolTipText(label2);
        if (taskStatus.isIndeterminate()) {
            this.progressBar.setString("");
        } else {
            this.progressBar.setString(String.valueOf(taskStatus.getCompleted()));
        }
        this.progressBar.setIndeterminate(taskStatus.isIndeterminate());
        this.progressBar.setValue(taskStatus.getCompleted());
        if (!this.progressBar.isVisible()) {
            this.progressBar.setVisible(true);
        }
        if (!this.showAllTaskStatusButton.isVisible()) {
            this.showAllTaskStatusButton.setVisible(true);
        }
    }
}

