/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.andami.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.andami.Arguments;
import org.gvsig.tools.dataTypes.DataTypeUtils;

public class DefaultArguments
implements Arguments {
    private final String[] args;
    protected Map<String, String> flags;
    protected List<String> parameters;

    public DefaultArguments(String[] args) {
        this.args = args;
        this.flags = new HashMap<String, String>();
        this.parameters = new ArrayList<String>();
        this.parse();
    }

    private void parse() {
        boolean acceptFlags = true;
        for (String arg : this.args) {
            if (acceptFlags) {
                if (arg.equals("--")) {
                    acceptFlags = false;
                    continue;
                }
                if (arg.startsWith("--")) {
                    String value;
                    String name;
                    int n = arg.indexOf("=");
                    if (n < 0) {
                        name = arg.substring(2);
                        value = "true";
                    } else {
                        name = arg.substring(2, n);
                        value = arg.substring(n + 1);
                    }
                    this.flags.put(name, value);
                    continue;
                }
                this.parameters.add(arg);
                continue;
            }
            this.parameters.add(arg);
        }
    }

    @Override
    public String get(String name) {
        return this.flags.get(name);
    }

    @Override
    public Object get(String name, Object defaultValue) {
        String value = this.get(name);
        if (defaultValue == null) {
            return value;
        }
        if (StringUtils.isBlank((CharSequence)value)) {
            return defaultValue;
        }
        if (defaultValue instanceof CharSequence) {
            return value;
        }
        if (defaultValue instanceof Integer) {
            return DataTypeUtils.toInteger((Object)value, (int)((Integer)defaultValue));
        }
        if (defaultValue instanceof Long) {
            return DataTypeUtils.toLong((Object)value, (long)((Long)defaultValue));
        }
        if (defaultValue instanceof Boolean) {
            try {
                return DataTypeUtils.toBoolean((Object)value, (boolean)((Boolean)defaultValue));
            }
            catch (Throwable th) {
                return BooleanUtils.toBoolean((String)value);
            }
        }
        if (defaultValue instanceof Double) {
            return DataTypeUtils.toDouble((Object)value, (double)((Double)defaultValue));
        }
        if (defaultValue instanceof Float) {
            return DataTypeUtils.toDouble((Object)value, (double)((Float)defaultValue).floatValue());
        }
        if (defaultValue instanceof Date) {
            return DataTypeUtils.toDate((Object)value, (Date)((Date)defaultValue));
        }
        return value;
    }

    @Override
    public boolean contains(String name) {
        return this.flags.containsKey(name);
    }

    @Override
    public boolean contains(String name, String value) {
        String x = this.flags.get(name);
        if (x == null) {
            return false;
        }
        return StringUtils.equalsIgnoreCase((CharSequence)value, (CharSequence)x);
    }

    @Override
    public List<String> parameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    @Override
    public Map<String, String> flags() {
        return Collections.unmodifiableMap(this.flags);
    }

    @Override
    public int size() {
        return this.parameters.size();
    }

    @Override
    public String get(int n) {
        return this.parameters.get(n);
    }

    @Override
    public Iterator<String> iterator() {
        return this.parameters.iterator();
    }
}

