/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.andami.ui.mdiFrame;

import java.util.HashMap;
import java.util.Map;
import javax.swing.KeyStroke;
import org.gvsig.andami.messages.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyMapping {
    private static Logger logger = LoggerFactory.getLogger(KeyMapping.class);
    private static final Map<String, Integer> keys = new HashMap<String, Integer>();

    public static int getKey(char a) {
        Integer ret = keys.get(String.valueOf(a));
        if (ret == null) {
            throw new RuntimeException(Messages.getString("KeyMapping.Caracter_no_valido") + a);
        }
        return ret;
    }

    public static KeyStroke getKeyStroke(String accelerator) {
        if (accelerator == null) {
            return null;
        }
        if ((accelerator = accelerator.trim()).length() < 1) {
            return null;
        }
        String[] parts = accelerator.toLowerCase().split("[+]");
        int modifiers = 0;
        int key = 0;
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            if ("ctrl".equals(part)) {
                modifiers |= 2;
                continue;
            }
            if ("shift".equals(part)) {
                modifiers |= 1;
                continue;
            }
            if ("meta".equals(part)) {
                modifiers |= 4;
                continue;
            }
            if ("alt".equals(part)) {
                modifiers |= 8;
                continue;
            }
            if ("".equals(part)) {
                key = 521;
                continue;
            }
            Integer x = keys.get(part);
            if (x != null) {
                key = x;
                continue;
            }
            try {
                throw new IllegalArgumentException();
            }
            catch (IllegalArgumentException ex) {
                logger.info("getKeyStroke('" + accelerator + "') malformed accelerator.", (Throwable)ex);
                return null;
            }
        }
        if (key == 0) {
            return null;
        }
        return KeyStroke.getKeyStroke(key, modifiers);
    }

    static {
        keys.put("a", 65);
        keys.put("b", 66);
        keys.put("c", 67);
        keys.put("d", 68);
        keys.put("e", 69);
        keys.put("f", 70);
        keys.put("g", 71);
        keys.put("h", 72);
        keys.put("i", 73);
        keys.put("j", 74);
        keys.put("k", 75);
        keys.put("l", 76);
        keys.put("m", 77);
        keys.put("n", 78);
        keys.put("o", 79);
        keys.put("p", 80);
        keys.put("q", 81);
        keys.put("r", 82);
        keys.put("s", 83);
        keys.put("t", 84);
        keys.put("u", 85);
        keys.put("v", 86);
        keys.put("w", 87);
        keys.put("x", 88);
        keys.put("y", 89);
        keys.put("z", 90);
        keys.put("0", 48);
        keys.put("1", 49);
        keys.put("2", 50);
        keys.put("3", 51);
        keys.put("4", 52);
        keys.put("5", 53);
        keys.put("6", 54);
        keys.put("7", 55);
        keys.put("8", 56);
        keys.put("9", 57);
        keys.put("+", 521);
        keys.put("-", 45);
        keys.put("f1", 112);
        keys.put("f2", 113);
        keys.put("f3", 114);
        keys.put("f4", 115);
        keys.put("f5", 116);
        keys.put("f6", 117);
        keys.put("f7", 118);
        keys.put("f8", 119);
        keys.put("f9", 120);
        keys.put("f10", 121);
        keys.put("f11", 122);
        keys.put("f12", 123);
        keys.put("delete", 127);
        keys.put("up", 38);
        keys.put("down", 40);
        keys.put("left", 37);
        keys.put("right", 39);
        keys.put("pgup", 33);
        keys.put("pgdown", 34);
        keys.put("pgdn", 34);
        keys.put("home", 36);
        keys.put("end", 35);
    }
}

