/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl.dynclass;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.gvsig.tools.dynobject.Tags;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;
import org.gvsig.tools.swing.impl.dynclass.DefaultPairNameValue;
import org.gvsig.tools.swing.impl.dynclass.PairNameValue;
import org.gvsig.tools.swing.impl.dynclass.TagControler;

public class TagsHelper {
    private JTable tblTags;
    private List<PairNameValue> tags;
    private final WindowManager_v2 windowManager;

    public TagsHelper(WindowManager_v2 windowManager) {
        this.windowManager = windowManager;
    }

    public void bind(JTable tblTags, JButton btnDelete, JButton btnAdd, JButton btnModify) {
        this.tblTags = tblTags;
        this.tblTags.setModel(new TagsTableModel());
        btnDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TagsHelper.this.deleteCurrentTag();
            }
        });
        btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TagsHelper.this.addTag();
            }
        });
        btnModify.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TagsHelper.this.modifyCurrentTag();
            }
        });
    }

    private void addTag() {
        final TagControler panel = new TagControler(this.windowManager);
        final Dialog dialog = this.windowManager.createDialog((JComponent)panel, "Tag - New", null, 3);
        dialog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (dialog.getAction() == 1) {
                    DefaultPairNameValue item = new DefaultPairNameValue("", "");
                    panel.fetch(item);
                    TagsHelper.this.tags.add(item);
                    TagsHelper.this.tblTags.setModel(new TagsTableModel());
                }
            }
        });
        dialog.show(WindowManager.MODE.WINDOW);
    }

    private void deleteCurrentTag() {
        PairNameValue item = this.getCurrentItem();
        if (item == null) {
            return;
        }
        this.tags.remove(item);
        this.tblTags.setModel(new TagsTableModel());
    }

    public PairNameValue getCurrentItem() {
        int row = this.tblTags.getSelectedRow();
        if (row < 0) {
            return null;
        }
        PairNameValue pair = this.tags.get(row);
        return pair;
    }

    private void modifyCurrentTag() {
        final PairNameValue pair = this.getCurrentItem();
        final TagControler panel = new TagControler(this.windowManager);
        panel.set(pair);
        final Dialog dialog = this.windowManager.createDialog((JComponent)panel, "Tag - " + pair.getName(), null, 3);
        dialog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (dialog.getAction() == 1) {
                    panel.fetch(pair);
                    TagsHelper.this.tblTags.setModel(new TagsTableModel());
                }
            }
        });
        dialog.show(WindowManager.MODE.WINDOW);
    }

    public void set(Tags tags) {
        this.tags = new ArrayList<PairNameValue>();
        if (tags.isEmpty()) {
            return;
        }
        for (String key : tags) {
            this.tags.add(new DefaultPairNameValue(key, tags.get(key)));
        }
        Collections.sort(this.tags);
    }

    public void fetch(Tags tags) {
        tags.removeAll();
        for (PairNameValue pair : this.tags) {
            tags.set(pair.getName(), pair.getValue());
        }
    }

    private class TagsTableModel
    implements TableModel {
        private final String[] header = new String[]{"Name", "Value"};

        private TagsTableModel() {
        }

        @Override
        public int getRowCount() {
            if (TagsHelper.this.tags == null) {
                return 0;
            }
            return TagsHelper.this.tags.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.header[columnIndex];
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (TagsHelper.this.tags == null) {
                return null;
            }
            PairNameValue pair = (PairNameValue)TagsHelper.this.tags.get(rowIndex);
            if (columnIndex == 0) {
                return pair.getName();
            }
            return pair.getValue();
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
        }
    }
}

