/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.installer.lib.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gvsig.installer.lib.api.Dependencies;
import org.gvsig.installer.lib.api.DependenciesCalculator;
import org.gvsig.installer.lib.api.Dependency;
import org.gvsig.installer.lib.api.PackageInfo;
import org.gvsig.installer.lib.api.Version;
import org.gvsig.installer.lib.api.execution.InstallPackageService;
import org.gvsig.installer.lib.impl.DefaultDependencies;
import org.gvsig.installer.lib.impl.DefaultDependenciesCalculator;
import org.gvsig.tools.packageutils.StringWithAlias;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependenciesCalculatorV1
implements DependenciesCalculator {
    private static Logger logger = LoggerFactory.getLogger(DefaultDependenciesCalculator.class);
    private InstallPackageService installService = null;
    private List<PackageInfo> packagesInstalleds = null;
    private List<PackageInfo> packagesToInstall = null;
    private List<PackageInfo> requieredPackages = null;
    private List<PackageInfo> conflictsPackages = null;
    private Dependencies unresolvedDependencies = null;
    private Map<Dependency, Set<PackageInfo>> requiredPackagesOfDependency = null;

    public DependenciesCalculatorV1(InstallPackageService installService) {
        this.installService = installService;
        this.packagesInstalleds = new ArrayList<PackageInfo>();
        this.packagesToInstall = new ArrayList<PackageInfo>();
        this.requiredPackagesOfDependency = new HashMap<Dependency, Set<PackageInfo>>();
    }

    private boolean addDependency(Dependencies dependencies, Dependency dependency) {
        try {
            if (dependencies.contains((Object)dependency)) {
                return false;
            }
            Dependency dep = (Dependency)dependency.clone();
            dependencies.add((Object)dep);
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    private void addDependency(Dependencies dependencies, PackageInfo packageInfo) {
        Dependencies pkgdependencies = packageInfo.getDependencies();
        if (pkgdependencies != null) {
            Iterator it = pkgdependencies.iterator();
            Dependency dependency = null;
            while (it.hasNext()) {
                dependency = (Dependency)it.next();
                Set<PackageInfo> requirers = this.requiredPackagesOfDependency.get(dependency);
                if (requirers == null) {
                    requirers = new HashSet<PackageInfo>();
                    this.requiredPackagesOfDependency.put(dependency, requirers);
                }
                this.addDependency(dependencies, dependency);
                requirers.add(packageInfo);
            }
        }
    }

    public void addPackageToInstall(PackageInfo packageInfo) {
        this.packagesToInstall.add(packageInfo);
    }

    public void addPackageToInstall(Collection<PackageInfo> packages) {
        Iterator<PackageInfo> it = packages.iterator();
        while (it.hasNext()) {
            this.addPackageToInstall(it.next());
        }
    }

    public void addInstalledPackage(PackageInfo packageInfo) {
        this.packagesInstalleds.add(packageInfo);
    }

    public void addInstalledPackage(PackageInfo[] packages) {
        for (int i = 0; i < packages.length; ++i) {
            this.addInstalledPackage(packages[i]);
        }
    }

    public void calculate() {
        ArrayList<PackageInfo> packages = new ArrayList<PackageInfo>();
        packages.addAll(this.packagesInstalleds);
        packages.addAll(this.packagesToInstall);
        HashSet<PackageInfo> allPackages = new HashSet<PackageInfo>();
        allPackages.addAll(packages);
        for (int i = 0; i < this.installService.getPackageCount(); ++i) {
            PackageInfo pkg = this.installService.getPackageInfo(i);
            allPackages.add(pkg);
        }
        ArrayList<PackageInfo> requieredPackages = null;
        this.conflictsPackages = new ArrayList<PackageInfo>();
        for (int retries = 0; retries < 100; ++retries) {
            requieredPackages = new ArrayList<PackageInfo>();
            if (logger.isDebugEnabled()) {
                logger.debug("Pass " + retries);
                logger.debug("All packages (installed+to-install):");
                logger.debug("\n" + this.dumpPackages(packages));
            }
            DefaultDependencies dependencies = new DefaultDependencies();
            Iterator it = packages.iterator();
            while (it.hasNext()) {
                this.addDependency((Dependencies)dependencies, (PackageInfo)it.next());
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Dependencies:");
                logger.debug("\n" + this.dumpDependencies(dependencies));
            }
            this.unresolvedDependencies = new DefaultDependencies();
            this.unresolvedDependencies.addAll((Collection)dependencies);
            for (PackageInfo pkg : allPackages) {
                PackageInfo pkg1;
                if (logger.isDebugEnabled()) {
                    logger.debug("Check " + pkg.toStringCompact());
                }
                List foundDependencies = null;
                foundDependencies = dependencies.findAll("required", pkg.getAllCodes(), pkg.getVersion());
                if (foundDependencies != null) {
                    pkg1 = this.getByCodeAndVersion(packages, pkg.getAllCodes(), pkg.getVersion());
                    if (pkg1 == null) {
                        logger.debug("           Add required");
                        requieredPackages.add(pkg);
                    }
                    this.unresolvedDependencies.removeAll((Collection)foundDependencies);
                }
                if ((foundDependencies = dependencies.findAll("conflict", pkg.getAllCodes(), pkg.getVersion())) == null) continue;
                pkg1 = this.getByCodeAndVersion(packages, pkg.getAllCodes(), pkg.getVersion());
                if (pkg1 == null) {
                    logger.debug("           Add conflicts");
                    this.conflictsPackages.add(pkg);
                }
                this.unresolvedDependencies.removeAll((Collection)foundDependencies);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("required packages:");
                logger.debug("\n" + this.dumpPackages(requieredPackages));
            }
            if (requieredPackages.size() == 0) break;
            packages.addAll(requieredPackages);
            this.removeDuplicateds(packages);
        }
        requieredPackages = new ArrayList();
        for (PackageInfo pkg : packages) {
            if (this.packagesInstalleds.contains(pkg) || this.packagesToInstall.contains(pkg)) continue;
            requieredPackages.add(pkg);
        }
        Collections.sort(requieredPackages, new Comparator<PackageInfo>(){

            @Override
            public int compare(PackageInfo o1, PackageInfo o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        if (logger.isDebugEnabled()) {
            logger.debug("required packages");
            logger.debug("\n" + this.dumpPackages(requieredPackages));
            logger.debug("Conflict packages");
            logger.debug("\n" + this.dumpPackages(this.conflictsPackages));
        }
        this.requieredPackages = requieredPackages;
        this.dumpUnresolvedDependencies();
    }

    private void dumpUnresolvedDependencies() {
        for (Dependency dep : this.unresolvedDependencies) {
            Set<PackageInfo> required = this.requiredPackagesOfDependency.get(dep);
            if (required == null) continue;
            StringBuffer str_buffer = new StringBuffer();
            str_buffer.append("Unresolved dependency: " + dep.toString() + " required by:\n");
            Iterator<PackageInfo> iter2 = required.iterator();
            while (iter2.hasNext()) {
                str_buffer.append("   - " + iter2.next().toStringCompact() + "\n");
            }
            logger.info(str_buffer.toString());
        }
    }

    public List<PackageInfo> getRequiredPackages() {
        return this.requieredPackages;
    }

    public List<PackageInfo> getConflictPackages() {
        return this.conflictsPackages;
    }

    public Dependencies getUnresolvedDependencies() {
        return this.unresolvedDependencies;
    }

    private PackageInfo getByCodeAndVersion(Collection<PackageInfo> packages, StringWithAlias code, Version version) {
        for (PackageInfo pkg1 : packages) {
            if (!pkg1.hasThisCode(code) || !pkg1.getVersion().check(">=", version)) continue;
            return pkg1;
        }
        return null;
    }

    private void removeDuplicateds(List<PackageInfo> packages) {
        ArrayList<PackageInfo> lpackages = new ArrayList<PackageInfo>();
        for (PackageInfo pkg1 : packages) {
            boolean copy = true;
            for (PackageInfo pkg2 : packages) {
                if (pkg1 == pkg2 || !pkg1.hasThisCode(pkg2.getAllCodes()) || pkg2.getVersion().check("<", pkg1.getVersion())) continue;
                copy = false;
                break;
            }
            if (!copy) continue;
            lpackages.add(pkg1);
        }
        packages.clear();
        packages.addAll(lpackages);
    }

    private String dumpPackages(Collection<PackageInfo> pkgs) {
        StringBuffer s = new StringBuffer();
        Iterator<PackageInfo> it = pkgs.iterator();
        while (it.hasNext()) {
            s.append(it.next().toStringCompact());
            s.append("\n");
        }
        return s.toString();
    }

    private String dumpDependencies(Collection<Dependency> dependencies) {
        StringBuffer s = new StringBuffer();
        Iterator<Dependency> it = dependencies.iterator();
        while (it.hasNext()) {
            s.append(it.next().toString());
            s.append("\n");
        }
        return s.toString();
    }
}

