/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.gui.panels;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gvsig.app.gui.panels.ColorPanel;
import org.gvsig.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColorChooserPanel
extends JPanel {
    private static final Logger logger = LoggerFactory.getLogger(ColorChooserPanel.class);
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JButton changeButton = new JButton();
    private JPanel outerColorPanel = new JPanel();
    private ColorPanel colorPanel = new ColorPanel();
    private Color color = Color.black;
    private Dimension dim = new Dimension(100, 22);
    private Dimension dim2;
    private ArrayList<ActionListener> actionListeners;
    private boolean withTransp;
    private boolean withTranspPerc;
    private boolean withNoFill;
    private JCheckBox chkUseColor;
    private JSlider sldTransparency;
    private JLabel lblTransparency;
    private boolean muteSldTransparency;
    private double perc;
    private ChangeListener sldAction;

    public ColorChooserPanel() {
        this(false);
    }

    public ColorChooserPanel(boolean withTransparencySlider) {
        this(withTransparencySlider, false);
    }

    public ColorChooserPanel(boolean withTransparencySlider, boolean withNoFill) {
        this.dim2 = new Dimension(this.dim.width, this.dim.height * 2 + 5);
        this.actionListeners = new ArrayList();
        this.muteSldTransparency = false;
        this.perc = 0.392156863;
        this.sldAction = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!ColorChooserPanel.this.muteSldTransparency) {
                    int alphaValue = ColorChooserPanel.this.sldTransparency.getValue();
                    ColorChooserPanel.this.setAlpha(alphaValue);
                    if (ColorChooserPanel.this.withTranspPerc) {
                        int percValue = (int)((double)alphaValue * ColorChooserPanel.this.perc);
                        ColorChooserPanel.this.lblTransparency.setText(String.valueOf(percValue) + "%");
                    }
                    ColorChooserPanel.this.fireActionPerformed();
                }
            }
        };
        this.withTransp = withTransparencySlider;
        this.withTranspPerc = withTransparencySlider;
        this.withNoFill = withNoFill;
        try {
            if (this.withTransp) {
                this.sldTransparency = new JSlider(0, 255);
                this.sldTransparency.addChangeListener(this.sldAction);
                int width = withNoFill ? this.dim2.width - 40 : this.dim2.width;
                this.sldTransparency.setPreferredSize(new Dimension(width - 5, this.dim2.height / 2));
                this.sldTransparency.setToolTipText(Messages.getText((String)"transparencia"));
                if (this.withTranspPerc) {
                    this.lblTransparency = new JLabel();
                    int percValue = (int)((double)this.sldTransparency.getValue() * this.perc);
                    this.lblTransparency.setText(String.valueOf(percValue) + "%");
                    this.lblTransparency.setPreferredSize(new Dimension(40, 20));
                }
                this.sldTransparency.setValue(255);
            }
            this.jbInit();
            this.colorPanel.setLineColor(null);
            this.changeButton.setToolTipText(Messages.getText((String)"browse"));
        }
        catch (Exception e) {
            logger.warn("Can't create ColorChooserPanel", (Throwable)e);
        }
    }

    private void jbInit() throws Exception {
        JPanel pane = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        this.changeButton.setText("...");
        this.changeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorChooserPanel.this.changeButton_actionPerformed(e);
            }
        });
        this.outerColorPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.outerColorPanel.setPreferredSize(new Dimension(this.dim.width / 2, this.dim.height));
        this.outerColorPanel.setBackground(Color.white);
        c.fill = 2;
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 2;
        pane.add((Component)this.outerColorPanel, c);
        c.fill = 2;
        c.gridx = 3;
        c.gridy = 0;
        c.gridwidth = 1;
        pane.add((Component)this.changeButton, c);
        this.outerColorPanel.add(this.colorPanel);
        if (this.withNoFill) {
            this.chkUseColor = new JCheckBox();
            this.chkUseColor.setSelected(true);
            c.fill = 2;
            c.gridwidth = 1;
            c.gridx = 0;
            c.gridy = 1;
            this.chkUseColor.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ColorChooserPanel.this.useColor_actionPerformed(e);
                }
            });
            pane.add((Component)this.chkUseColor, c);
        }
        if (this.withTransp) {
            c.fill = 2;
            c.gridwidth = 3;
            c.gridx = 1;
            c.gridy = 1;
            pane.add((Component)this.sldTransparency, c);
            if (this.withTranspPerc) {
                c.fill = 2;
                c.gridwidth = 3;
                c.gridx = 4;
                c.gridy = 1;
                pane.add((Component)this.lblTransparency, c);
            }
        }
        this.add(pane);
    }

    private void changeButton_actionPerformed(ActionEvent e) {
        Color newColor = JColorChooser.showDialog(SwingUtilities.windowForComponent(this), Messages.getText((String)"choose_color"), this.color);
        if (newColor == null) {
            return;
        }
        this.setColor(newColor);
        this.fireActionPerformed();
    }

    public boolean getUseColorisSelected() {
        try {
            if (this.withNoFill) {
                return this.chkUseColor.isSelected();
            }
            return false;
        }
        catch (Exception ex) {
            logger.warn("Can't get use-selected-color, return false.", (Throwable)ex);
            return false;
        }
    }

    public void setUseColorIsSelected(boolean b) {
        if (this.withNoFill) {
            this.chkUseColor.setSelected(b);
        }
    }

    private void useColor_actionPerformed(ActionEvent e) {
        if (this.chkUseColor.isSelected()) {
            this.setColor(this.color);
        } else {
            this.setColor(null);
        }
        this.fireActionPerformed();
    }

    public void addActionListener(ActionListener l) {
        this.actionListeners.add(l);
    }

    public void removeActionListener(ActionListener l) {
        this.actionListeners.remove(l);
    }

    protected void fireActionPerformed() {
        Iterator<ActionListener> i = this.actionListeners.iterator();
        while (i.hasNext()) {
            i.next().actionPerformed(new ActionEvent(this, 0, null));
        }
    }

    public void setColor(Color color) {
        if (color != null) {
            this.color = color;
            this.setAlpha(color.getAlpha());
            this.updateColorPanel();
        }
    }

    public void setAlpha(int alpha) {
        this.muteSldTransparency = true;
        if (this.color != null) {
            this.color = this.alphaColor(this.color, alpha);
        }
        if (this.withTransp) {
            this.sldTransparency.setValue(alpha);
            this.sldTransparency.validate();
            int percValue = (int)((double)alpha * this.perc);
            this.lblTransparency.setText(String.valueOf(percValue) + "%");
        }
        this.updateColorPanel();
        this.muteSldTransparency = false;
    }

    public int getAlpha() {
        try {
            if (this.withTransp) {
                return this.sldTransparency.getValue();
            }
            return this.color.getAlpha();
        }
        catch (Exception ex) {
            logger.warn("Can't get alpha, return 0 as alpha", (Throwable)ex);
            return 0;
        }
    }

    private void updateColorPanel() {
        this.colorPanel.setFillColor(this.color);
        this.colorPanel.repaint();
    }

    public Color getColor() {
        return this.color;
    }

    public void disabledWithTransparency() {
        this.changeButton.setEnabled(false);
        if (this.withNoFill) {
            this.chkUseColor.setEnabled(false);
        }
    }

    @Override
    public void setEnabled(boolean newEnabled) {
        this.changeButton.setEnabled(newEnabled);
        if (this.withTransp) {
            this.sldTransparency.setEnabled(newEnabled);
        }
        if (this.withTranspPerc) {
            this.lblTransparency.setEnabled(newEnabled);
        }
        if (this.withNoFill) {
            this.chkUseColor.setEnabled(newEnabled);
        }
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        ColorChooserPanel ce2 = new ColorChooserPanel(true, true);
        JPanel content = new JPanel(new GridLayout(2, 1));
        content.add(ce2);
        f.setContentPane(content);
        f.setDefaultCloseOperation(3);
        f.pack();
        f.setVisible(true);
    }

    private Color alphaColor(Color color, int alpha) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
    }
}

