/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gui.beans.table;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.gvsig.gui.beans.table.TableContainer;
import org.gvsig.gui.beans.table.models.ModelLoader;

public class Table
extends JPanel {
    private static final long serialVersionUID = -4375500244443538451L;
    private JTable jTable = null;
    private JScrollPane scrollPanel = null;
    private DefaultTableModel tableModel = null;
    private String[] columnNames = null;
    private int[] columnWidths = null;
    private TableContainer tableContainer = null;
    public String tableModelClass = null;
    private ArrayList listeners = null;

    public Table(String[] columnNames, int[] columnWidths, String tableModelClass) {
        this.columnNames = columnNames;
        this.columnWidths = columnWidths;
        this.tableModelClass = tableModelClass;
        this.initialize();
    }

    public Table(String[] columnNames, int[] columnWidths, String tableModelClass, ArrayList listeners) {
        this.columnNames = columnNames;
        this.columnWidths = columnWidths;
        this.tableModelClass = tableModelClass;
        this.listeners = listeners;
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)this.getJScrollPane(), "Center");
    }

    public JTable getJTable() {
        if (this.jTable == null) {
            ModelLoader loader = new ModelLoader();
            this.jTable = loader.load(this.tableModelClass, this.columnNames, this.listeners);
            this.tableModel = loader.getTableModel();
            TableColumn column = null;
            int widthPerColumn = this.getWidth() / this.columnNames.length;
            for (int i = 0; i < this.columnNames.length; ++i) {
                column = this.jTable.getColumnModel().getColumn(i);
                column.setResizable(true);
                if (this.columnWidths == null) {
                    column.setPreferredWidth(widthPerColumn);
                    continue;
                }
                column.setPreferredWidth(this.columnWidths[i]);
            }
        }
        return this.jTable;
    }

    private JScrollPane getJScrollPane() {
        if (this.scrollPanel == null) {
            this.scrollPanel = new JScrollPane(this.getJTable());
        }
        return this.scrollPanel;
    }

    public TableContainer getTableContainer() {
        return this.tableContainer;
    }

    public void setTableContainer(TableContainer tableContainer) {
        this.tableContainer = tableContainer;
    }

    public DefaultTableModel getTableModel() {
        return this.tableModel;
    }

    public void addRow(Object[] list) {
        ((DefaultTableModel)this.getJTable().getModel()).addRow(list);
    }

    public void delRow(int i) {
        ((DefaultTableModel)this.getJTable().getModel()).removeRow(i);
    }

    public void swapRow(int i, int j) {
        DefaultTableModel model = (DefaultTableModel)this.getJTable().getModel();
        if (i < 0 || j < 0) {
            return;
        }
        if (i >= model.getRowCount() || j >= model.getRowCount()) {
            return;
        }
        model.moveRow(i, i, j);
    }

    public void removeAllRows() {
        ((DefaultTableModel)this.getJTable().getModel()).setNumRows(0);
    }
}

