/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.compat.se.net.downloader.se;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import org.apache.commons.collections4.map.LRUMap;
import org.apache.commons.io.FileUtils;
import org.apache.http.entity.ContentType;
import org.gvsig.compat.net.ICancellable;
import org.gvsig.compat.se.net.downloader.Downloader;
import org.gvsig.compat.se.net.downloader.se.SEDownloaderTask;
import org.gvsig.compat.se.net.downloader.se.SEMonitor;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.folders.FoldersManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SEDownloader
implements Downloader {
    private final long latency = 500L;
    private static final Logger LOG = LoggerFactory.getLogger(SEDownloader.class);
    private static final int MAX_URL_TO_FILE_CACHE = 1000;
    private final Map<Object, Boolean> canceledGroup = new HashMap<Object, Boolean>();
    private Map<Object, String> cachedURItoFile;
    private Exception downloadException;
    private final ExecutorUI executorUI = new ExecutorUI();

    public Executor getExecutorUI() {
        return this.executorUI;
    }

    private File getPreviousDownloadedURL(URL url) {
        return this.getPreviousDownloaded(url);
    }

    protected File getPreviousDownloadedURL(URL url, String data) {
        if (data == null) {
            return this.getPreviousDownloaded(url);
        }
        return this.getPreviousDownloaded(url.toString() + data);
    }

    private File getPreviousDownloaded(Object theurl) {
        String filePath;
        Object thekey;
        File f = null;
        try {
            thekey = theurl instanceof URL ? ((URL)theurl).toURI() : theurl;
        }
        catch (Exception e) {
            LOG.info("Warning: did not check url: " + theurl, (Throwable)e);
            return null;
        }
        if (this.cachedURItoFile != null && this.cachedURItoFile.containsKey(thekey) && !(f = new File(filePath = this.cachedURItoFile.get(thekey))).exists()) {
            this.cachedURItoFile.remove(thekey);
            return null;
        }
        return f;
    }

    @Override
    public void addDownloadedURL(URL url, String filePath) {
        URI theuri;
        if (this.cachedURItoFile == null) {
            this.cachedURItoFile = new LRUMap(1000);
        }
        try {
            theuri = url.toURI();
        }
        catch (Exception e) {
            LOG.info("Warning: did not cache bad url: " + url, (Throwable)e);
            return;
        }
        String fileName = this.cachedURItoFile.put(theuri, filePath);
    }

    public synchronized File downloadFile(URL url, String name, ICancellable cancel) throws IOException, ConnectException, UnknownHostException {
        LOG.info("Download file " + Objects.toString(url));
        File f = this.getPreviousDownloadedURL(url);
        if (f == null) {
            f = this.getUniqueTemporaryFile(name);
            if (cancel == null) {
                cancel = new ICancellable(){

                    public boolean isCanceled() {
                        return false;
                    }

                    public Object getID() {
                        return SEDownloader.class.getName();
                    }
                };
            }
            SEMonitor monitorObj = new SEMonitor(this, cancel);
            Thread downloader = new Thread(this.createDownloaderTask(this, this.executorUI, url, null, f, cancel.getID().getClass(), -1));
            Thread monitor = new Thread(monitorObj);
            downloader.setName("Downloader_" + downloader.getId());
            monitor.setName("DownloaderMon_" + monitor.getId());
            monitor.start();
            downloader.start();
            while (!this.getCanceled(cancel.getID()) && downloader.isAlive()) {
                try {
                    Thread.sleep(500L);
                    this.executorUI.runCommands();
                }
                catch (InterruptedException e) {
                    LOG.error("Error", (Throwable)e);
                }
            }
            this.executorUI.clear();
            try {
                monitorObj.setFinish(true);
                monitor.join();
                downloader.join();
            }
            catch (InterruptedException e1) {
                LOG.warn(e1.getMessage());
            }
            downloader = null;
            monitor = null;
            if (this.getCanceled(cancel.getID())) {
                return null;
            }
            downloader = null;
            monitor = null;
            if (this.downloadException != null) {
                Exception e = this.downloadException;
                if (e instanceof FileNotFoundException) {
                    throw (IOException)e;
                }
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                if (e instanceof ConnectException) {
                    throw (ConnectException)e;
                }
                if (e instanceof UnknownHostException) {
                    throw (UnknownHostException)e;
                }
            }
        } else {
            LOG.info("CACHED " + url.toString() + " at '" + f.getAbsolutePath() + "'");
        }
        return f;
    }

    public synchronized File downloadFile(URL url, String data, String name, ICancellable cancel) throws IOException, ConnectException, UnknownHostException {
        return this.downloadFile(url, data, name, cancel, -1);
    }

    public synchronized File downloadFile(URL url, String data, String name, ICancellable cancel, int maxbytes) throws IOException, ConnectException, UnknownHostException {
        return this.downloadFile(url, null, null, data, name, cancel, maxbytes);
    }

    public synchronized File downloadFile(URL url, String method, ContentType contenttype, String data, String name, ICancellable cancel) throws IOException, ConnectException, UnknownHostException {
        return this.downloadFile(url, method, contenttype, data, name, cancel, -1);
    }

    public synchronized File downloadFile(URL url, String method, ContentType contenttype, String data, String name, ICancellable cancel, int maxbytes) throws IOException, ConnectException, UnknownHostException {
        return this.downloadFile(url, method, contenttype, data, name, cancel, maxbytes, true);
    }

    public synchronized File downloadFile(URL url, String method, ContentType contenttype, String data, String name, ICancellable cancel, int maxbytes, boolean useCache) throws IOException, ConnectException, UnknownHostException {
        File target;
        LOG.info("Download file " + Objects.toString(url));
        if (useCache && (target = this.getPreviousDownloadedURL(url, data)) != null) {
            return target;
        }
        File f = this.getUniqueTemporaryFile(name);
        if (cancel == null) {
            cancel = new ICancellable(){

                public boolean isCanceled() {
                    return false;
                }

                public Object getID() {
                    return SEDownloader.class.getName();
                }
            };
        }
        SEMonitor monitorObj = new SEMonitor(this, cancel);
        Thread downloader = new Thread(this.createDownloaderTask(this, this.executorUI, url, method, contenttype, data, f, cancel.getID(), maxbytes));
        Thread monitor = new Thread(monitorObj);
        downloader.setName("Downloader_" + downloader.getId());
        monitor.setName("DownloaderMon_" + monitor.getId());
        monitor.start();
        downloader.start();
        while (!this.getCanceled(cancel.getID()) && downloader.isAlive()) {
            try {
                Thread.sleep(500L);
                this.executorUI.runCommands();
            }
            catch (InterruptedException e) {
                LOG.error("Error", (Throwable)e);
            }
        }
        try {
            monitorObj.setFinish(true);
            monitor.join();
            downloader.join();
        }
        catch (InterruptedException e1) {
            LOG.warn(e1.getMessage());
        }
        downloader = null;
        monitor = null;
        if (this.getCanceled(cancel.getID())) {
            return null;
        }
        if (this.downloadException != null) {
            Exception e = this.downloadException;
            if (e instanceof FileNotFoundException) {
                throw (IOException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof ConnectException) {
                throw (ConnectException)e;
            }
            if (e instanceof UnknownHostException) {
                throw (UnknownHostException)e;
            }
        }
        return f;
    }

    @Override
    public boolean getCanceled(Object groupId) {
        Boolean obj = this.canceledGroup.get(groupId);
        if (obj != null) {
            return obj;
        }
        return false;
    }

    @Override
    public void setCanceled(Object groupId, boolean isCanceled) {
        if (groupId == null) {
            groupId = SEDownloader.class.getName();
        }
        this.canceledGroup.put(groupId, isCanceled);
    }

    public void removeURL(URL url) {
        URI theuri = null;
        try {
            theuri = url.toURI();
        }
        catch (Exception e) {
            LOG.info("Warning: did not remove bad url: " + url, (Throwable)e);
            return;
        }
        if (this.cachedURItoFile != null && this.cachedURItoFile.containsKey(theuri)) {
            this.cachedURItoFile.remove(theuri);
        }
    }

    public void removeURL(Object url) {
        if (this.cachedURItoFile != null && this.cachedURItoFile.containsKey(url)) {
            this.cachedURItoFile.remove(url);
        }
    }

    @Override
    public void setDownloadException(Exception exception) {
        this.downloadException = exception;
    }

    @Override
    public long getLatency() {
        return this.latency;
    }

    protected Runnable createDownloaderTask(SEDownloader downloader, Executor executor, URL url, String data, File target, Object groupID, int maxbytes) {
        SEDownloaderTask t = new SEDownloaderTask(downloader, executor, url, data, target, groupID);
        t.setMaxbytes(maxbytes);
        return t;
    }

    protected Runnable createDownloaderTask(SEDownloader downloader, Executor executor, URL url, String method, ContentType contenttype, String data, File target, Object groupID, int maxbytes) {
        SEDownloaderTask t = new SEDownloaderTask(downloader, executor, url, method, contenttype, data, target, groupID);
        t.setMaxbytes(maxbytes);
        return t;
    }

    public void cleanUpTempFiles() {
        FoldersManager foldersManager = ToolsLocator.getFoldersManager();
        File folder = foldersManager.getTemporaryFile(new String[]{"downloader"});
        try {
            FileUtils.cleanDirectory((File)folder);
        }
        catch (IOException ex) {
            LOG.warn("Can't clean folder '" + folder.getAbsolutePath() + "'.", (Throwable)ex);
        }
    }

    protected File getUniqueTemporaryFile(String name) {
        FoldersManager foldersManager = ToolsLocator.getFoldersManager();
        File folder = foldersManager.getTemporaryFile(new String[]{"downloader"});
        if (!folder.exists()) {
            folder.mkdirs();
        }
        File f = foldersManager.getUniqueTemporaryFile(new String[]{"downloader", name});
        return f;
    }

    private static class ExecutorUI
    implements Executor {
        private final Queue<Runnable> queue = new ConcurrentLinkedQueue<Runnable>();

        private ExecutorUI() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(Runnable command) {
            try {
                Runnable runnable = command;
                synchronized (runnable) {
                    LOG.info("ExecuteUI add " + Objects.toString(command));
                    this.queue.add(command);
                    command.wait();
                }
            }
            catch (InterruptedException ex) {
                LOG.warn("Can't execute command", (Throwable)ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runCommands() {
            Runnable command;
            while ((command = this.queue.poll()) != null) {
                Runnable runnable = command;
                synchronized (runnable) {
                    LOG.info("ExecuteUI run " + Objects.toString(command));
                    command.run();
                    command.notifyAll();
                }
            }
        }

        public void clear() {
            this.queue.clear();
        }
    }
}

