/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.configurableactions;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.configurableactions.ActionsControllerImpl;
import org.gvsig.configurableactions.ConfigurableActionsMamager;

public class DefaultConfigurableActionsMamager
implements ConfigurableActionsMamager {
    private final Map<String, PanelActions> panelsActions = new HashMap<String, PanelActions>();

    public void addConfigurableAction(String panelid, Action action) {
        PanelActions panelActions = this.panelsActions.get(panelid);
        if (panelActions == null) {
            panelActions = new PanelActions(panelid);
            this.panelsActions.put(panelid, panelActions);
        }
        for (int i = 0; i < panelActions.size(); ++i) {
            Action currentAction = panelActions.get(i);
            if (!StringUtils.equalsIgnoreCase((CharSequence)((String)currentAction.getValue("ActionCommandKey")), (CharSequence)((String)action.getValue("ActionCommandKey")))) continue;
            panelActions.set(i, action);
            return;
        }
        panelActions.add(action);
    }

    public void removeConfigurableAction(String panelid, String actionName) {
        PanelActions panelActions = this.panelsActions.get(panelid);
        if (panelActions == null) {
            return;
        }
        for (int i = 0; i < panelActions.size(); ++i) {
            Action currentAction = panelActions.get(i);
            if (!StringUtils.equalsIgnoreCase((CharSequence)((String)currentAction.getValue("ActionCommandKey")), (CharSequence)actionName)) continue;
            panelActions.remove(i);
            return;
        }
    }

    public void removeAllConfigurableActions(String panelid) {
        PanelActions panelActions = this.panelsActions.get(panelid);
        if (panelActions == null) {
            return;
        }
        panelActions.removeAll();
    }

    public Collection<Action> getConfigurableActions(String panelid) {
        PanelActions panelActions = this.panelsActions.get(panelid);
        if (panelActions == null) {
            panelActions = new PanelActions(panelid);
            this.panelsActions.put(panelid, panelActions);
        }
        return panelActions.getActions();
    }

    public JComponent getConfigurableActionsComponent(String panelid, Object source) {
        PanelActions panelActions = this.panelsActions.get(panelid);
        if (panelActions == null) {
            panelActions = new PanelActions(panelid);
            this.panelsActions.put(panelid, panelActions);
        }
        JLabel component = new JLabel();
        ActionsControllerImpl controller = new ActionsControllerImpl(panelActions.getActions(), source, component);
        panelActions.setController(controller);
        return component;
    }

    public ConfigurableActionsMamager.ActionsController getConfigurableActionsController(String panelid) {
        PanelActions panelActions = this.panelsActions.get(panelid);
        if (panelActions == null) {
            return null;
        }
        return panelActions.getController();
    }

    public void addConfigurableActions(String panelid, Object source, JComponent component) {
        PanelActions panelActions = this.panelsActions.get(panelid);
        if (panelActions == null) {
            panelActions = new PanelActions(panelid);
            this.panelsActions.put(panelid, panelActions);
        }
        ActionsControllerImpl controller = new ActionsControllerImpl(panelActions.getActions(), source, component);
        panelActions.setController(controller);
    }

    private class PanelActions {
        List<Action> actions;
        WeakReference<ActionsControllerImpl> controller;
        private final String panelid;

        public PanelActions(String panelid) {
            this.panelid = panelid;
            this.actions = new ArrayList<Action>();
        }

        public void setController(ActionsControllerImpl controller) {
            this.controller = new WeakReference<ActionsControllerImpl>(controller);
        }

        public ActionsControllerImpl getController() {
            if (this.controller == null) {
                return null;
            }
            ActionsControllerImpl theController = (ActionsControllerImpl)this.controller.get();
            return theController;
        }

        public void updateComponent() {
            ActionsControllerImpl theController = this.getController();
            if (theController == null) {
                return;
            }
            theController.update(this.actions);
        }

        public int size() {
            return this.actions.size();
        }

        public Action get(int i) {
            return this.actions.get(i);
        }

        public void set(int i, Action action) {
            this.actions.set(i, action);
            this.updateComponent();
        }

        public void add(Action action) {
            this.actions.add(action);
            this.updateComponent();
        }

        public void remove(int i) {
            this.actions.remove(i);
            this.updateComponent();
        }

        public Collection<Action> getActions() {
            return this.actions;
        }

        private void removeAll() {
            this.actions.clear();
            this.updateComponent();
        }
    }
}

