/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.json;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import javax.json.JsonWriterFactory;
import javax.json.stream.JsonParser;
import org.gvsig.json.JsonArrayBuilder;
import org.gvsig.json.JsonArrayBuilderImpl;
import org.gvsig.json.JsonArrayImpl;
import org.gvsig.json.JsonManager;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.json.JsonObjectBuilderImpl;
import org.gvsig.json.JsonObjectImpl;
import org.gvsig.json.JsonPathContext;
import org.gvsig.json.JsonPathContextImpl;
import org.gvsig.json.SAJParser;
import org.gvsig.json.SAJParserImpl;
import org.gvsig.json.SupportFromJson;
import org.gvsig.json.serializers.DataTypeSerializer;
import org.gvsig.json.serializers.DefaultObjectSerializer;
import org.gvsig.json.serializers.DynObjectSerializer;
import org.gvsig.json.serializers.DynObjectValueItemSerializer;
import org.gvsig.json.serializers.FileSerializer;
import org.gvsig.json.serializers.LocaleSerializer;
import org.gvsig.json.serializers.TagsSerializer;
import org.gvsig.json.serializers.UriSerializer;
import org.gvsig.json.serializers.UrlSerializer;
import org.gvsig.tools.dynobject.DynClass;
import org.gvsig.tools.dynobject.DynField;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.util.GetItemWithSizeAndIterator;
import org.gvsig.tools.util.IsApplicable;

public class JsonManagerImpl
implements JsonManager {
    private final Map<String, JsonManager.JsonSerializer> serializers1;
    private final Map<String, IsApplicable> serializers2;
    private final DynObjectSerializer dynObjectSerializer = new DynObjectSerializer();

    public JsonManagerImpl() {
        this.serializers1 = new HashMap<String, JsonManager.JsonSerializer>();
        this.serializers2 = new HashMap<String, IsApplicable>();
        this.registerDefaultSerializers();
    }

    private void registerDefaultSerializers() {
        this.registerSerializer(new FileSerializer());
        this.registerSerializer(new UrlSerializer());
        this.registerSerializer(new UriSerializer());
        this.registerSerializer(new LocaleSerializer());
        this.registerSerializer(new TagsSerializer());
        this.registerSerializer(new DynObjectValueItemSerializer());
        this.registerSerializer(new DataTypeSerializer());
    }

    public static String createSerializerKey(Class aClass) {
        String key = aClass.getName();
        return key;
    }

    public static String createSerializerKey(String className) {
        String key = className;
        return key;
    }

    public void registerSerializer1(Class<? extends SupportFromJson> theClass) {
        this.registerSerializer(theClass);
    }

    public void registerSerializer2(JsonManager.JsonSerializer serializer) {
        this.registerSerializer(serializer);
    }

    public void registerSerializer(Class<? extends SupportFromJson> theClass) {
        if (theClass == null) {
            return;
        }
        if (!SupportFromJson.class.isAssignableFrom(theClass)) {
            throw new IllegalArgumentException("the class '" + theClass.getName() + "'must implement SupportFromJson");
        }
        String key = JsonManagerImpl.createSerializerKey(theClass);
        this.serializers1.put(key, new DefaultObjectSerializer(theClass));
    }

    public void registerSerializer(JsonManager.JsonSerializer serializer) {
        String key = JsonManagerImpl.createSerializerKey(serializer.getObjectClass());
        this.serializers1.put(key, serializer);
        if (serializer instanceof IsApplicable) {
            this.serializers2.put(key, (IsApplicable)serializer);
        }
    }

    public JsonManager.JsonSerializer getSerializer(Object value) {
        String key = JsonManagerImpl.createSerializerKey(value.getClass());
        JsonManager.JsonSerializer serializer1 = this.serializers1.get(key);
        if (serializer1 != null) {
            return serializer1;
        }
        for (IsApplicable serializer2 : this.serializers2.values()) {
            if (!serializer2.isApplicable(new Object[]{value})) continue;
            return (JsonManager.JsonSerializer)serializer2;
        }
        if (value instanceof DynObject) {
            return this.dynObjectSerializer;
        }
        if (File.class.isAssignableFrom(value.getClass())) {
            key = JsonManagerImpl.createSerializerKey(File.class);
            return this.serializers1.get(key);
        }
        return null;
    }

    public JsonManager.JsonSerializer getSerializer(JsonObject json) {
        String className = json.getString("__classname__", null);
        String key = JsonManagerImpl.createSerializerKey(className);
        JsonManager.JsonSerializer serializer1 = this.serializers1.get(key);
        if (serializer1 != null) {
            return serializer1;
        }
        for (IsApplicable serializer2 : this.serializers2.values()) {
            if (!serializer2.isApplicable(new Object[]{json})) continue;
            return (JsonManager.JsonSerializer)serializer2;
        }
        if (this.dynObjectSerializer.isApplicable(json)) {
            return this.dynObjectSerializer;
        }
        return null;
    }

    public JsonObjectBuilder createObjectBuilder() {
        return new JsonObjectBuilderImpl();
    }

    public JsonArrayBuilder createArrayBuilder() {
        return new JsonArrayBuilderImpl();
    }

    public JsonObject createObject(String json) {
        try {
            StringReader sr = new StringReader(json);
            JsonReader reader = Json.createReader((Reader)sr);
            JsonObject x = reader.readObject();
            return new JsonObjectImpl(x);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public JsonArray createArray(String json) {
        try {
            StringReader sr = new StringReader(json);
            JsonReader reader = Json.createReader((Reader)sr);
            JsonArray x = reader.readArray();
            return new JsonArrayImpl(x);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private String toString(JsonStructure obj) {
        StringWriter sw = new StringWriter();
        JsonWriterFactory writerFactory = Json.createWriterFactory(Collections.singletonMap("javax.json.stream.JsonGenerator.prettyPrinting", true));
        try (JsonWriter jsonWriter = writerFactory.createWriter((Writer)sw);){
            jsonWriter.write(obj);
        }
        String s = sw.toString();
        return s;
    }

    public String toString(JsonValue value) {
        if (value == null) {
            return Objects.toString(null);
        }
        switch (value.getValueType()) {
            case ARRAY: 
            case OBJECT: {
                return this.toString((JsonStructure)value);
            }
            case STRING: {
                return ((JsonString)value).getString();
            }
        }
        return value.toString();
    }

    public Object toObject(JsonObject json, String name) {
        JsonValue value = (JsonValue)json.get((Object)name);
        return this.toObject(value);
    }

    public Object toObject(JsonArray json, int index) {
        JsonValue value = (JsonValue)json.get(index);
        return this.toObject(value);
    }

    private Object createObject(JsonObject json, Object defaultValue) {
        if (json == null) {
            return defaultValue;
        }
        JsonManager.JsonSerializer serializer = this.getSerializer(json);
        if (serializer == null) {
            return defaultValue;
        }
        Object obj = serializer.toObject(json);
        if (obj == null) {
            return defaultValue;
        }
        return obj;
    }

    public Iterable<Object> toIterable(final JsonArray jsonArray) {
        if (jsonArray == null) {
            return null;
        }
        Iterable<Object> iterable = new Iterable<Object>(){

            @Override
            public Iterator<Object> iterator() {
                Iterator<Object> it = new Iterator<Object>(){
                    int current = 0;

                    @Override
                    public boolean hasNext() {
                        return this.current < jsonArray.size();
                    }

                    @Override
                    public Object next() {
                        return JsonManagerImpl.this.toObject((JsonValue)jsonArray.get(this.current++));
                    }
                };
                return it;
            }
        };
        return iterable;
    }

    public Collection<Object> toCollection(final JsonArray jsonArray) {
        if (jsonArray == null) {
            return null;
        }
        return new AbstractCollection<Object>(){

            @Override
            public Iterator<Object> iterator() {
                return new Iterator<Object>(){
                    int current = 0;

                    @Override
                    public boolean hasNext() {
                        return this.current < jsonArray.size();
                    }

                    @Override
                    public Object next() {
                        return JsonManagerImpl.this.toObject((JsonValue)jsonArray.get(this.current++));
                    }
                };
            }

            @Override
            public int size() {
                return jsonArray.size();
            }
        };
    }

    public GetItemWithSizeAndIterator<Object> toItems(final JsonArray jsonArray) {
        if (jsonArray == null) {
            return null;
        }
        GetItemWithSizeAndIterator<Object> items = new GetItemWithSizeAndIterator<Object>(){

            public int size() {
                return jsonArray.size();
            }

            public Object get(int position) {
                return JsonManagerImpl.this.toObject((JsonValue)jsonArray.get(position));
            }

            public Iterator<Object> iterator() {
                Iterator<Object> it = new Iterator<Object>(){
                    int current = 0;

                    @Override
                    public boolean hasNext() {
                        return this.current < jsonArray.size();
                    }

                    @Override
                    public Object next() {
                        return JsonManagerImpl.this.toObject((JsonValue)jsonArray.get(this.current++));
                    }
                };
                return it;
            }
        };
        return items;
    }

    public Object[] toArray(JsonArray jsonArray, Object[] a) {
        if (jsonArray == null) {
            return null;
        }
        int sz = jsonArray.size();
        if (a == null) {
            a = new Object[sz];
        } else if (a.length != sz) {
            a = Arrays.copyOf(a, sz);
        }
        for (int i = 0; i < sz; ++i) {
            JsonValue value = (JsonValue)jsonArray.get(i);
            a[i] = this.toObject(value);
        }
        return a;
    }

    public Object toObject(JsonValue value) {
        if (value == null) {
            return null;
        }
        return this.toObjectOrDefault(value, null);
    }

    public Object toObjectOrDefault(JsonValue value, Object defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        switch (value.getValueType()) {
            case ARRAY: {
                return this.toArray((JsonArray)value, new Object[0]);
            }
            case FALSE: {
                return false;
            }
            case NUMBER: {
                JsonNumber n = (JsonNumber)value;
                if (n.isIntegral()) {
                    long nlong;
                    int nint = n.intValue();
                    if ((long)nint == (nlong = n.longValue())) {
                        return nint;
                    }
                    if (n.bigDecimalValue().compareTo(new BigDecimal(nlong)) == 0) {
                        return nlong;
                    }
                    return n.bigIntegerValue();
                }
                double ndouble = n.doubleValue();
                if (n.bigDecimalValue().compareTo(new BigDecimal(ndouble)) == 0) {
                    return ndouble;
                }
                return n.bigDecimalValue();
            }
            case OBJECT: {
                return this.createObject((JsonObject)value, defaultValue);
            }
            case STRING: {
                return ((JsonString)value).getString();
            }
            case TRUE: {
                return true;
            }
            case NULL: {
                return null;
            }
        }
        return defaultValue;
    }

    public DynObject addAll(DynObject target, JsonObject json) {
        if (json == null || target == null) {
            return target;
        }
        DynClass dynClass = target.getDynClass();
        String name = null;
        try {
            for (DynField dynField : dynClass.getDynFields()) {
                name = dynField.getName();
                if (!json.containsKey((Object)name)) continue;
                target.setDynValue(name, this.toObject((JsonValue)json.get((Object)name)));
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't copy values from json to DynObject (class " + dynClass.getFullName() + ", field " + name + ").", ex);
        }
        return target;
    }

    public Map toMap(JsonObject json) {
        if (json == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String name : json.keySet()) {
            map.put(name, this.toObject((JsonValue)json.get((Object)name)));
        }
        return map;
    }

    public static JsonValue wrap(JsonValue value) {
        if (value == null) {
            return null;
        }
        if (value == JsonValue.NULL) {
            return null;
        }
        if (value instanceof JsonObject && !(value instanceof JsonObjectImpl)) {
            value = new JsonObjectImpl((JsonObject)value);
        } else if (value instanceof JsonArray && !(value instanceof JsonArrayImpl)) {
            value = new JsonArrayImpl((JsonArray)value);
        }
        return value;
    }

    public JsonObjectBuilder createObjectBuilder(String json) {
        JsonObject obj = this.createObject(json);
        return this.createObjectBuilder(obj);
    }

    public JsonObjectBuilder createObjectBuilder(JsonObject obj) {
        JsonObjectBuilder builder = this.createObjectBuilder();
        for (Map.Entry entry : obj.entrySet()) {
            builder.add((String)entry.getKey(), (JsonValue)entry.getValue());
        }
        return builder;
    }

    public JsonPathContext createJSonPathContext(JsonStructure jsonObject) {
        return new JsonPathContextImpl((JsonManager)this, jsonObject);
    }

    public JsonPathContext createJSonPathContext(String jsonObject) {
        return new JsonPathContextImpl((JsonManager)this, jsonObject);
    }

    public SAJParser createSAJParser(InputStream is, SAJParser.SAJParserHandler handler) {
        return new SAJParserImpl(is, handler);
    }

    public SAJParser createSAJParser(Reader reader, SAJParser.SAJParserHandler handler) {
        return new SAJParserImpl(reader, handler);
    }

    public SAJParser createSAJParser(JsonParser parser, SAJParser.SAJParserHandler handler) {
        return new SAJParserImpl(parser, handler);
    }
}

