/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.components.panel;

import com.jeta.forms.defaults.DefaultInitializer;
import com.jeta.forms.gui.common.FormException;
import com.jeta.forms.gui.common.FormUtils;
import com.jeta.forms.gui.form.FormAccessor;
import com.jeta.forms.gui.form.FormComponent;
import com.jeta.forms.gui.form.FormIterator;
import com.jeta.forms.gui.formmgr.FormManagerUtils;
import com.jeta.open.gui.framework.JETAPanel;
import com.jeta.open.i18n.I18N;
import com.jeta.open.i18n.I18NUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.LayoutManager;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;

public class FormPanel
extends JETAPanel {
    private HashMap m_user_objects = new HashMap();
    private FormComponent m_form_comp;
    private FocusTraversalPolicy m_focus_policy;
    private boolean m_policy_set = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FormPanel(String formPath) {
        DefaultInitializer.initialize();
        boolean designmode = FormUtils.isDesignMode();
        try {
            FormUtils.setDesignMode(false);
            FormComponent fc = FormManagerUtils.openPackagedForm(formPath);
            fc.postInitialize(this);
            this.m_form_comp = fc;
            this.addForm(fc, new BorderLayout(), "Center");
        }
        catch (Exception e) {
            BoxLayout layout = new BoxLayout(this, 1);
            this.setLayout(layout);
            JLabel error_label = new JLabel(I18N.getLocalizedMessage("Error:"));
            error_label.setForeground(Color.red);
            error_label.setAlignmentX(0.0f);
            JLabel form_label = new JLabel(formPath);
            form_label.setForeground(Color.red);
            form_label.setAlignmentX(0.0f);
            form_label.setToolTipText(formPath);
            this.add(error_label);
            this.add(form_label);
            this.add(Box.createVerticalStrut(5));
        }
        finally {
            FormUtils.setDesignMode(designmode);
        }
    }

    public FormPanel(InputStream istream) throws FormException {
        try {
            FormComponent fc;
            DefaultInitializer.initialize();
            this.m_form_comp = fc = FormManagerUtils.openForm(istream);
            this.setLayout(new BorderLayout());
            this.add((Component)fc, "Center");
        }
        catch (Exception e) {
            if (e instanceof FormException) {
                throw (FormException)e;
            }
            throw new FormException("FormPane failed to load form (.jfrm) from InputStream", e);
        }
    }

    public FormPanel(FormComponent fc) {
        DefaultInitializer.initialize();
        this.setLayout(new BorderLayout());
        this.add((Component)fc, "Center");
        fc.postInitialize(this);
        this.m_form_comp = fc;
    }

    protected void addForm(FormComponent form, LayoutManager layout, Object constraints) {
        this.setLayout(layout);
        this.add((Component)form, constraints);
    }

    public Iterator beanIterator(boolean nested) {
        return new FormIterator(this.getFormAccessor(), nested);
    }

    public Object get(String objName) {
        if (objName == null) {
            return null;
        }
        return this.m_user_objects.get(objName);
    }

    public Container getFormContainer() {
        return this.m_form_comp.getChildView().getFormContainer();
    }

    public FormAccessor getFormAccessor() {
        return this.m_form_comp.getChildView().getFormAccessor();
    }

    public FormAccessor getFormAccessor(String compName) {
        Component comp = this.getComponentByName(compName);
        if (comp instanceof FormAccessor) {
            return (FormAccessor)((Object)comp);
        }
        return null;
    }

    public void put(String objName, Object obj) {
        if (objName != null) {
            this.m_user_objects.put(objName, obj);
        }
    }

    public void revalidate() {
        if (this.m_form_comp != null) {
            this.m_form_comp.revalidate();
        }
        super.revalidate();
    }

    public void applyComponentOrientation(ComponentOrientation orientation) {
        I18NUtils.applyComponentOrientation(this, orientation);
        super.applyComponentOrientation(orientation);
    }

    public void setFocusTraversalPolicy(FocusTraversalPolicy policy) {
        super.setFocusTraversalPolicy(policy);
    }

    public void updateFocusPolicy() {
    }

    public void updateUI() {
        super.updateUI();
        if (this.m_form_comp != null) {
            this.m_form_comp.updateUI();
        }
    }
}

