/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.coreplugin;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.prefs.Preferences;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.Launcher;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.andami.PluginsManager;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.andami.plugins.config.generate.Extensions;
import org.gvsig.andami.plugins.config.generate.PluginConfig;
import org.gvsig.andami.preferences.DlgPreferences;
import org.gvsig.andami.preferences.IPreference;
import org.gvsig.andami.preferences.IPreferenceExtension;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.coreplugin.preferences.general.BrowserControlPage;
import org.gvsig.coreplugin.preferences.general.ExtensionPage;
import org.gvsig.coreplugin.preferences.general.ExtensionsPage;
import org.gvsig.coreplugin.preferences.general.FolderingPage;
import org.gvsig.coreplugin.preferences.general.GeneralPage;
import org.gvsig.coreplugin.preferences.general.IconThemePage;
import org.gvsig.coreplugin.preferences.general.NotificationsPage;
import org.gvsig.coreplugin.preferences.general.ScreenSettingsPage;
import org.gvsig.coreplugin.preferences.general.SkinPreferences;
import org.gvsig.coreplugin.preferences.general.appearance.AppearancePage;
import org.gvsig.coreplugin.preferences.network.FirewallPage;
import org.gvsig.coreplugin.preferences.network.NetworkPage;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.extensionpoint.ExtensionBuilder;
import org.gvsig.tools.extensionpoint.ExtensionPoint;
import org.gvsig.tools.extensionpoint.ExtensionPointManager;
import org.gvsig.tools.folders.FoldersManager;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.util.ToolsUtilLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreferencesExtension
extends Extension {
    public static final String PROJECTS_FOLDER_PROPERTY_NAME = "ProjectsFolder";
    public static final String DATA_FOLDER_PROPERTY_NAME = "DataFolder";
    public static final String TEMPLATES_FOLDER_PROPERTY_NAME = "TemplatesFolder";
    public static final String SYMBOL_LIBRARY_FOLDER_PROPERTY_NAME = "SymbolLibraryFolder";
    private static final Logger logger = LoggerFactory.getLogger(PreferencesExtension.class);
    private final ExtensionPointManager extensionPoints = ToolsLocator.getExtensionPointManager();
    private boolean initilizedExtensions = false;

    public void initialize() {
        this.initializeUseNativeFileChooser();
        this.initializeFoldersManager();
        this.registerIcons();
        this.initializeCoreExtensions();
        ToolsSwingLocator.getToolsSwingManager().registerDesktopPanelSizeSupplier(() -> PluginServices.getMDIManager().getInternalSize());
    }

    private void initializeUseNativeFileChooser() {
        PluginsManager pluginsManager = PluginsLocator.getManager();
        PluginServices plugin = pluginsManager.getPlugin(PreferencesExtension.class);
        DynObject pluginProperties = plugin.getPluginProperties();
        boolean useNativeFileChooser = (Boolean)pluginProperties.getDynValue("useNativeFileChooser");
        ToolsUtilLocator.getFileDialogChooserManager().setUseNativeFileChooser(useNativeFileChooser);
    }

    private void initializeFoldersManager() {
        try {
            Preferences prefs = Preferences.userRoot().node("gvsig.foldering");
            FoldersManager foldersManager = ToolsLocator.getFoldersManager();
            for (String name : new String[]{PROJECTS_FOLDER_PROPERTY_NAME, DATA_FOLDER_PROPERTY_NAME, TEMPLATES_FOLDER_PROPERTY_NAME, SYMBOL_LIBRARY_FOLDER_PROPERTY_NAME}) {
                String fname = prefs.get(name, null);
                if (StringUtils.isEmpty((CharSequence)fname)) continue;
                foldersManager.set(name, new File(fname).getAbsoluteFile());
            }
        }
        catch (Exception ex) {
            logger.warn("Can't initialize default folders in FolderManager.", (Throwable)ex);
        }
    }

    private void registerIcons() {
        IconThemeHelper.registerIcon((String)"action", (String)"edit-setup", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"application-exit", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"preferences", (String)"edit-setup-appearance", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"preferences", (String)"edit-setup-browsercontrol", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"preferences", (String)"edit-setup-dirextension", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"preferences", (String)"edit-setup-extension", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"preferences", (String)"edit-setup-extensions", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"preferences", (String)"edit-setup-general", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"preferences", (String)"edit-setup-foldering", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"preferences", (String)"edit-setup-language", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"preferences", (String)"edit-setup-screensetting", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"preferences", (String)"edit-setup-firewall", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"preferences", (String)"edit-setup-network", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"preferences", (String)"edit-setup-skin", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"preferences", (String)"edit-setup-icontheme", (Object)((Object)this));
    }

    public void execute(String actionCommand) {
        if (!this.initilizedExtensions) {
            this.initializeExtensions();
            this.initializeExtensionsConfig();
            this.initilizedExtensions = true;
        }
        if ("edit-setup".equalsIgnoreCase(actionCommand)) {
            DlgPreferences dlgPreferences = PluginServices.getDlgPreferences();
            dlgPreferences.refreshExtensionPoints();
            PluginServices.getMDIManager().addWindow((IWindow)dlgPreferences);
        } else if ("application-exit".equalsIgnoreCase(actionCommand)) {
            Launcher.closeApplication();
        }
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isVisible() {
        return true;
    }

    private void initializeCoreExtensions() {
        this.addPreferencesPage((IPreference)new GeneralPage());
        this.addPreferencesPage((IPreference)new NetworkPage());
        this.addPreferencesPage((IPreference)new FirewallPage());
        this.addPreferencesPage((IPreference)new ExtensionsPage());
        this.addPreferencesPage(new AppearancePage());
        this.addPreferencesPage((IPreference)new FolderingPage());
        this.addPreferencesPage((IPreference)new ScreenSettingsPage());
        this.addPreferencesPage((IPreference)new SkinPreferences());
        this.addPreferencesPage((IPreference)new IconThemePage());
        this.addPreferencesPage((IPreference)new NotificationsPage());
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("linux") || os.contains("unix")) {
            this.addPreferencesPage((IPreference)new BrowserControlPage());
        }
    }

    private void initializeExtensionsConfig() {
        Extensions[] exts;
        HashMap pc = Launcher.getPluginConfig();
        ArrayList<Extensions> array = new ArrayList<Extensions>();
        Iterator iter = pc.values().iterator();
        while (iter.hasNext()) {
            array.add(((PluginConfig)iter.next()).getExtensions());
        }
        for (Extensions ext1 : exts = array.toArray(new Extensions[0])) {
            for (int j = 0; j < ext1.getExtensionCount(); ++j) {
                org.gvsig.andami.plugins.config.generate.Extension ext = ext1.getExtension(j);
                this.addPreferencesPage((IPreference)new ExtensionPage(ext));
            }
        }
    }

    private void initializeExtensions() {
        Iterator i = Launcher.getExtensionIterator();
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        while (i.hasNext()) {
            IPreference[] pp;
            Object extension = i.next();
            if (!(extension instanceof IPreferenceExtension)) continue;
            IPreferenceExtension pe = (IPreferenceExtension)extension;
            try {
                pp = pe.getPreferencesPages();
            }
            catch (Throwable th) {
                logger.warn("Can't get preference pages from '" + extension.getClass().getName() + "'.", th);
                continue;
            }
            if (pp == null) {
                String msg = "Preferences page is NULL. Extension " + extension.getClass().getName() + " implements IPreferenceExtension but does not provide pref. pages. ";
                logger.info(msg);
                continue;
            }
            for (IPreference pp1 : pp) {
                try {
                    this.addPreferencesPage(pp1);
                }
                catch (Throwable th) {
                    String msg = "cant_initialize_values_for_{0}_page_in_{1}";
                    String[] params = new String[]{pp1.getTitle(), extension.getClass().getName()};
                    logger.warn(i18nManager.getTranslation(msg, params), th);
                }
            }
        }
    }

    public void addPreferencesPage(IPreference pp) {
        ExtensionPoint ep = this.extensionPoints.add("AplicationPreferences", "");
        pp.initializeValues();
        ep.append(pp.getID(), "", (ExtensionBuilder)pp);
    }

    public void postInitialize() {
        super.postInitialize();
        DlgPreferences dlgPreferences = PluginServices.getDlgPreferences();
        dlgPreferences.refreshExtensionPoints();
        dlgPreferences.storeValues();
    }
}

