/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.coreplugin.preferences.general.appearance;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.Launcher;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.andami.PluginsManager;
import org.gvsig.andami.preferences.IPreference;
import org.gvsig.andami.preferences.StoreException;
import org.gvsig.coreplugin.PreferencesExtension;
import org.gvsig.coreplugin.preferences.general.GeneralPage;
import org.gvsig.coreplugin.preferences.general.appearance.AppearancePageView;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ListElement;
import org.gvsig.tools.util.ToolsUtilLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppearancePage
extends AppearancePageView
implements IPreference {
    private static final long serialVersionUID = 9004756473020260443L;
    private static final Logger logger = LoggerFactory.getLogger(AppearancePage.class);
    public static String id = AppearancePage.class.getName();
    private ImageIcon icon;
    private boolean enableLookAndFeel = true;
    private final String defaultLookAndFeel;

    public AppearancePage() {
        this.setParentID(GeneralPage.id);
        this.installDefaultLookAndFeel();
        this.defaultLookAndFeel = Launcher.getDefaultLookAndFeel();
        String x = PluginServices.getArgumentByName((String)"enablelaf");
        this.enableLookAndFeel = x == null ? true : BooleanUtils.toBoolean((String)x);
        this.initComponents();
    }

    private void installDefaultLookAndFeel() {
        String[][] lafs;
        for (String[] laf : lafs = new String[][]{{"Plastic XP", "com.jgoodies.looks.plastic.PlasticXPLookAndFeel"}, {"Quaqua", "ch.randelshofer.quaqua.QuaquaLookAndFeel"}, {"Flat Light", "com.formdev.flatlaf.FlatLightLaf"}, {"Flat Dark", "com.formdev.flatlaf.FlatDarkLaf"}}) {
            try {
                UIManager.installLookAndFeel(laf[0], laf[1]);
            }
            catch (Throwable th) {
                logger.info("Problems installing look and feel '" + laf[1] + "'", th);
            }
        }
    }

    private UIManager.LookAndFeelInfo[] getSupportedsLookAndFeels() {
        if (!this.enableLookAndFeel) {
            return null;
        }
        ArrayList<UIManager.LookAndFeelInfo> supporteds = new ArrayList<UIManager.LookAndFeelInfo>();
        try {
            UIManager.LookAndFeelInfo[] installedLookAndFeels;
            for (UIManager.LookAndFeelInfo lookAndfeelInfo : installedLookAndFeels = UIManager.getInstalledLookAndFeels()) {
                try {
                    Class<?> lookAndFeelClass = Class.forName(lookAndfeelInfo.getClassName());
                    LookAndFeel lookAndFeel = (LookAndFeel)lookAndFeelClass.newInstance();
                    if (!lookAndFeel.isSupportedLookAndFeel() || StringUtils.equalsIgnoreCase((CharSequence)lookAndFeel.getID(), (CharSequence)"motif")) continue;
                    supporteds.add(lookAndfeelInfo);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        catch (Throwable th) {
            return null;
        }
        if (supporteds.isEmpty()) {
            return null;
        }
        Collections.sort(supporteds, new Comparator<UIManager.LookAndFeelInfo>(){

            @Override
            public int compare(UIManager.LookAndFeelInfo o1, UIManager.LookAndFeelInfo o2) {
                return StringUtils.compare((String)o1.getName(), (String)o2.getName());
            }
        });
        return supporteds.toArray(new UIManager.LookAndFeelInfo[supporteds.size()]);
    }

    private void initComponents() {
        this.icon = IconThemeHelper.getImageIcon((String)"edit-setup-appearance");
        UIManager.LookAndFeelInfo[] lafs = this.getSupportedsLookAndFeels();
        if (lafs == null) {
            this.cboLookAndFeel.setEnabled(false);
        } else {
            DefaultComboBoxModel<ListElement> model = new DefaultComboBoxModel<ListElement>();
            for (UIManager.LookAndFeelInfo laf : lafs) {
                model.addElement(new ListElement(laf.getName(), (Object)laf.getClassName()));
            }
            this.cboLookAndFeel.setModel(model);
            this.cboLookAndFeel.setEnabled(true);
            ListElement.setSelected((JComboBox)this.cboLookAndFeel, (Object)Launcher.getAndamiConfig().getLookAndFeel());
        }
        this.translateAll();
    }

    private void translateAll() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        this.lblNeedRestart.setText("(" + i18n.getTranslation("Los_cambios_efectuados_sobre_estos_valores_se_aplicaran_al_reiniciar_la_aplicacion") + ")");
        this.lbllookAndFeel.setText(i18n.getTranslation("options.general.select_theme"));
        this.chkUseNativeFileChooser.setText(i18n.getTranslation("_use_native_file_dialog_chooser"));
    }

    public boolean isResizeable() {
        return true;
    }

    public void initializeValues() {
        this.initializeDefaults();
        this.chkUseNativeFileChooser.setSelected(ToolsUtilLocator.getFileDialogChooserManager().useNativeFileChooser());
    }

    public void initializeDefaults() {
        PluginsManager pluginsManager = PluginsLocator.getManager();
        PluginServices plugin = pluginsManager.getPlugin(PreferencesExtension.class);
        DynObject pluginProperties = plugin.getPluginProperties();
        this.chkUseNativeFileChooser.setSelected((Boolean)pluginProperties.getDynValue("useNativeFileChooser"));
        if (this.cboLookAndFeel.getModel().getSize() > 0) {
            this.cboLookAndFeel.setSelectedIndex(0);
            String currentLaF = this.getCurrentLookAndFeel();
            if (!StringUtils.isEmpty((CharSequence)currentLaF)) {
                ListElement.setSelected((JComboBox)this.cboLookAndFeel, (Object)currentLaF);
            } else {
                this.cboLookAndFeel.setSelectedIndex(-1);
            }
            this.cboLookAndFeel.setEnabled(true);
        } else {
            this.cboLookAndFeel.setEnabled(false);
        }
    }

    private String getCurrentLookAndFeel() {
        String s = Launcher.getAndamiConfig().getLookAndFeel();
        if (StringUtils.isBlank((CharSequence)s)) {
            s = this.defaultLookAndFeel;
        }
        return s;
    }

    public String getID() {
        return id;
    }

    public String getTitle() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        return i18nManager.getTranslation("pref.appearance");
    }

    public JPanel getPanel() {
        return this;
    }

    public void storeValues() throws StoreException {
        String lookAndFeel;
        PluginsManager pluginsManager = PluginsLocator.getManager();
        PluginServices plugin = pluginsManager.getPlugin(PreferencesExtension.class);
        DynObject pluginProperties = plugin.getPluginProperties();
        pluginProperties.setDynValue("useNativeFileChooser", (Object)this.chkUseNativeFileChooser.isSelected());
        ToolsUtilLocator.getFileDialogChooserManager().setUseNativeFileChooser(this.chkUseNativeFileChooser.isSelected());
        if (this.cboLookAndFeel.isEnabled() && (lookAndFeel = (String)ListElement.getSelected((JComboBox)this.cboLookAndFeel)) != null) {
            Launcher.getAndamiConfig().setLookAndFeel(lookAndFeel);
        }
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public boolean isValueChanged() {
        String lookAndFeel;
        boolean changed = false;
        if (!changed) {
            boolean bl = changed = this.chkUseNativeFileChooser.isSelected() != ToolsUtilLocator.getFileDialogChooserManager().useNativeFileChooser();
        }
        if (!changed && this.cboLookAndFeel.isEnabled() && (lookAndFeel = (String)ListElement.getSelected((JComboBox)this.cboLookAndFeel)) != null) {
            changed = !lookAndFeel.equalsIgnoreCase(this.getCurrentLookAndFeel());
        }
        return changed;
    }

    public void setChangesApplied() {
    }
}

