/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator;

import java.awt.Color;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.Formatter;
import org.gvsig.tools.lang.Cloneable;
import org.gvsig.tools.util.PropertiesSupport;
import org.gvsig.tools.util.PropertiesSupportHelper;

public interface ExpressionBuilder
extends PropertiesSupport {
    public static final String OPERATOR_NOT = "NOT";
    public static final String OPERATOR_NEGATE = "NEGATE";
    public static final String OPERATOR_IS = "IS";
    public static final String OPERATOR_IS_NULL = "IS NULL";
    public static final String OPERATOR_IS_NOT_NULL = "IS NOT NULL";
    public static final String OPERATOR_AND = "AND";
    public static final String OPERATOR_OR = "OR";
    public static final String OPERATOR_EQ = "=";
    public static final String OPERATOR_NE = "<>";
    public static final String OPERATOR_GT = ">";
    public static final String OPERATOR_GE = ">=";
    public static final String OPERATOR_LT = "<";
    public static final String OPERATOR_LE = "<=";
    public static final String OPERATOR_LIKE = "LIKE";
    public static final String OPERATOR_ILIKE = "ILIKE";
    public static final String OPERATOR_ADD = "+";
    public static final String OPERATOR_SUBST = "-";
    public static final String OPERATOR_MULT = "*";
    public static final String OPERATOR_DIV = "/";
    public static final String OPERATOR_MOD = "%";
    public static final String OPERATOR_CONCAT = "||";
    public static final String OPERATOR_REGEXP = "~";
    public static final String OPERATOR_AND2 = "&&";
    public static final String OPERATOR_IN = "IN";
    public static final String OPERATOR_BETWEEN = "BETWEEN";
    public static final String FUNCTION_CASE = "CASE";
    public static final String FUNCTION_IIF = "IIF";
    public static final String FUNCTION_IF = "IF";
    public static final String FUNCTION_IFNULL = "IFNULL";
    public static final String FUNCTION_LEFT = "LEFT";
    public static final String FUNCTION_RIGHT = "RIGHT";
    public static final String FUNCTION_LOCATE = "LOCATE";
    public static final String FUNCTION_POSITION = "POSITION";
    public static final String FUNCTION_LPAD = "LPAD";
    public static final String FUNCTION_RPAD = "RPAD";
    public static final String FUNCTION_LTRIM = "LTRIM";
    public static final String FUNCTION_RTRIM = "RTRIM";
    public static final String FUNCTION_TRIM = "TRIM";
    public static final String FUNCTION_REPEAT = "REPEAT";
    public static final String FUNCTION_REPLACE = "REPLACE";
    public static final String FUNCTION_ASCII = "ASCII";
    public static final String FUNCTION_LENGHT = "LENGHT";
    public static final String FUNCTION_INSTR = "INSTR";
    public static final String FUNCTION_REVERSEINSTR = "REVERSEINSTR";
    public static final String FUNCTION_LOWER = "LOWER";
    public static final String FUNCTION_UPPER = "UPPER";
    public static final String FUNCTION_SPACE = "SPACE";
    public static final String FUNCTION_SUBSTRING = "SUBSTRING";
    public static final String FUNCTION_CONCAT = "CONCAT";
    public static final String FUNCTION_ABS = "ABS";
    public static final String FUNCTION_ACOS = "ACOS";
    public static final String FUNCTION_ASIN = "ASIN";
    public static final String FUNCTION_ATAN = "ATAN";
    public static final String FUNCTION_COS = "COS";
    public static final String FUNCTION_COSH = "COSH";
    public static final String FUNCTION_COT = "COT";
    public static final String FUNCTION_BITAND = "BITAND";
    public static final String FUNCTION_BITOR = "BITOR";
    public static final String FUNCTION_BITXOR = "BITXOR";
    public static final String FUNCTION_CEIL = "CEIL";
    public static final String FUNCTION_DEGREES = "DEGREES";
    public static final String FUNCTION_EXP = "EXP";
    public static final String FUNCTION_FLOOR = "FLOOR";
    public static final String FUNCTION_LOG = "LOG";
    public static final String FUNCTION_LOG10 = "LOG10";
    public static final String FUNCTION_PI = "PI";
    public static final String FUNCTION_POWER = "POWER";
    public static final String FUNCTION_RADIANS = "RADIANS";
    public static final String FUNCTION_RAND = "RAND";
    public static final String FUNCTION_ROUND = "ROUND";
    public static final String FUNCTION_SQRT = "SQRT";
    public static final String FUNCTION_SIGN = "SIGN";
    public static final String FUNCTION_SIN = "SIN";
    public static final String FUNCTION_SINH = "SINH";
    public static final String FUNCTION_TAN = "TAN";
    public static final String FUNCTION_TANH = "TANH";
    public static final String FUNCTION_ZERO = "ZERO";
    public static final String FUNCTION_CHR = "CHR";
    public static final String FUNCTION_MOD = "MOD";
    public static final String FUNCTION_UUID = "UUID";
    public static final String FUNCTION_COUNT = "COUNT";
    public static final String FUNCTION_MAX = "MAX";
    public static final String FUNCTION_MIN = "MIN";
    public static final String FUNCTION_SUM = "SUM";
    public static final String FUNCTION_AVG = "AVG";
    public static final String FUNCTION_DATE = "DATE";
    public static final String FUNCTION_TIME = "TIME";
    public static final String FUNCTION_TIMESTAMP = "TIMESTAMP";
    public static final String FUNCTION_TO_DATE = "TO_DATE";
    public static final String FUNCTION_TO_TIMESTAMP = "TO_TIMESTAMP";
    public static final String FUNCTION_DATEDIFF = "DATEDIFF";
    public static final String FUNCTION_DATEADD = "DATEADD";
    public static final String FUNCTION_CURRENT_TIMESTAMP = "CURRENT_TIMESTAMP";
    public static final String FUNCTION_CURRENT_TIME = "CURRENT_TIME";
    public static final String FUNCTION_CURRENT_DATE = "CURRENT_DATE";
    public static final String FUNCTION_EXTRACT = "EXTRACT";
    public static final String FUNCTION_CAST = "CAST";
    public static final String FUNCTION_DECODE = "DECODE";
    public static final String FUNCTION_ENCODE = "ENCODE";
    public static final String FUNCTION_TODOUBLE = "TODOUBLE";
    public static final String FUNCTION_TOFLOAT = "TOFLOAT";
    public static final String FUNCTION_TOINTEGER = "TOINTEGER";
    public static final String FUNCTION_TOLONG = "TOLONG";
    public static final String FUNCTION_TOSTR = "TOSTR";
    public static final String FUNCTION_TOJSON = "TO_JSON";
    public static final String FUNCTION_MAP = "MAP";
    public static final String FUNCTION_LET = "LET";
    public static final String FUNCTION_INCR = "INCR";
    public static final String FUNCTION_DECR = "DECR";
    public static final String FUNCTION_RANGE = "RANGE";
    public static final String FUNCTION_EVAL = "EVAL";
    public static final String FUNCTION_LIST = "LIST";
    public static final String FUNCTION_TUPLE = "TUPLE";
    public static final String FUNCTION_DICT = "DICT";
    @Deprecated
    public static final String FUNCTION_$CONSTANT = "$CONSTANT";
    @Deprecated
    public static final String FUNCTION_$IDENTIFIER = "$IDENTIFIER";
    public static final String FUNCTION_$HOSTEXPRESSION = "$HOSTEXPRESSION";
    public static final String FUNCTION_GETATTR = "GETATTR";
    public static final String FUNCTION_SETATTR = "SETATTR";
    public static final String FUNCTION_GETITEM = "GETITEM";
    public static final String FUNCTION_URLREAD = "URL_READ";
    public static final String FUNCTION_URLREADBYTES = "URL_READBYTES";
    public static final String FUNCTION_URL = "URL";
    public static final String FUNCTION_DESKTOPBROWSE = "DESKTOP_BROWSE";
    public static final String FUNCTION_DESKTOPOPEN = "DESKTOP_OPEN";
    public static final String FUNCTION_DESKTOPEDIT = "DESKTOP_EDIT";
    public static final String FUNCTION_CRC32 = "CRC";
    public static final String FUNCTION_MD5HEX = "MD5HEX";
    public static final String FUNCTION_COLOR = "COLOR";
    public static final String FUNCTION_JSON_VALUE = "JSON_VALUE";
    public static final int PARAMETER_TYPE_CONSTANT = 0;
    public static final int PARAMETER_TYPE_VARIABLE = 1;
    public static final Constant VALUE_NULL = new Constant(){

        @Override
        public Object value() {
            return null;
        }

        public String toString() {
            return "NULL";
        }

        @Override
        public String toString(Formatter<Value> formatter) {
            return "NULL";
        }

        @Override
        public void replace(Value target, Value replacement) {
        }

        @Override
        public void copyPropertiesFrom(PropertiesSupport properties) {
        }

        @Override
        public Value clone() throws CloneNotSupportedException {
            return this;
        }

        @Override
        public void accept(Visitor visitor, VisitorFilter filter) {
        }

        public Object getProperty(String name) {
            return null;
        }

        public void setProperty(String name, Object value) {
        }

        public Map<String, Object> getProperties() {
            return Collections.EMPTY_MAP;
        }
    };
    public static final Formatter<Value> EMPTY_FORMATTER = new Formatter<Value>(){

        @Override
        public boolean canApply(Value value) {
            return false;
        }

        @Override
        public String format(Value value) {
            return "";
        }
    };

    public static boolean isFunction(Value value, String name) {
        return value instanceof Function && StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)((Function)value).name());
    }

    public Formatter<Value> formatter();

    public String quote_for_identifiers();

    public String quote_for_strings();

    public void accept(Visitor var1, VisitorFilter var2);

    public List<Variable> variables();

    public List<String> variables_names();

    public List<Parameter> parameters();

    public List<String> parameters_names();

    public String identifier(String var1);

    public String bytearray_hex(byte[] var1);

    public String bytearray_0x(byte[] var1);

    public String bytearray_x(byte[] var1);

    public String string(String var1);

    public Value value();

    public ExpressionBuilder value(Value var1);

    public Group group(Value var1);

    public Constant bytearray(byte[] var1);

    public Variable variable(String var1);

    public Variable column(String var1);

    public Value column(String var1, String var2);

    public Parameter parameter(String var1);

    public Parameter parameter();

    public Constant constant(Object var1);

    public Constant constant(Object var1, int var2);

    public Constant constant(Object var1, Class var2);

    public Custom custom(Object var1);

    public Method method(Value var1, String var2, Value ... var3);

    public Function function(String var1, Value ... var2);

    public BinaryOperator binaryOperator(String var1, Value var2, Value var3);

    public Value toValue(String var1);

    public String repr(Object var1);

    public String toString(Formatter<Value> var1);

    public Function not(Value var1);

    public Function not_is_null(Value var1);

    public Function is_null(Value var1);

    public BinaryOperator and(Value var1, Value var2);

    public BinaryOperator and(Expression var1, Expression var2);

    public BinaryOperator and(Expression var1, Value var2);

    public BinaryOperator or(Value var1, Value var2);

    public BinaryOperator eq(Value var1, Value var2);

    public BinaryOperator ne(Value var1, Value var2);

    public BinaryOperator gt(Value var1, Value var2);

    public BinaryOperator ge(Value var1, Value var2);

    public BinaryOperator lt(Value var1, Value var2);

    public BinaryOperator le(Value var1, Value var2);

    public BinaryOperator like(Value var1, Value var2);

    public BinaryOperator ilike(Value var1, Value var2);

    public BinaryOperator add(Value var1, Value var2);

    public BinaryOperator subst(Value var1, Value var2);

    public BinaryOperator mult(Value var1, Value var2);

    public BinaryOperator div(Value var1, Value var2);

    public Function concat(Value ... var1);

    public ExpressionBuilder set(Value var1);

    public ExpressionBuilder and(Value var1);

    public ExpressionBuilder or(Value var1);

    public Function iif(Value var1, Value var2, Value var3);

    public Function ifnull(Value var1, Value var2, Value var3);

    public ExpressionBuilder createExpressionBuilder();

    public Function left(Value var1, Value var2);

    public Function right(Value var1, Value var2);

    public Function locate(Value var1, Value var2, Value var3);

    public Function position(Value var1, Value var2);

    public Function lpad(Value var1, Value var2, Value var3);

    public Function rpad(Value var1, Value var2, Value var3);

    public Function ltrim(Value var1);

    public Function rtrim(Value var1);

    public Function trim(Value var1);

    public Function repeat(Value var1, Value var2);

    public Function replace(Value var1, Value var2, Value var3);

    public Function ascii(Value var1);

    public Function lenght(Value var1);

    public Function instr(Value var1, Value var2, Value var3);

    public Function lower(Value var1);

    public Function upper(Value var1);

    public Function space(Value var1);

    public Function substring(Value var1, Value var2, Value var3);

    public Function abs(Value var1);

    public Function acos(Value var1);

    public Function asin(Value var1);

    public Function atan(Value var1);

    public Function cos(Value var1);

    public Function cosh(Value var1);

    public Function cot(Value var1);

    public Function bitand(Value var1, Value var2);

    public Function bitor(Value var1, Value var2);

    public Function bitxor(Value var1, Value var2);

    public Function ceil(Value var1);

    public Function degrees(Value var1);

    public Function exp(Value var1);

    public Function floor(Value var1);

    public Function log(Value var1);

    public Function log10(Value var1);

    public Function pi();

    public Function power(Value var1);

    public Function radians(Value var1);

    public Function rand(Value var1);

    public Function round(Value var1);

    public Function sqrt(Value var1);

    public Function sign(Value var1);

    public Function sin(Value var1);

    public Function sinh(Value var1);

    public Function tan(Value var1);

    public Function tanh(Value var1);

    public Function zero();

    public Function chr(Value var1);

    public Function decode(Value var1, Value var2);

    public Function cast(Value var1, Value var2);

    public Function cast(Value var1, int var2);

    public Function toDouble(Value var1);

    public Function toFloat(Value var1);

    public Function toLong(Value var1);

    public Function toInteger(Value var1);

    public Function toStr(Value var1);

    public Function list();

    public Function tuple();

    public Function tuple(Object ... var1);

    public Function getattr(String var1, String var2);

    public boolean isEmpty();

    public Function color(Value var1, Value var2, Value var3, Value var4);

    public Function color(Color var1);

    public Function date(Value var1);

    public Function time(Value var1);

    public Function timestamp(Value var1);

    public Function date(Date var1);

    public Function time(Date var1);

    public Function timestamp(Date var1);

    public Function date(String var1);

    public Function time(String var1);

    public Function timestamp(String var1);

    public Function to_date(Value var1, Value var2);

    public Function to_timestamp(Value var1, Value var2);

    public Function current_date();

    public Function current_time();

    public Function current_timestamp();

    public Function let(String var1, Value var2);

    public Function date_add(Value var1, Value var2, Value var3);

    public Function date_diff(Value var1, Value var2, Value var3);

    public Function extract(Value var1, Value var2);

    public String build(Formatter<Value> var1);

    public String build();

    public void setProperties(Class var1, Object ... var2);

    public Function hostexpression(Value var1);

    public static class ClassVisitorFilter
    implements VisitorFilter {
        private final Class classFilter;

        public ClassVisitorFilter(Class classFilter) {
            this.classFilter = classFilter;
        }

        @Override
        public boolean accept(Visitable visitable) {
            if (this.classFilter == null) {
                return true;
            }
            return this.classFilter.isInstance(visitable);
        }
    }

    public static abstract class AbstractValue
    implements Value {
        protected PropertiesSupportHelper properties = new PropertiesSupportHelper();

        protected AbstractValue() {
        }

        @Override
        public Value clone() throws CloneNotSupportedException {
            AbstractValue other = (AbstractValue)super.clone();
            other.properties = this.properties.clone();
            return other;
        }

        @Override
        public void copyPropertiesFrom(PropertiesSupport properties) {
            for (Map.Entry entry : properties.getProperties().entrySet()) {
                String key = (String)entry.getKey();
                Object value1 = entry.getValue();
                this.setProperty(key, value1);
            }
        }

        @Override
        public void accept(Visitor visitor, VisitorFilter filter) {
            if (filter == null || filter.accept(this)) {
                visitor.visit(this);
            }
        }

        public Map<String, Object> getProperties() {
            return this.properties.getProperties();
        }

        public Object getProperty(String name) {
            return this.properties.getProperty(name);
        }

        public void setProperty(String name, Object value) {
            this.properties.setProperty(name, value);
        }

        @Override
        public void replace(Value target, Value replacement) {
        }
    }

    public static interface BinaryOperator
    extends Function {
        @Override
        public String name();

        public Value left();

        public Value right();

        public BinaryOperator left(Value var1);

        public BinaryOperator right(Value var1);
    }

    public static interface Method
    extends Value {
        public String name();

        public Value instance();

        public List<Value> parameters();

        public Function parameter(Value var1);
    }

    public static interface Function
    extends Value {
        public String name();

        public String name(String var1);

        public List<Value> parameters();

        public Function parameter(Value var1);

        public Function format(String var1);
    }

    public static interface Parameter
    extends Value {
        public Parameter as_constant();

        public Parameter as_variable();

        public Parameter value(Object var1);

        public Parameter name(String var1);

        public int type();

        public String name();

        public Object value();

        public boolean is_constant();

        public boolean is_variable();
    }

    public static interface Variable
    extends Value,
    Comparable<Variable> {
        public String name();
    }

    public static interface Custom
    extends Value {
        public Object value();

        public Custom add(Variable var1);

        public Custom add(Parameter var1);
    }

    public static interface Constant
    extends Value {
        public Object value();
    }

    public static interface Group
    extends Value {
        public Value value();
    }

    public static interface Value
    extends Visitable,
    PropertiesSupport,
    Cloneable {
        public String toString(Formatter<Value> var1);

        public void replace(Value var1, Value var2);

        public void copyPropertiesFrom(PropertiesSupport var1);

        public Value clone() throws CloneNotSupportedException;
    }

    public static interface Visitable {
        public void accept(Visitor var1, VisitorFilter var2);
    }

    public static interface Visitor {
        public void visit(Visitable var1);
    }

    public static interface VisitorFilter {
        public boolean accept(Visitable var1);

        default public boolean skipChildren() {
            return false;
        }
    }
}

