/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.dynform.impl;

import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import org.gvsig.tools.dynform.JDynFormField;
import org.gvsig.tools.dynform.spi.dynformfield.JProblemIndicator;
import org.gvsig.tools.swing.api.Component;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.icontheme.IconTheme;

public class DefaultJProblemIndicator
implements Component,
JProblemIndicator {
    private String message = null;
    private JLabel indicator = null;
    private ImageIcon okIcon = null;
    private ImageIcon errorIcon = null;
    private Cursor defaultCursor = null;
    private Cursor handCursor = null;
    private JDynFormField field = null;

    public DefaultJProblemIndicator(JDynFormField field) {
        this.field = field;
    }

    private void initComponentIfNeed() {
        if (this.indicator == null) {
            this.indicator = new JLabel();
            IconTheme theme = ToolsSwingLocator.getIconThemeManager().getCurrent();
            this.errorIcon = theme.get("common-form-problemindicator");
            URL resource = this.getClass().getClassLoader().getResource("org/gvsig/tools/dynform/impl/images/transparent.png");
            if (resource != null) {
                this.okIcon = new ImageIcon(resource);
            }
            this.indicator.setIcon(this.okIcon);
            this.indicator.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    if (DefaultJProblemIndicator.this.message == null) {
                        return;
                    }
                    int count = evt.getClickCount();
                    if (count == 1) {
                        JOptionPane.showMessageDialog(DefaultJProblemIndicator.this.field.asJComponent(), DefaultJProblemIndicator.this.message, "Status", 1);
                    }
                }
            });
            this.defaultCursor = this.indicator.getCursor();
            this.handCursor = new Cursor(12);
        }
    }

    public JComponent asJComponent() {
        this.initComponentIfNeed();
        return this.indicator;
    }

    public void clear() {
        this.initComponentIfNeed();
        boolean fireEvent = this.message != null;
        this.message = null;
        this.indicator.setToolTipText("");
        this.indicator.setIcon(this.okIcon);
        this.indicator.setCursor(this.defaultCursor);
        if (fireEvent) {
            this.field.fireMessageEvent(this.message);
        }
    }

    public void set(String message) {
        this.initComponentIfNeed();
        this.message = message;
        this.indicator.setToolTipText(message);
        this.indicator.setIcon(this.errorIcon);
        this.indicator.setCursor(this.handCursor);
        this.field.fireMessageEvent(this.message);
    }

    public void restore() {
        if (this.message != null) {
            this.set(this.message);
        }
    }
}

