/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.library;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.gvsig.tools.exception.BaseRuntimeException;
import org.gvsig.tools.library.AbstractLibrary;
import org.gvsig.tools.library.LibrariesInitializer;
import org.gvsig.tools.library.Library;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLibrariesInitializer
implements LibrariesInitializer,
Library.TYPE {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractLibrariesInitializer.class);
    private Collection libs;
    private boolean libsLoaded = false;
    private final ClassLoader[] classLoaders;

    public AbstractLibrariesInitializer() {
        this.classLoaders = null;
    }

    public AbstractLibrariesInitializer(ClassLoader classLoader) {
        this(new ClassLoader[]{classLoader});
    }

    public AbstractLibrariesInitializer(ClassLoader[] classLoaders) {
        this.classLoaders = classLoaders;
    }

    @Override
    public void initialize() {
        this.initialize(false);
    }

    @Override
    public void initialize(boolean ignoreerrors) {
        if (!this.libsLoaded) {
            this.loadLibraries(this.classLoaders, ignoreerrors);
            this.libsLoaded = true;
        }
        if (this.libs != null && this.libs.size() > 0) {
            this.initializeLibraries(this.libs, false, ignoreerrors);
        }
    }

    @Override
    public void postInitialize() {
        this.postInitialize(false);
    }

    @Override
    public void postInitialize(boolean ignoreerrors) {
        if (!this.libsLoaded) {
            this.loadLibraries(this.classLoaders, ignoreerrors);
            this.libsLoaded = true;
        }
        if (this.libs != null && this.libs.size() > 0) {
            this.initializeLibraries(this.libs, true, ignoreerrors);
        }
    }

    @Override
    public void fullInitialize() {
        this.initialize();
        this.postInitialize();
    }

    @Override
    public void fullInitialize(boolean ignoreerrors) {
        this.initialize(ignoreerrors);
        this.postInitialize(ignoreerrors);
    }

    public List getLibraries() {
        if (!this.libsLoaded) {
            this.loadLibraries(this.classLoaders, false);
            this.libsLoaded = true;
        }
        return new ArrayList(this.libs);
    }

    private void loadLibraries(ClassLoader[] classLoaders, boolean ignoreerrors) {
        HashSet<Library> theLibs = new HashSet<Library>();
        LOG.info("Loading libraries of classloaders:");
        if (classLoaders == null) {
            this.addLibrariesOfClassLoader(theLibs, null, ignoreerrors);
        } else {
            for (ClassLoader classLoader : classLoaders) {
                this.addLibrariesOfClassLoader(theLibs, classLoader, ignoreerrors);
            }
        }
        this.updateRequireds(theLibs);
        int fullSize = theLibs.size();
        this.libs = new OrderedLibs(theLibs);
        if (LOG.isInfoEnabled()) {
            this.logLibraries(this.libs, fullSize);
        }
    }

    private void updateRequireds(Set<Library> libs) {
        for (int retries = 0; retries < 10; ++retries) {
            boolean updated = false;
            for (Library lib : libs) {
                Set<Library.Required> r0 = lib.getRequireds();
                if (r0 == null) continue;
                ArrayList<Library.Required> r1 = new ArrayList<Library.Required>(r0);
                int count = r1.size();
                for (Library.Required required : r1) {
                    Set<Library.Required> requireds;
                    Library requiredLibrary = required.getLibrary(libs);
                    if (requiredLibrary == null || (requireds = requiredLibrary.getRequireds()) == null) continue;
                    lib.require(requireds);
                }
                if (count == lib.getRequireds().size()) continue;
                updated = true;
            }
            if (!updated) break;
        }
        if (LOG.isDebugEnabled()) {
            for (Library lib : libs) {
                LOG.trace("Library: " + lib.getClass().getName());
                Set<Library.Required> r0 = lib.getRequireds();
                if (r0 == null) continue;
                for (Library.Required required : r0) {
                    LOG.trace("  require " + required.toString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLibrariesOfClassLoader(Set previousFoundLibs, ClassLoader classLoader, boolean ignoreerrors) {
        StringBuilder logBuf = new StringBuilder();
        Object library2 = null;
        try {
            Set foundLibs = this.findLibraries(Library.class, classLoader);
            this.removeLibraries(foundLibs, previousFoundLibs, classLoader);
            logBuf.append(foundLibs.size()).append(" new libraries found in the classloader ").append(classLoader == null ? "DEFAULT" : classLoader.toString()).append(":");
            for (Object library2 : foundLibs) {
                try {
                    library2.doRegistration();
                }
                catch (Throwable e) {
                    this.manageLibraryException(ignoreerrors, "doRegistration", (Library)library2, e);
                }
                previousFoundLibs.add(library2);
                logBuf.append("\n- ").append(library2);
            }
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Error finding libraries of classloader {0}. Last procesed library {1}.", classLoader == null ? "DEFAULT" : classLoader.toString(), library2 == null ? "(no-library)" : library2.toString());
            this.manageLibraryException(ignoreerrors, msg, e);
        }
        finally {
            try {
                LOG.info(logBuf.toString());
            }
            catch (Throwable throwable) {}
        }
    }

    private void removeLibraries(Set foundLibraries, Set previousFoundLibs, ClassLoader classLoader) {
        foundLibraries.removeAll(previousFoundLibs);
    }

    protected abstract Set findLibraries(Class var1, ClassLoader var2);

    private void initializeLibraries(Collection libs, boolean post, boolean ignoreerrors) {
        String label = post ? "postInitialize" : "initialize";
        for (Library lib : libs) {
            try {
                if (post) {
                    LOG.trace("Calling {}.postInitialize()", (Object)lib.getClass().getName());
                    lib.postInitialize();
                    continue;
                }
                LOG.trace("Calling {}.initialize()", (Object)lib.getClass().getName());
                lib.initialize();
            }
            catch (Throwable e) {
                this.manageLibraryException(ignoreerrors, label, lib, e);
            }
        }
    }

    private void manageLibraryException(boolean ignoreerrors, String label, Library lib, Throwable e) {
        String msg = e instanceof BaseRuntimeException ? ((BaseRuntimeException)e).getLocalizedMessageStack() : e.getLocalizedMessage();
        String formattedMsg = MessageFormat.format("Error in {0} of library {1}. {2}", label, lib.getClass().getName(), msg);
        this.manageLibraryException(ignoreerrors, formattedMsg, e);
    }

    private void manageLibraryException(boolean ignoreerrors, String message, Throwable e) {
        if (ignoreerrors) {
            LOG.error(message, e);
        } else {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
        }
    }

    private void logLibraries(Collection libs, int fullSize) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Total libraries to initialize (").append(libs == null ? 0 : libs.size()).append(" of ").append(fullSize).append("):");
        if (libs != null) {
            Iterator iterator = libs.iterator();
            while (iterator.hasNext()) {
                buffer.append("\n- ").append(iterator.next());
            }
        }
        LOG.info(buffer.toString());
    }

    private static class OrderedLibs
    extends ArrayList {
        private static final long serialVersionUID = -8546268624773345053L;
        private final Map apis = new TreeMap(new Comparator(){

            public int compare(Object o1, Object o2) {
                Class class1 = (Class)o1;
                Class class2 = (Class)o2;
                return class1.getName().compareTo(class2.getName());
            }
        });

        public OrderedLibs(Set libs) {
            this.orderLibs(libs);
        }

        private void orderLibs(Set libs) {
            for (Library library : libs) {
                LinkedList libraryGroup;
                Class<?> API = library.getLibrary();
                if (API == null) {
                    API = library.getClass();
                }
                if ((libraryGroup = (LinkedList)this.apis.get(API)) == null) {
                    libraryGroup = new LinkedList();
                    this.apis.put(API, libraryGroup);
                }
                this.addLibraryToGroup(libraryGroup, library);
            }
            HashSet alreadyAddedGroups = new HashSet();
            for (Class APIRequired : this.apis.keySet()) {
                this.addFromLibraryGroup(APIRequired, alreadyAddedGroups);
            }
        }

        private void addLibraryToGroup(List libraryGroup, Library library) {
            String type = library.getType();
            if (libraryGroup.isEmpty()) {
                libraryGroup.add(library);
                return;
            }
            if ("api".equals(type)) {
                libraryGroup.add(0, library);
            } else if ("spi".equals(type)) {
                Library first = (Library)libraryGroup.get(0);
                if ("api".equals(first.getType())) {
                    libraryGroup.add(1, library);
                } else {
                    libraryGroup.add(0, library);
                }
            } else {
                if ("impl".equals(type)) {
                    for (int i = 0; i < libraryGroup.size(); ++i) {
                        Library current = (Library)libraryGroup.get(i);
                        if (!"impl".equals(current.getType())) continue;
                        if (current.getPriority() < library.getPriority()) {
                            libraryGroup.set(i, library);
                            return;
                        }
                        return;
                    }
                    Library first = (Library)libraryGroup.get(0);
                    if ("api".equals(first.getType())) {
                        if (libraryGroup.size() == 1) {
                            libraryGroup.add(library);
                        } else {
                            Library second = (Library)libraryGroup.get(1);
                            if ("spi".equals(second.getType())) {
                                libraryGroup.add(2, library);
                            } else {
                                libraryGroup.add(1, library);
                            }
                        }
                        return;
                    }
                    if ("spi".equals(first.getType())) {
                        libraryGroup.add(1, library);
                    } else {
                        libraryGroup.add(0, library);
                    }
                    return;
                }
                for (int i = 0; i < libraryGroup.size(); ++i) {
                    Library current = (Library)libraryGroup.get(i);
                    if (!"service".equals(current.getType()) || !current.isRequired(library)) continue;
                    libraryGroup.add(i, library);
                    return;
                }
                libraryGroup.add(library);
            }
        }

        private void addFromLibraryGroup(Class APIRequired, Set alreadyAddedGroups) {
            Collection libraryGroup = (Collection)this.apis.get(APIRequired);
            if (libraryGroup != null && !alreadyAddedGroups.contains(APIRequired)) {
                alreadyAddedGroups.add(APIRequired);
                for (Library library : libraryGroup) {
                    Set<Library.Required> requireds = library.getRequireds();
                    if (requireds != null) {
                        for (AbstractLibrary.DefaultRequired defaultRequired : requireds) {
                            this.addFromLibraryGroup(defaultRequired.getLibraryClass(), alreadyAddedGroups);
                        }
                    }
                    this.add(library);
                }
            }
        }
    }
}

