/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.util;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.lang.Cloneable;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.ObservableHelper;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.persistence.PersistenceFactory;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.util.PropertiesSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesSupportHelper
implements PropertiesSupport,
Persistent,
Observable,
Cloneable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertiesSupportHelper.class);
    public static final String PROPERTY_CHANGE = "PropertyChange";
    public static final String PROPERTIES_CHANGE = "PropertiesChange";
    private Map<String, Object> properties = new HashMap<String, Object>();
    private ObservableHelper observableHelper;

    @Override
    public PropertiesSupportHelper clone() throws CloneNotSupportedException {
        PropertiesSupportHelper other = (PropertiesSupportHelper)super.clone();
        other.properties = new HashMap<String, Object>(this.properties);
        if (this.observableHelper != null) {
            other.observableHelper = this.observableHelper.clone();
        }
        return other;
    }

    @Override
    public Object getProperty(String key) {
        return this.properties.get(key.toUpperCase());
    }

    @Override
    public void setProperty(String key, Object val) {
        this.properties.put(key.toUpperCase(), val);
        if (this.observableHelper != null) {
            this.observableHelper.notifyObservers(this, PROPERTY_CHANGE, key, val);
        }
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = new HashMap<String, Object>();
        if (properties != null) {
            this.copyFrom(properties);
        }
        if (this.observableHelper != null) {
            this.observableHelper.notifyObservers(this, PROPERTIES_CHANGE, null);
        }
    }

    protected void copyFrom(Map<String, Object> properties) {
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            Object value;
            String key = entry.getKey();
            if (key == null) continue;
            try {
                value = entry.getValue();
            }
            catch (Throwable th) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.warn("Can't get property " + key + ".", th);
                } else {
                    LOGGER.warn("Can't get property " + key + ".");
                }
                value = null;
            }
            this.properties.put(key, value);
        }
    }

    @Override
    public void saveToState(PersistentState state) throws PersistenceException {
        HashMap<String, Object> toSave = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (!this.isPersistent(value)) continue;
            toSave.put(key, value);
        }
        state.set("properties", toSave);
    }

    private boolean isPersistent(Object obj) {
        if (obj instanceof Boolean || obj instanceof String || obj instanceof File || obj instanceof URL || obj instanceof URI || obj instanceof Short || obj instanceof Integer || obj instanceof Long || obj instanceof Float || obj instanceof Double) {
            return true;
        }
        PersistenceManager persistenceManager = ToolsLocator.getPersistenceManager();
        PersistenceManager.Factories factories = persistenceManager.getFactories();
        PersistenceFactory factory = factories.get(obj);
        return factory != null;
    }

    @Override
    public void loadFromState(PersistentState state) throws PersistenceException {
        this.properties = new HashMap<String, Object>();
        Map props = (Map)state.get("properties");
        if (props != null) {
            this.copyFrom(props);
        }
    }

    @Override
    public void addObserver(Observer o) {
        if (this.observableHelper == null) {
            this.observableHelper = new ObservableHelper();
        }
        this.observableHelper.addObserver(o);
    }

    @Override
    public void deleteObserver(Observer o) {
        if (this.observableHelper == null) {
            this.observableHelper = new ObservableHelper();
        }
        this.observableHelper.deleteObserver(o);
    }

    @Override
    public void deleteObservers() {
        if (this.observableHelper == null) {
            this.observableHelper = new ObservableHelper();
        }
        this.observableHelper.deleteObservers();
    }

    public static void registerPersistence() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        if (manager.getDefinition("PropertiesSupportHelper") == null) {
            DynStruct definition = manager.addDefinition(PropertiesSupportHelper.class, "PropertiesSupportHelper", "PropertiesSupportHelper Persistence definition", null, null);
            definition.addDynFieldMap("properties").setClassOfItems(Object.class).setMandatory(true);
        }
    }
}

