/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.desktop.installer.izpack;

import com.izforge.izpack.core.resource.ResourceManager;
import com.izforge.izpack.panels.process.AbstractUIProcessHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;

public class ExtractPackages {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final int EOF = -1;

    public boolean run(AbstractUIProcessHandler handler, String[] args) {
        ResourceManager rm = new ResourceManager();
        URL packagesurl = null;
        try {
            packagesurl = rm.getURL("/package.gvspks");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (packagesurl == null) {
            handler.logOutput("package.gvspks not available in the instalation.", false);
            return true;
        }
        handler.logOutput("Extracting packages (This may take a while)...", false);
        File installation_folder = new File(args[0]);
        File install_folder = new File(installation_folder, "install");
        File packages = new File(install_folder, "package.gvspks");
        try {
            install_folder.mkdir();
            InputStream packages_fis = rm.getInputStream("/package.gvspks");
            FileOutputStream packages_fos = new FileOutputStream(packages);
            this.copy(packages_fis, packages_fos, new byte[4096]);
        }
        catch (Exception ex) {
            handler.logOutput("Can't extract packages: " + ex.toString(), false);
            return false;
        }
        handler.logOutput("Packages extracted.", false);
        return true;
    }

    public long copy(InputStream input, OutputStream output, byte[] buffer) throws IOException {
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }
}

