/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.swing.impl;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.swing.AbstractListModel;
import javax.swing.SwingUtilities;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.util.LabeledValue;
import org.gvsig.tools.util.LabeledValueImpl;

class FilteredListModel
extends AbstractListModel {
    private List<LabeledValue> elements = new ArrayList<LabeledValue>();
    private List<LabeledValue> filteredElements = this.elements;
    private String filter = null;

    @Override
    public int getSize() {
        return this.filteredElements.size();
    }

    @Override
    public LabeledValue getElementAt(int index) {
        return this.filteredElements.get(index);
    }

    void addElement(LabeledValue element) {
        this.elements.add(element);
        if (this.elements != this.filteredElements) {
            this.filteredElements.add(element);
        }
    }

    void addElement(Object element) {
        this.addElement((LabeledValue)new LabeledValueImpl(Objects.toString(element, ""), element));
    }

    public void setFilter(String filter) {
        if (StringUtils.isBlank((CharSequence)filter)) {
            this.filter = null;
            this.filteredElements = this.elements;
        } else {
            if (!filter.contains("*")) {
                filter = filter + "*";
            }
            this.filter = filter;
            this.filteredElements = new ArrayList<LabeledValue>();
            for (LabeledValue element : this.elements) {
                if (!FilenameUtils.wildcardMatch((String)element.getValue().toString().toLowerCase(), (String)this.filter.toLowerCase())) continue;
                this.filteredElements.add(element);
            }
        }
        this.fireContentsChanged();
    }

    private void fireContentsChanged() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FilteredListModel.this.fireContentsChanged();
                }
            });
            return;
        }
        this.fireContentsChanged(this, 0, this.filteredElements.size());
    }

    public String getFilter() {
        return this.filter;
    }

    public void sort(boolean ascending) {
        this.sortBackground(ascending);
    }

    private void sortBackground(final boolean ascending) {
        Thread th = new Thread(new Runnable(){

            @Override
            public void run() {
                FilteredListModel.this.sortForeground(ascending);
            }
        }, "FilteredListModelSorter");
        th.start();
    }

    private void sortForeground(final boolean ascending) {
        ArrayList<LabeledValue> items = new ArrayList<LabeledValue>(this.elements);
        items.sort((Comparator<LabeledValue>)new Comparator<Comparable>(){

            @Override
            public int compare(Comparable o1, Comparable o2) {
                int r = ObjectUtils.compare((Comparable)o1, (Comparable)o2);
                if (ascending) {
                    return r;
                }
                return r * -1;
            }
        });
        this.elements = items;
        this.filteredElements = this.elements;
        if (this.filter != null) {
            this.setFilter(this.filter);
        } else {
            this.fireContentsChanged();
        }
    }
}

