/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gui.beans.treelist;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.gvsig.gui.beans.Messages;
import org.gvsig.gui.beans.treelist.event.TreeListChangeEvent;
import org.gvsig.gui.beans.treelist.listeners.TreeListChangeListener;
import org.gvsig.gui.beans.treelist.listeners.TreeListComponentListener;
import org.gvsig.gui.beans.treelist.listeners.TreeListListener;

public class TreeListContainer
extends JPanel
implements ActionListener,
TreeSelectionListener,
ListSelectionListener {
    private static final long serialVersionUID = 6665259638830401366L;
    private ArrayList<TreeListChangeListener> actionChangeListeners = new ArrayList();
    private ArrayList<TreeListComponentListener> listListeners = new ArrayList();
    private Hashtable<String, String> map = null;
    private JScrollPane pTree = null;
    private JScrollPane pList = null;
    private JTree tree = null;
    private JList list = null;
    private JButton bAdd = null;
    private JButton bDel = null;
    private JSplitPane jSplitPane1 = null;
    private JPanel jPanelButtons = null;
    private DefaultMutableTreeNode raiz = null;
    private TreeListListener listener = new TreeListListener();
    private String pathToImages = "images/";

    public TreeListContainer() {
        this.initialize();
        this.listener.setList(this.getList());
        this.listener.setTree(this.getTree());
        this.setPreferredSize(new Dimension(160, 0));
        this.getTree().addTreeSelectionListener(this);
        this.getList().addListSelectionListener(this);
    }

    private void initialize() {
        this.map = new Hashtable();
        this.raiz = new DefaultMutableTreeNode(Messages.getText("filtros"));
        this.setLayout(new BorderLayout());
        this.getPList().setMinimumSize(new Dimension(0, 60));
        this.jSplitPane1 = new JSplitPane();
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setTopComponent(this.getPTree());
        this.jSplitPane1.setBottomComponent(this.getPList());
        this.jSplitPane1.setResizeWeight(1.0);
        this.jSplitPane1.setContinuousLayout(true);
        this.add((Component)this.jSplitPane1, "Center");
        this.add((Component)this.getJPanelButtons(), "South");
    }

    public void setAddToolTipText(String text) {
        this.getAddButton().setToolTipText(text);
    }

    public void setDelToolTipText(String text) {
        this.getDelButton().setToolTipText(text);
    }

    private JButton getAddButton() {
        if (this.bAdd == null) {
            this.bAdd = new JButton();
            this.bAdd.setIcon(new ImageIcon(this.getClass().getResource(this.pathToImages + "addlayer.png")));
            this.bAdd.setPreferredSize(new Dimension(22, 19));
            this.bAdd.addActionListener(this);
        }
        return this.bAdd;
    }

    private JButton getDelButton() {
        if (this.bDel == null) {
            this.bDel = new JButton();
            this.bDel.setIcon(new ImageIcon(this.getClass().getResource(this.pathToImages + "delall.png")));
            this.bDel.setPreferredSize(new Dimension(22, 19));
            this.bDel.addActionListener(this);
        }
        return this.bDel;
    }

    private JPanel getJPanelButtons() {
        if (this.jPanelButtons == null) {
            this.jPanelButtons = new JPanel();
            this.jPanelButtons.setPreferredSize(new Dimension(0, 21));
            FlowLayout flowLayout5 = new FlowLayout();
            flowLayout5.setHgap(5);
            flowLayout5.setVgap(0);
            flowLayout5.setAlignment(1);
            this.jPanelButtons.setLayout(flowLayout5);
            this.jPanelButtons.add((Component)this.getAddButton(), null);
            this.jPanelButtons.add((Component)this.getDelButton(), null);
        }
        return this.jPanelButtons;
    }

    private JScrollPane getPTree() {
        if (this.pTree == null) {
            this.pTree = new JScrollPane();
            this.pTree.setViewportBorder(BorderFactory.createBevelBorder(1));
            this.pTree.setVerticalScrollBarPolicy(20);
            this.pTree.setViewportView(this.getTree());
        }
        return this.pTree;
    }

    private JScrollPane getPList() {
        if (this.pList == null) {
            this.pList = new JScrollPane();
            this.pList.setBorder(BorderFactory.createEtchedBorder(0));
            this.pList.setBackground(Color.white);
            this.pList.setVerticalScrollBarPolicy(20);
            this.pList.setViewportView(this.getList());
        }
        return this.pList;
    }

    public JTree getTree() {
        if (this.tree == null) {
            this.tree = new JTree(this.raiz);
            this.tree.addMouseListener(this.listener);
            this.tree.addMouseMotionListener(this.listener);
        }
        return this.tree;
    }

    public JList getList() {
        if (this.list == null) {
            DefaultListModel m = new DefaultListModel();
            this.list = new JList(m);
            this.list.setSelectionMode(0);
            this.list.addMouseListener(this.listener);
            this.list.addMouseMotionListener(this.listener);
        }
        return this.list;
    }

    public ListModel getListModel() {
        return this.list.getModel();
    }

    public void addClass(String name, int pos) {
        DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
        DefaultMutableTreeNode r = new DefaultMutableTreeNode(name);
        model.insertNodeInto(r, this.raiz, pos);
    }

    public void addEntry(String name, String parentName, String value) {
        DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
        for (int i = 0; i < model.getChildCount(this.raiz); ++i) {
            if (!model.getChild(this.raiz, i).toString().equals(parentName)) continue;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)model.getChild(this.raiz, i);
            node.add(new DefaultMutableTreeNode(name));
            if (value == null) continue;
            this.map.put(name, value);
        }
    }

    public boolean isInList(String value) {
        DefaultListModel model = (DefaultListModel)this.getList().getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            if (!((String)model.get(i)).equals(value)) continue;
            return true;
        }
        return false;
    }

    public void addTreeListListener(TreeListComponentListener e) {
        this.listListeners.add(e);
        this.listener.setListeners(this.listListeners);
    }

    public void addElementInList(String element) {
        DefaultListModel model = (DefaultListModel)this.getList().getModel();
        model.addElement(element);
    }

    public void removeElementInList(String element) {
        DefaultListModel model = (DefaultListModel)this.getList().getModel();
        model.removeElement(element);
    }

    public void removeElementInList(int element) {
        DefaultListModel model = (DefaultListModel)this.getList().getModel();
        model.remove(element);
    }

    public Hashtable getMap() {
        return this.map;
    }

    public void setMap(Hashtable map) {
        this.map = map;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.getAddButton()) {
            this.listener.insertElement();
        }
        if (e.getSource() == this.getDelButton()) {
            this.listener.deleteElement();
        }
    }

    public void addChangeSelectionListener(TreeListChangeListener listener) {
        if (!this.actionChangeListeners.contains(listener)) {
            this.actionChangeListeners.add(listener);
        }
    }

    public void removeChangeSelectionListener(TreeListChangeListener listener) {
        this.actionChangeListeners.remove(listener);
    }

    private void callActionChangeListeners(String item) {
        for (TreeListChangeListener listener : this.actionChangeListeners) {
            String name = this.map.get(item);
            if (name != null) {
                listener.actionChangeSelection(new TreeListChangeEvent(this, name));
                continue;
            }
            listener.actionChangeSelection(new TreeListChangeEvent(this, item));
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        String val;
        String[] pathTree;
        TreePath[] tp;
        String draggLabel = null;
        if (e.getSource() == this.tree && (tp = this.tree.getSelectionPaths()) != null && (pathTree = (val = tp[0].toString()).split(", ")).length > 2) {
            draggLabel = val.substring(val.lastIndexOf(", ") + 2, val.lastIndexOf("]"));
            this.callActionChangeListeners(draggLabel);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting() && this.getList().getSelectedValue() != null) {
            this.callActionChangeListeners(this.getList().getSelectedValue().toString());
        }
    }
}

