/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gui.beans.treelist.listeners;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.gvsig.gui.beans.treelist.event.TreeListEvent;
import org.gvsig.gui.beans.treelist.listeners.TreeListComponentListener;

public class TreeListListener
implements MouseListener,
MouseMotionListener,
TreeListComponentListener {
    private JTree tree = null;
    private JList list = null;
    private ArrayList listListeners = null;
    private TreeListEvent ev = new TreeListEvent();
    private String draggLabel = null;
    private boolean draggActive = false;
    private boolean enterInList = false;
    private int selectElement = -1;
    private boolean draggElement = false;

    public void setList(JList list) {
        this.list = list;
    }

    public void setTree(JTree tree) {
        this.tree = tree;
    }

    public void deleteElement() {
        if (this.list.getSelectedIndex() != -1) {
            DefaultListModel model = (DefaultListModel)this.list.getModel();
            this.ev.resetValues();
            this.ev.setElementRemoved((String)this.list.getSelectedValue());
            model.remove(this.list.getSelectedIndex());
            this.elementRemoved(this.ev);
        }
    }

    public void insertElement() {
        if (this.draggLabel != null) {
            DefaultListModel model = (DefaultListModel)this.list.getModel();
            if (model.indexOf(this.draggLabel) != -1) {
                return;
            }
            this.ev.resetValues();
            this.ev.setElementAdded(this.draggLabel);
            model.addElement(this.draggLabel);
            this.elementAdded(this.ev);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getSource() == this.list && e.getClickCount() == 2) {
            this.deleteElement();
        }
        if (e.getSource() == this.tree && e.getClickCount() == 2) {
            this.insertElement();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (e.getSource() == this.list) {
            this.enterInList = true;
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (e.getSource() == this.list) {
            this.enterInList = false;
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        TreePath[] tp;
        this.selectElement = -1;
        if (e.getSource() == this.tree && (tp = this.tree.getSelectionPaths()) != null) {
            String val = tp[0].toString();
            String[] pathTree = val.split(", ");
            this.draggLabel = pathTree.length <= 2 ? null : val.substring(val.lastIndexOf(", ") + 2, val.lastIndexOf("]"));
        }
        if (e.getSource() == this.list) {
            this.selectElement = this.list.getSelectedIndex();
            if (this.selectElement < 0) {
                return;
            }
            this.ev.resetValues();
            this.ev.setPositionSourceElement(this.selectElement);
            this.ev.setSourceElement((String)((DefaultListModel)this.list.getModel()).getElementAt(this.selectElement));
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.enterInList && this.draggLabel != null && this.draggActive) {
            this.insertElement();
            this.draggLabel = null;
        }
        if (this.draggElement && e.getSource() == this.list && this.selectElement != -1 && this.list.getSelectedIndex() != this.selectElement) {
            DefaultListModel model = (DefaultListModel)this.list.getModel();
            int posDst = this.list.getSelectedIndex();
            String elemOrig = (String)model.getElementAt(this.selectElement);
            this.ev.setPositionDestElement(posDst);
            this.ev.setDestElement((String)((DefaultListModel)this.list.getModel()).getElementAt(posDst));
            model.remove(this.selectElement);
            model.insertElementAt(elemOrig, posDst);
            this.elementMoved(this.ev);
        }
        this.draggActive = false;
        this.draggElement = false;
        this.selectElement = -1;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (e.getSource() == this.tree && this.draggLabel != null) {
            this.draggActive = true;
        }
        if (e.getSource() == this.list && this.selectElement != -1) {
            this.draggElement = true;
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    public void setListeners(ArrayList l) {
        this.listListeners = l;
    }

    @Override
    public void elementAdded(TreeListEvent e) {
        if (this.listListeners == null || this.listListeners.size() == 0) {
            return;
        }
        for (int i = 0; i < this.listListeners.size(); ++i) {
            ((TreeListComponentListener)this.listListeners.get(i)).elementAdded(e);
        }
    }

    @Override
    public void elementRemoved(TreeListEvent e) {
        if (this.listListeners == null || this.listListeners.size() == 0) {
            return;
        }
        for (int i = 0; i < this.listListeners.size(); ++i) {
            ((TreeListComponentListener)this.listListeners.get(i)).elementRemoved(e);
        }
    }

    @Override
    public void elementMoved(TreeListEvent e) {
        if (this.listListeners == null || this.listListeners.size() == 0) {
            return;
        }
        for (int i = 0; i < this.listListeners.size(); ++i) {
            ((TreeListComponentListener)this.listListeners.get(i)).elementMoved(e);
        }
    }
}

