/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.Code;
import org.gvsig.expressionevaluator.CodeBuilder;
import org.gvsig.expressionevaluator.Codes;
import org.gvsig.expressionevaluator.Compiler;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.ExpressionEvaluatorLocator;
import org.gvsig.expressionevaluator.ExpressionEvaluatorManager;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.SymbolTable;
import org.gvsig.expressionevaluator.impl.DefaultInterpreter;
import org.gvsig.expressionevaluator.spi.UndefinedSymbolException;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.visitor.VisitCanceledException;

public class HostExpressionUtils {
    public static boolean hasHostExpressions(Code statement) {
        try {
            statement.accept(code -> {
                if (!(code instanceof Code.Callable)) {
                    return;
                }
                Code.Callable callable = (Code.Callable)code;
                if (StringUtils.equalsIgnoreCase((CharSequence)callable.name(), (CharSequence)"$HOSTEXPRESSION")) {
                    throw new VisitCanceledException();
                }
            }, null);
            return false;
        }
        catch (VisitCanceledException ex) {
            return true;
        }
        catch (BaseException ex) {
            throw new RuntimeException("Can't check host expressions", ex);
        }
    }

    public static boolean hasHostExpressions(ExpressionBuilder.Value statement) {
        ArrayList hostExpressions = new ArrayList();
        statement.accept(value -> {
            if (!(value instanceof ExpressionBuilder.Function)) {
                return;
            }
            ExpressionBuilder.Function function = (ExpressionBuilder.Function)value;
            if (StringUtils.equalsIgnoreCase((CharSequence)function.name(), (CharSequence)"$HOSTEXPRESSION")) {
                hostExpressions.add(function);
            }
        }, null);
        return !hostExpressions.isEmpty();
    }

    public static boolean hasHostExpressions(String statement) {
        Compiler compiler = HostExpressionUtils.createCompiler();
        Code code = compiler.compileExpression(statement);
        return HostExpressionUtils.hasHostExpressions(code);
    }

    public static List<Code> getHostExpressions(Code statement) throws Exception {
        ArrayList<Code> hostExpressions = new ArrayList<Code>();
        statement.accept(code -> {
            if (!(code instanceof Code.Callable)) {
                return;
            }
            Code.Callable callable = (Code.Callable)code;
            if (StringUtils.equalsIgnoreCase((CharSequence)callable.name(), (CharSequence)"$HOSTEXPRESSION")) {
                hostExpressions.add((Code)callable);
            }
        }, null);
        return hostExpressions;
    }

    public static List<ExpressionBuilder.Value> getHostExpressions(ExpressionBuilder.Value statement) throws Exception {
        ArrayList<ExpressionBuilder.Value> hostExpressions = new ArrayList<ExpressionBuilder.Value>();
        ExpressionBuilder.Value newstatement = statement.clone();
        newstatement.accept(value -> {
            if (!(value instanceof ExpressionBuilder.Function)) {
                return;
            }
            ExpressionBuilder.Function function = (ExpressionBuilder.Function)value;
            if (StringUtils.equalsIgnoreCase((CharSequence)function.name(), (CharSequence)"$HOSTEXPRESSION")) {
                hostExpressions.add((ExpressionBuilder.Value)function);
            }
        }, null);
        return hostExpressions;
    }

    public static ExpressionBuilder.Value getHostExpressionValue(ExpressionBuilder.Function hostExpression, ExpressionBuilder expbuilder) {
        return HostExpressionUtils.getHostExpressionValue(hostExpression, expbuilder, null, null);
    }

    public static ExpressionBuilder.Value getHostExpressionValue(ExpressionBuilder.Function hostExpression, ExpressionBuilder expbuilder, SymbolTable symbolTable) {
        Interpreter interpreter = HostExpressionUtils.createInterpreter();
        if (symbolTable != null) {
            interpreter.setSymbolTable(symbolTable);
        }
        return HostExpressionUtils.getHostExpressionValue(hostExpression, expbuilder, null, interpreter);
    }

    public static ExpressionBuilder.Value getHostExpressionValue(ExpressionBuilder.Function hostExpression, ExpressionBuilder expbuilder, Compiler compiler, Interpreter interpreter) {
        ExpressionBuilder.Constant value;
        String mode_specifier;
        ExpressionBuilder.Value exp;
        if (expbuilder == null) {
            expbuilder = HostExpressionUtils.createExpressionBuilder();
        }
        if (compiler == null) {
            compiler = HostExpressionUtils.createCompiler();
        }
        if (interpreter == null) {
            interpreter = HostExpressionUtils.createInterpreter();
        }
        List params = hostExpression.parameters();
        switch (params.size()) {
            default: {
                exp = (ExpressionBuilder.Value)params.get(0);
                mode_specifier = "IN";
                break;
            }
            case 2: {
                exp = (ExpressionBuilder.Value)params.get(0);
                mode_specifier = Objects.toString(((ExpressionBuilder.Constant)params.get(1)).value(), "IN").toUpperCase();
            }
        }
        Code code = compiler.compileExpression(exp.toString());
        Object v = interpreter.run(code);
        switch (mode_specifier) {
            default: {
                value = expbuilder.constant(v);
                break;
            }
            case "OUT": 
            case "INOUT": {
                throw new UnsupportedOperationException("Mode OUT/INOUT not implemented");
            }
            case "ID$": {
                value = expbuilder.variable(Objects.toString(v, null));
            }
        }
        return value;
    }

    public static List<ExpressionBuilder.Value> getHostExpressionsValuesFromValues(Interpreter interpreter, List<ExpressionBuilder.Value> hostExpressions) throws Exception {
        ExpressionBuilder expbuilder = HostExpressionUtils.createExpressionBuilder();
        Compiler compiler = HostExpressionUtils.createCompiler();
        ArrayList<ExpressionBuilder.Value> values = new ArrayList<ExpressionBuilder.Value>();
        for (ExpressionBuilder.Value value : hostExpressions) {
            ExpressionBuilder.Function hostExpression = (ExpressionBuilder.Function)value;
            values.add(HostExpressionUtils.getHostExpressionValue(hostExpression, expbuilder, compiler, interpreter));
        }
        return values;
    }

    public static List<Code> getHostExpressionsValuesFromCodes(Interpreter interpreter, List<Code> hostExpressions) throws Exception {
        CodeBuilder codeBuilder = ((DefaultInterpreter)interpreter).getCodeBuilder();
        ArrayList<Code> values = new ArrayList<Code>();
        for (Code code : hostExpressions) {
            Code.Identifier replacement;
            String mode_specifier;
            Code exp;
            Code.Callable hostExpression = (Code.Callable)code;
            Codes params = hostExpression.parameters();
            switch (params.size()) {
                default: {
                    exp = (Code)params.get(0);
                    mode_specifier = "IN";
                    break;
                }
                case 2: {
                    exp = (Code)params.get(0);
                    mode_specifier = Objects.toString(((Code.Constant)params.get(1)).value(), "IN").toUpperCase();
                }
            }
            try {
                Object v = interpreter.run(exp);
                switch (mode_specifier) {
                    default: {
                        ExpressionEvaluatorManager manager = ExpressionEvaluatorLocator.getExpressionEvaluatorManager();
                        replacement = manager.convertToCode(codeBuilder, v, null);
                        break;
                    }
                    case "OUT": 
                    case "INOUT": {
                        throw new UnsupportedOperationException("Mode OUT/INOUT not implemented");
                    }
                    case "ID$": {
                        replacement = codeBuilder.identifier(Objects.toString(v, null));
                        break;
                    }
                }
            }
            catch (UndefinedSymbolException ex) {
                replacement = null;
            }
            values.add((Code)replacement);
        }
        return values;
    }

    public static Code resolveHostExpressions(Code statement, Interpreter interpreter) {
        try {
            if (statement.code() == 2) {
                if (StringUtils.equalsIgnoreCase((CharSequence)"BLOCK", (CharSequence)((Code.Callable)statement).name())) {
                    return statement;
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)"BLOCK_EXCEPT", (CharSequence)((Code.Callable)statement).name())) {
                    return statement;
                }
            }
            if (!HostExpressionUtils.hasHostExpressions(statement)) {
                return statement;
            }
            Code newstatement = statement.clone();
            List<Code> hostExpressions = HostExpressionUtils.getHostExpressions(newstatement);
            if (hostExpressions.isEmpty()) {
                return statement;
            }
            List<Code> replacements = HostExpressionUtils.getHostExpressionsValuesFromCodes(interpreter, hostExpressions);
            for (int i = 0; i < hostExpressions.size(); ++i) {
                Code hostExpression = hostExpressions.get(i);
                Code value = replacements.get(i);
                if (value == null) continue;
                newstatement.replace(hostExpression, value);
            }
            return newstatement;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't resolve host expressions", ex);
        }
    }

    public static ExpressionBuilder.Value resolveHostExpressions(ExpressionBuilder.Value statement, SymbolTable symbolTable) {
        try {
            if (!HostExpressionUtils.hasHostExpressions(statement)) {
                return statement;
            }
            ExpressionBuilder.Value newstatement = statement.clone();
            List<ExpressionBuilder.Value> hostExpressions = HostExpressionUtils.getHostExpressions(newstatement);
            if (hostExpressions.isEmpty()) {
                return statement;
            }
            Interpreter interpreter = HostExpressionUtils.createInterpreter();
            if (symbolTable != null) {
                interpreter.setSymbolTable(symbolTable);
            }
            List<ExpressionBuilder.Value> replacements = HostExpressionUtils.getHostExpressionsValuesFromValues(interpreter, hostExpressions);
            for (int i = 0; i < hostExpressions.size(); ++i) {
                ExpressionBuilder.Value hostExpression = hostExpressions.get(i);
                ExpressionBuilder.Value value = replacements.get(i);
                newstatement.replace(hostExpression, value);
            }
            return newstatement;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't resolve host expressions", ex);
        }
    }

    public static Code resolveHostExpressions(Code statement, SymbolTable symbolTable) {
        try {
            if (!HostExpressionUtils.hasHostExpressions(statement)) {
                return statement;
            }
            Code newstatement = statement.clone();
            List<Code> hostExpressions = HostExpressionUtils.getHostExpressions(newstatement);
            if (hostExpressions.isEmpty()) {
                return statement;
            }
            Interpreter interpreter = HostExpressionUtils.createInterpreter();
            if (symbolTable != null) {
                interpreter.setSymbolTable(symbolTable);
            }
            List<Code> replacements = HostExpressionUtils.getHostExpressionsValuesFromCodes(interpreter, hostExpressions);
            for (int i = 0; i < hostExpressions.size(); ++i) {
                Code hostExpression = hostExpressions.get(i);
                Code value = replacements.get(i);
                newstatement.replace(hostExpression, value);
            }
            return newstatement;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't resolve host expressions", ex);
        }
    }

    public static Expression resolveHostExpressions(Expression expression, SymbolTable symbolTable) {
        Code newcode = HostExpressionUtils.resolveHostExpressions(expression.getCode(), symbolTable);
        if (newcode == expression.getCode()) {
            return expression;
        }
        Expression exp = HostExpressionUtils.createExpression();
        exp.setPhrase(newcode.toValue().toString());
        return exp;
    }

    private static Compiler createCompiler() {
        ExpressionEvaluatorManager manager = ExpressionEvaluatorLocator.getExpressionEvaluatorManager();
        return manager.createCompiler();
    }

    private static Interpreter createInterpreter() {
        ExpressionEvaluatorManager manager = ExpressionEvaluatorLocator.getExpressionEvaluatorManager();
        return manager.createInterpreter();
    }

    private static ExpressionBuilder createExpressionBuilder() {
        ExpressionEvaluatorManager manager = ExpressionEvaluatorLocator.getExpressionEvaluatorManager();
        return manager.createExpressionBuilder();
    }

    private static Expression createExpression() {
        ExpressionEvaluatorManager manager = ExpressionEvaluatorLocator.getExpressionEvaluatorManager();
        return manager.createExpression();
    }
}

