/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.date;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang3.Range;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.spi.AbstractFunction;

public class DateFunction
extends AbstractFunction {
    public DateFunction() {
        super("Date", "DATE", Range.is((Comparable)Integer.valueOf(1)), "Returns a date from the arguments", "DATE {{date}} ", new String[]{"date - a string with a date"}, "Date", true);
    }

    public boolean allowConstantFolding() {
        return true;
    }

    public Object call(Interpreter interpreter, Object[] args) {
        Object date_obj = this.getObject(args, 0);
        if (date_obj instanceof Date) {
            java.sql.Date x = new java.sql.Date(((Date)date_obj).getTime());
            return x;
        }
        String date = this.getStr(args, 0);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date x0 = df.parse(date);
            java.sql.Date x = new java.sql.Date(x0.getTime());
            return x;
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't parse date value '" + date + "', expected format 'yyyy-MM-dd'.", ex);
        }
    }

    public String template() {
        java.sql.Date now = new java.sql.Date(System.currentTimeMillis());
        return "DATE '{{" + now.toString() + "}}'";
    }
}

