/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.string;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Range;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.spi.AbstractFunction;

public class FormatFunction
extends AbstractFunction {
    public FormatFunction() {
        super("String", "FORMAT", Range.between((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(Integer.MAX_VALUE)), "The function format produces output formatted according to a format string, in a style similar to the C function sprintf", "FORMAT({{format_string}} ,arg1 ,arg2 ,arg3...)", null, "String", true);
    }

    public boolean allowConstantFolding() {
        return true;
    }

    public Object call(Interpreter interpreter, Object[] args) throws Exception {
        String format = this.getStr(args, 0);
        Object[] argsformat = ArrayUtils.subarray((Object[])args, (int)1, (int)args.length);
        String value = String.format(format, argsformat);
        return value;
    }
}

