/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.andami;

import java.awt.Image;
import java.net.URL;
import javax.swing.ImageIcon;
import org.gvsig.andami.PluginServices;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.icontheme.IconTheme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IconThemeHelper {
    private static Logger logger = LoggerFactory.getLogger(IconThemeHelper.class);

    public static void registerIcon(String group, String name, Object obj) {
        IconThemeHelper.registerIcon(group, null, name, obj);
    }

    public static void registerIcon(String group, String subgroup, String name, Object obj) {
        String provider;
        ClassLoader loader;
        IconTheme iconTheme = ToolsSwingLocator.getIconThemeManager().getDefault();
        String resourceName = group == null || group.trim().length() == 0 ? "images/" + name + ".png" : "images/" + group + "/" + name + ".png";
        if (obj instanceof Class) {
            loader = ((Class)obj).getClassLoader();
            provider = ((Class)obj).getName();
        } else {
            loader = obj.getClass().getClassLoader();
            provider = obj.getClass().getName();
        }
        PluginServices plugin = PluginServices.getPluginServices(obj);
        if (plugin != null) {
            provider = plugin.getPluginName();
        }
        URL resource = null;
        try {
            resource = loader.getResource(resourceName);
            if (resource == null) {
                resourceName = group == null || group.trim().length() == 0 ? "images/" + name + ".gif" : "images/" + group + "/" + name + ".gif";
                resource = loader.getResource(resourceName);
            }
            iconTheme.registerDefault(provider, group, subgroup, name, null, resource);
        }
        catch (Throwable e) {
            logger.info("Can't register icon '" + name + "'.", e);
        }
    }

    public static ImageIcon getImageIcon(String iconName) {
        return PluginServices.getIconTheme().get(iconName);
    }

    public static Image getImage(String iconName) {
        return PluginServices.getIconTheme().get(iconName).getImage();
    }
}

