/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.andami.actioninfo.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.andami.actioninfo.ActionInfo;
import org.gvsig.andami.actioninfo.ActionInfoManager;
import org.gvsig.andami.actioninfo.ActionInfoStatusCache;
import org.gvsig.andami.actioninfo.impl.DefaultActionInfo;
import org.gvsig.andami.actioninfo.impl.DefaultActionInfoStatusCache;
import org.gvsig.andami.actioninfo.impl.TranslatedActionInfo;
import org.gvsig.andami.plugins.IExtension;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.identitymanagement.SimpleIdentityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultActionInfoManager
implements ActionInfoManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultActionInfoManager.class);
    private final Map<String, ActionInfo> actions = new HashMap<String, ActionInfo>();
    private int anonymousCounter = 1;
    private Properties activeStates = null;
    private boolean allDisabled;

    @Override
    public ActionInfo createAction(Class<? extends IExtension> extension, String name, String text, String command, String icon, String accelerator, long position, String tip) {
        DefaultActionInfo action;
        ActionInfo previous;
        String actionName = name;
        if (StringUtils.isBlank((CharSequence)actionName)) {
            actionName = String.format("anonymous__%04d", this.anonymousCounter++);
        }
        if ((previous = this.getAction((action = new DefaultActionInfo(extension, actionName, text, command, icon, accelerator, position, tip)).getName())) != null) {
            action.merge(previous);
        }
        if (name == null) {
            LOGGER.info("createAction: name of action is null/empty, rename to '" + actionName + "' (" + ((Object)action).toString() + ").");
        }
        if (action.getLabel() == null && action.getIconName() == null) {
            LOGGER.info("createAction(name='" + name + "'): text and icon of action is null");
        }
        return action;
    }

    @Override
    public ActionInfo createAction(IExtension extension, String name, String text, String command, String icon, String accelerator, long position, String tip) {
        DefaultActionInfo action;
        ActionInfo previous;
        String actionName = name;
        if (StringUtils.isBlank((CharSequence)actionName)) {
            actionName = String.format("anonymous__%04d", this.anonymousCounter++);
        }
        if ((previous = this.getAction((action = new DefaultActionInfo(extension, actionName, text, command, icon, accelerator, position, tip)).getName())) != null) {
            action.merge(previous);
        }
        if (name == null) {
            LOGGER.info("createAction: name of action is null/empty, rename to '" + actionName + "' (" + ((Object)action).toString() + ").");
        }
        if (action.getLabel() == null && action.getIconName() == null) {
            LOGGER.info("createAction(name='" + name + "'): text and icon of action is null");
        }
        return action;
    }

    @Override
    public ActionInfo registerAction(ActionInfo action) {
        return this.registerAction(action, false);
    }

    @Override
    public ActionInfo registerAction(ActionInfo action, boolean override) {
        if (action == null) {
            try {
                throw new IllegalArgumentException();
            }
            catch (IllegalArgumentException e) {
                LOGGER.info("registerAction(null).", (Throwable)e);
                return null;
            }
        }
        ActionInfo previous = this.getAction(action.getName());
        if (previous != null) {
            if (override) {
                this.actions.put(action.getName(), action);
            } else {
                ((DefaultActionInfo)previous).merge(action);
                action = previous;
            }
        } else {
            this.actions.put(action.getName(), action);
            SimpleIdentityManager identityManager = ToolsLocator.getIdentityManager();
            identityManager.registerAction(action.getName());
        }
        this.updateActiveState(action);
        return action;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateActiveState(ActionInfo action) {
        if (this.activeStates == null) {
            this.activeStates = new Properties();
            File home = PluginsLocator.getManager().getApplicationHomeFolder();
            File states = new File(home, "actions-states.properties");
            if (states.exists()) {
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(states);
                    this.activeStates.load(fis);
                }
                catch (Exception ex) {
                    try {
                        LOGGER.warn("Can't load actions states from '" + states.getAbsolutePath() + "'.", (Throwable)ex);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(fis);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)fis);
                }
                IOUtils.closeQuietly((InputStream)fis);
            }
        }
        Boolean active = BooleanUtils.toBooleanObject((String)this.activeStates.getProperty(action.getName(), "true"));
        action.setActive(active);
    }

    @Override
    public ActionInfo getAction(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            try {
                throw new IllegalArgumentException();
            }
            catch (IllegalArgumentException e) {
                LOGGER.info("getAction(null/empty) return null.", (Throwable)e);
                return null;
            }
        }
        return this.actions.get(name);
    }

    @Override
    public Iterator<ActionInfo> getActions() {
        ArrayList<ActionInfo> theActions = new ArrayList<ActionInfo>();
        theActions.addAll(this.actions.values());
        Collections.sort(theActions, (arg0, arg1) -> {
            String s0 = String.format("%s/%012d", arg0.getPluginName(), arg0.getPosition());
            String s1 = String.format("%s/%012d", arg1.getPluginName(), arg1.getPosition());
            return s0.compareTo(s1);
        });
        return theActions.iterator();
    }

    @Override
    public ActionInfoStatusCache createActionStatusCache() {
        return new DefaultActionInfoStatusCache();
    }

    @Override
    public void redirect(String sourceName, String targetName) {
        ActionInfo source = this.getAction(sourceName);
        if (source == null) {
            throw new IllegalArgumentException("Can't locate source action '" + sourceName + "'.");
        }
        ActionInfo target = this.getAction(targetName);
        if (target == null) {
            throw new IllegalArgumentException("Can't locate target action '" + targetName + "'.");
        }
        source.getRedirections().add(target);
    }

    @Override
    public void execute(String actionName, Object[] parameters) {
        ActionInfo action = this.actions.get(actionName);
        if (action == null) {
            return;
        }
        action.execute(parameters);
    }

    @Override
    public ActionInfo getTranslated(ActionInfo actionInfo) {
        return new TranslatedActionInfo(actionInfo);
    }

    @Override
    public void setAllDisabled(boolean enabled) {
        this.allDisabled = enabled;
    }

    @Override
    public boolean isAllDisabled() {
        return this.allDisabled;
    }
}

