/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.dynobject.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.AbstractDynMethod;
import org.gvsig.tools.dynobject.DynClass;
import org.gvsig.tools.dynobject.DynClassName;
import org.gvsig.tools.dynobject.DynClass_v2;
import org.gvsig.tools.dynobject.DynField;
import org.gvsig.tools.dynobject.DynMethod;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.DynObjectException;
import org.gvsig.tools.dynobject.DynObjectManager;
import org.gvsig.tools.dynobject.DynObjectValueItem;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.dynobject.Tags;
import org.gvsig.tools.dynobject.exception.DynClassNotFoundException;
import org.gvsig.tools.dynobject.exception.DynFieldNotFoundException;
import org.gvsig.tools.dynobject.exception.DynFieldValidateException;
import org.gvsig.tools.dynobject.exception.DynMethodException;
import org.gvsig.tools.dynobject.exception.DynMethodNotSupportedException;
import org.gvsig.tools.dynobject.exception.DynObjectValidateException;
import org.gvsig.tools.dynobject.impl.DefaultDynClassName;
import org.gvsig.tools.dynobject.impl.DefaultDynField;
import org.gvsig.tools.dynobject.impl.DefaultTags;
import org.gvsig.tools.exception.ListBaseException;
import org.gvsig.tools.script.Script;

public class DefaultDynClass
implements DynClass_v2 {
    DynObjectManager manager;
    private DynClassName name;
    private String description;
    private boolean isAnonymous;
    private Map classes;
    private Map declaredFieldsMap;
    private Map declaredMethodsMap;
    private DefaultDynClass[] superClasses;
    private Map superClassesMap;
    private DynField[] declaredFields;
    private Map fieldsMap;
    private DynField[] fields;
    private DynMethod[] declaredMethods;
    private Map methodsMap;
    private DynMethod[] methods;
    private final Tags tags = new DefaultTags();
    private String label = null;
    private Script script = null;

    public DefaultDynClass(String name) {
        this((DynObjectManager)null, (DynClassName)null, (String)null);
        this.setName(new DefaultDynClassName(name));
    }

    public DefaultDynClass(DynObjectManager manager, String name, String description) {
        this(manager, null, name, description);
    }

    public DefaultDynClass(DynObjectManager manager, String namespace, String name, String description) {
        this(manager, manager.createDynClassName(namespace, name), description);
    }

    public DefaultDynClass(DynObjectManager manager, DynClassName name, String description) {
        if (manager == null) {
            manager = ToolsLocator.getDynObjectManager();
        }
        this.isAnonymous = false;
        this.classes = new LinkedHashMap();
        this.declaredFieldsMap = new HashMap();
        this.declaredMethodsMap = new HashMap();
        this.forceConsolide();
        this.manager = manager;
        this.name = name;
        this.description = description;
    }

    public void setName(DynClassName name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name.getName();
    }

    @Override
    public String getNamespace() {
        return this.name.getNamespace();
    }

    @Override
    public String getFullName() {
        return this.name.getFullName();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("DynClass").append("[").append(this.hashCode()).append("]").append("( ").append("name='").append(this.getFullName()).append("', ").append("fields='").append(this.declaredFieldsMap.toString()).append(" )");
        return buffer.toString();
    }

    public DefaultDynClass(DynObjectManager manager, String name, String description, DynClass[] superClases) {
        this(manager, name, description);
        for (DynClass dynClass : superClases) {
            if (this.classes.containsKey(dynClass.getFullName())) continue;
            this.classes.put(dynClass.getFullName(), dynClass);
        }
    }

    public DynObjectManager getManager() {
        return this.manager;
    }

    @Override
    public Script getScript() {
        return this.script;
    }

    @Override
    public void setScript(Script script) {
        this.script = script;
    }

    public synchronized void consolide() {
        this.superClasses = this.buildSuperDynClassSet().toArray(new DefaultDynClass[0]);
        this.declaredFields = this.declaredFieldsMap.values().toArray(new DynField[0]);
        this.declaredMethods = this.declaredMethodsMap.values().toArray(new DynMethod[0]);
        this.fieldsMap = new LinkedHashMap();
        int index = 0;
        for (DynField dynField : this.declaredFields) {
            this.fieldsMap.put(dynField.getName().toLowerCase(), new FieldAndIndex(dynField, index++));
        }
        for (DefaultDynClass defaultDynClass : this.superClasses) {
            for (DynField field : defaultDynClass.declaredFieldsMap.values()) {
                if (this.fieldsMap.containsKey(field.getName().toLowerCase())) continue;
                this.fieldsMap.put(field.getName().toLowerCase(), new FieldAndIndex(field, index++));
            }
        }
        this.methodsMap = new LinkedHashMap();
        index = 0;
        for (DynMethod dynMethod : this.declaredMethods) {
            this.methodsMap.put(dynMethod.getName().toLowerCase(), new MethodAndIndex(dynMethod, index++));
        }
        for (DefaultDynClass defaultDynClass : this.superClasses) {
            for (DynMethod method : defaultDynClass.declaredMethodsMap.values()) {
                if (this.methodsMap.containsKey(method.getName().toLowerCase())) continue;
                this.methodsMap.put(method.getName().toLowerCase(), new MethodAndIndex(method, index++));
            }
        }
        this.fields = new DynField[this.fieldsMap.size()];
        int i = 0;
        for (FieldAndIndex findex : this.fieldsMap.values()) {
            DefaultDynField defaultDynField = findex.getDynField();
            this.fields[i++] = defaultDynField;
        }
        this.methods = new DynMethod[this.methodsMap.size()];
        i = 0;
        for (MethodAndIndex mindex : this.methodsMap.values()) {
            DynMethod dynMethod = mindex.getDynMethod();
            this.methods[i++] = dynMethod;
        }
        this.superClassesMap = new HashMap();
        for (i = 0; i < this.superClasses.length; ++i) {
            this.superClassesMap.put(this.superClasses[i].getFullName(), this.superClasses[i]);
        }
    }

    private synchronized void forceConsolide() {
        this.superClasses = null;
        this.superClassesMap = null;
        this.declaredFields = null;
        this.fieldsMap = null;
        this.fields = null;
        this.declaredMethods = null;
        this.methodsMap = null;
        this.methods = null;
    }

    private Set buildSuperDynClassSet() {
        LinkedHashSet dynClassParents = new LinkedHashSet();
        this.buildSuperDynClassList(this, dynClassParents);
        return dynClassParents;
    }

    private void buildSuperDynClassList(DefaultDynClass dynClass, Set allParents) {
        Collection values = dynClass.classes.values();
        for (DynClass dc : values) {
            allParents.add(dc);
        }
        for (DynClass dc : values) {
            this.buildSuperDynClassList((DefaultDynClass)dc, allParents);
        }
    }

    public Map createValues(Map oldValues) {
        if (this.fields == null) {
            this.consolide();
        }
        HashMap extended = new HashMap();
        if (oldValues != null) {
            extended.putAll(oldValues);
        }
        return extended;
    }

    public void extendAll(String[] structNames) {
        if (structNames == null) {
            return;
        }
        for (String structName : structNames) {
            DynClass dynStruct = this.manager.get(structName);
            if (dynStruct == null) {
                throw new DynClassNotFoundException(structName);
            }
            if (this.classes.containsKey(dynStruct.getFullName())) continue;
            this.classes.put(dynStruct.getFullName(), dynStruct);
        }
        this.forceConsolide();
    }

    @Override
    public void extend(DynStruct dynStruct) {
        if (this.classes.containsKey(dynStruct.getFullName())) {
            return;
        }
        this.classes.put(dynStruct.getFullName(), dynStruct);
        this.forceConsolide();
    }

    @Override
    public void extend(String structName) {
        DynClass dynClass = this.manager.get(structName);
        if (dynClass == null) {
            throw new DynClassNotFoundException(structName);
        }
        this.extend(dynClass);
    }

    @Override
    public void extend(String namespace, String structame) {
        DynClass dynClass = this.manager.get(namespace, structame);
        if (dynClass == null) {
            throw new DynClassNotFoundException(new DefaultDynClassName(structame).getFullName());
        }
        this.extend(dynClass);
    }

    public int getFieldIndex(String name) {
        FieldAndIndex f;
        if (this.fieldsMap == null) {
            this.consolide();
        }
        if ((f = (FieldAndIndex)this.fieldsMap.get(name.toLowerCase())) == null) {
            return -1;
        }
        return f.index;
    }

    @Override
    public DynField getDeclaredDynField(String name) {
        return (DynField)this.declaredFieldsMap.get(name.toLowerCase());
    }

    @Override
    public DynField[] getDeclaredDynFields() {
        return this.declaredFields;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public DynField getDynField(String name) {
        FieldAndIndex findex;
        if (this.fieldsMap == null) {
            this.consolide();
        }
        return (findex = (FieldAndIndex)this.fieldsMap.get(name.toLowerCase())) == null ? null : findex.getDynField();
    }

    public FieldAndIndex getDynFieldAndIndex(String name) {
        if (this.fieldsMap == null) {
            this.consolide();
        }
        return (FieldAndIndex)this.fieldsMap.get(name.toLowerCase());
    }

    @Override
    public DynField[] getDynFields() {
        if (this.fields == null) {
            this.consolide();
        }
        return this.fields;
    }

    @Override
    public DynField addDynField(String name) {
        DefaultDynField field = new DefaultDynField(name, 8);
        return this.addDynField(field);
    }

    @Override
    public DynField addDynField(String name, int type) {
        DefaultDynField field = new DefaultDynField(name, type);
        return this.addDynField(field);
    }

    public DynField addDynField(DynField field) {
        this.declaredFieldsMap.put(field.getName().toLowerCase(), field);
        try {
            if (field.getOder() == 0) {
                field.setOrder(this.declaredFieldsMap.size() + 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.forceConsolide();
        return field;
    }

    @Override
    public DynClass[] getSuperDynClasses() {
        if (this.superClasses == null) {
            this.consolide();
        }
        return this.superClasses;
    }

    @Override
    public DynStruct[] getSuperDynStructs() {
        return this.getSuperDynClasses();
    }

    @Override
    public DynObject newInstance() {
        return this.manager.createDynObject(this);
    }

    @Override
    public boolean isInstance(DynObject dynObject) {
        DefaultDynClass objClass;
        if (this.superClassesMap == null) {
            this.consolide();
        }
        if (this.superClassesMap.containsKey((objClass = (DefaultDynClass)dynObject.getDynClass()).getFullName())) {
            return true;
        }
        if (this.getFullName().equals(objClass.getFullName())) {
            return true;
        }
        if (objClass.isAnonymous) {
            for (DynClass dc : objClass.classes.values()) {
                if (!this.superClassesMap.containsKey(dc.getFullName())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void removeDynField(String name) {
        this.declaredFieldsMap.remove(name.toLowerCase());
        this.forceConsolide();
    }

    public void setAnonymous(boolean isAnonymous) {
        this.isAnonymous = isAnonymous;
    }

    public boolean isAnonymous() {
        return this.isAnonymous;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DynClass) {
            return this.getFullName().equals(((DynClass)obj).getFullName());
        }
        return false;
    }

    @Override
    public void addDynMethod(DynMethod dynMethod) {
        this.manager.registerDynMethod(this, dynMethod);
    }

    void addMethod(DynMethod dynMethod) {
        this.declaredMethodsMap.put(dynMethod.getName().toLowerCase(), dynMethod);
        this.forceConsolide();
    }

    @Override
    public DynMethod getDeclaredDynMethod(String name) {
        return (DynMethod)this.declaredMethodsMap.get(name.toLowerCase());
    }

    @Override
    public DynMethod[] getDeclaredDynMethods() {
        if (this.declaredMethods == null) {
            this.consolide();
        }
        return this.declaredMethods;
    }

    @Override
    public DynMethod getDynMethod(String name) throws DynMethodException {
        MethodAndIndex mindex;
        if (this.methodsMap == null) {
            this.consolide();
        }
        if ((mindex = (MethodAndIndex)this.methodsMap.get(name.toLowerCase())) != null) {
            return mindex.getDynMethod();
        }
        if (this.script == null || StringUtils.isEmpty((CharSequence)this.script.getCode())) {
            return null;
        }
        return new ScriptMethod(this.script, name);
    }

    @Override
    public DynMethod getDynMethod(int code) throws DynMethodException {
        return this.manager.getDynMethod(code);
    }

    @Override
    public DynMethod[] getDynMethods() {
        if (this.methods == null) {
            this.consolide();
        }
        return this.methods;
    }

    @Override
    public void removeDynMethod(String name) {
    }

    @Override
    public void validate(DynObject object) throws DynObjectValidateException {
        DynField[] fields = this.getDynFields();
        DynObjectValidateException exceptions = new DynObjectValidateException(this.getFullName());
        for (DynField field : fields) {
            try {
                field.validate(object.getDynValue(field.getName()));
            }
            catch (DynFieldNotFoundException | DynFieldValidateException e) {
                exceptions.add(e);
            }
        }
        if (exceptions.size() > 0) {
            throw exceptions;
        }
    }

    @Override
    public DynField addDynFieldString(String name) {
        return this.addDynField(name, 8);
    }

    @Override
    public DynField addDynFieldDate(String name) {
        return this.addDynField(name, 9);
    }

    @Override
    public DynField addDynFieldInt(String name) {
        return this.addDynField(name, 4);
    }

    @Override
    public DynField addDynFieldLong(String name) {
        return this.addDynField(name, 5);
    }

    @Override
    public DynField addDynFieldDouble(String name) {
        return this.addDynField(name, 7);
    }

    @Override
    public DynField addDynFieldFloat(String name) {
        return this.addDynField(name, 6);
    }

    @Override
    public DynField addDynFieldBoolean(String name) {
        return this.addDynField(name, 1);
    }

    @Override
    public DynField addDynFieldFolder(String name) {
        return this.addDynField(name, 14);
    }

    @Override
    public DynField addDynFieldFile(String name) {
        return this.addDynField(name, 13);
    }

    @Override
    public DynField addDynFieldURL(String name) {
        return this.addDynField(name, 16);
    }

    @Override
    public DynField addDynFieldURI(String name) {
        return this.addDynField(name, 17);
    }

    @Override
    public DynField addDynFieldArray(String name) {
        return this.addDynField(name, 33);
    }

    @Override
    public DynField addDynFieldObject(String name) {
        return this.addDynField(name, 64);
    }

    @Override
    public DynField addDynFieldChoice(String name, int type, Object defaultValue, DynObjectValueItem[] values) {
        return this.addDynFieldChoice(name, type, defaultValue, values, false, true);
    }

    @Override
    public DynField addDynFieldChoice(String name, int type, Object defaultValue, DynObjectValueItem[] values, boolean mandatory, boolean persistent) {
        return this.addDynField(name, type).setDefaultFieldValue(defaultValue).setMandatory(mandatory).setPersistent(persistent).setAvailableValues(values).setDescription(this.description);
    }

    @Override
    public DynField addDynFieldRange(String name, int type, Object defaultValue, Object min, Object max) {
        return this.addDynFieldRange(name, type, defaultValue, min, max, false, true);
    }

    @Override
    public DynField addDynFieldRange(String name, int type, Object defaultValue, Object min, Object max, boolean mandatory, boolean persistent) {
        return this.addDynField(name, type).setDefaultFieldValue(defaultValue).setMandatory(mandatory).setPersistent(persistent).setMinValue(min).setMaxValue(max);
    }

    @Override
    public DynField addDynFieldSingle(String name, int type, Object defaultValue) {
        return this.addDynFieldSingle(name, type, defaultValue, false, true);
    }

    @Override
    public DynField addDynFieldSingle(String name, int type, Object defaultValue, boolean mandatory, boolean persistent) {
        return this.addDynField(name, type).setDefaultFieldValue(defaultValue).setMandatory(mandatory).setPersistent(persistent);
    }

    public DynField addDynFieldObject(String name, String dynObjectFullName) {
        return this.addDynField(name).setType(15).setSubtype(dynObjectFullName);
    }

    public DynField addDynFieldObjectList(String name, String fullDynObjectName) {
        DynField listDynField = this.addDynFieldList(name).setElementsType(15).setSubtype(fullDynObjectName);
        return listDynField;
    }

    @Override
    public DynField addDynFieldList(String name) {
        return this.addDynField(name, 34);
    }

    @Override
    public DynField addDynFieldMap(String name) {
        return this.addDynField(name).setType(36);
    }

    @Override
    public DynField addDynFieldSet(String name) {
        return this.addDynField(name).setType(35);
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void setNamespace(String namespace) {
        this.name.setNamespace(namespace);
    }

    public void check() throws ListBaseException {
        DynField[] fields;
        ListBaseException exceptions = null;
        if (this.name == null) {
            exceptions = CheckDynClassListException.add(exceptions, this.name, "name", this.name);
        }
        for (DynField field : fields = this.getDynFields()) {
            try {
                ((DefaultDynField)field).check();
            }
            catch (Exception ex) {
                exceptions = CheckDynClassListException.add(exceptions, this.name, ex);
            }
        }
        if (exceptions != null) {
            throw exceptions;
        }
    }

    private boolean isExtendable(Set superClassesSet, DynStruct dynStruct) {
        if (superClassesSet == null || superClassesSet.isEmpty()) {
            return true;
        }
        return !superClassesSet.contains(dynStruct);
    }

    @Override
    public boolean isExtendable(DynStruct dynStruct) {
        if (dynStruct == null) {
            return false;
        }
        if (this.fieldsMap == null) {
            this.consolide();
        }
        Set superClassesSet = this.buildSuperDynClassSet();
        return this.isExtendable(superClassesSet, dynStruct);
    }

    private void removeDynStruct(DynStruct superDynStruct) {
        if (this.classes.containsKey(superDynStruct.getFullName())) {
            this.classes.remove(superDynStruct.getFullName());
        }
    }

    @Override
    public void remove(DynStruct superDynStruct) {
        if (superDynStruct != null) {
            this.removeDynStruct(superDynStruct);
            this.forceConsolide();
        }
    }

    public void removeAll(DynStruct[] superDynStruct) {
        if (superDynStruct != null) {
            for (DynStruct superDynStruct1 : superDynStruct) {
                this.removeDynStruct(superDynStruct1);
            }
            this.consolide();
        }
    }

    public void extend(DynStruct[] structs) {
        if (structs != null) {
            for (DynStruct struct : structs) {
                this.extend(struct);
            }
            this.consolide();
        }
    }

    @Override
    public Tags getTags() {
        return this.tags;
    }

    @Override
    public String getLabel() {
        if (this.label == null) {
            if (this.getTags().get("label") == null) {
                return this.getName();
            }
            return (String)this.getTags().get("label");
        }
        return this.label;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    public void renameField(String oldname, String newName) {
        DefaultDynField oldfield = (DefaultDynField)this.getDynField(oldname);
        if (oldfield == null) {
            throw new RuntimeException("field name do not exists.");
        }
        DynField newfield = this.getDynField(newName);
        if (newfield != null) {
            throw new RuntimeException("field name already exists.");
        }
        this.declaredFieldsMap.remove(oldfield);
        oldfield.setName(newName);
        this.declaredFieldsMap.put(oldfield.getName().toLowerCase(), oldfield);
    }

    public static class CheckDynClassListException
    extends ListBaseException {
        private static final long serialVersionUID = 9042601577056507657L;

        public CheckDynClassListException(DynClassName name) {
            super("Inconsistent DynClass %(name) definition.", "_Inconsistent_DynClass_XnameX_definition", 9042601577056507657L);
            String s = name == null ? "[unknow]" : name.getFullName();
            this.setValue("name", s);
        }

        public static ListBaseException add(ListBaseException exceptions, DynClassName name, String attrname, Object attrvalue) {
            if (exceptions == null) {
                exceptions = new CheckDynClassListException(name);
            }
            exceptions.add(new CheckDynClassException(attrname, attrvalue));
            return exceptions;
        }

        public static ListBaseException add(ListBaseException exceptions, DynClassName name, Exception ex) {
            if (exceptions == null) {
                exceptions = new CheckDynClassListException(name);
            }
            exceptions.add(ex);
            return exceptions;
        }

        public static class CheckDynClassException
        extends DynObjectException {
            private static final long serialVersionUID = -1447120375445458639L;

            public CheckDynClassException(String attrname, Object attrvalue) {
                super("Wrong value %(value) for attribute %(name).", "Wrong_value_XvalueX_for_attribute_XnameX", -1447120375445458639L);
            }
        }
    }

    private class ScriptMethod
    extends AbstractDynMethod {
        private final Script script;

        public ScriptMethod(Script script, String methodName) {
            super(methodName);
            this.script = script;
        }

        @Override
        public Object invoke(DynObject self, Object[] args) throws DynMethodException {
            try {
                return this.script.invokeFunction(this.getName(), args);
            }
            catch (NoSuchMethodException ex) {
                throw new DynMethodNotSupportedException(this.getName(), DefaultDynClass.this.getName());
            }
        }
    }

    public class MethodAndIndex {
        DynMethod method;
        int index;

        MethodAndIndex(DynMethod method, int index) {
            this.method = method;
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public DynMethod getDynMethod() {
            return this.method;
        }
    }

    public class FieldAndIndex {
        DefaultDynField field;
        int index;

        FieldAndIndex(DynField field, int index) {
            this.field = (DefaultDynField)field;
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public DefaultDynField getDynField() {
            return this.field;
        }
    }
}

