/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.util;

import java.util.List;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.CoercionException;
import org.gvsig.tools.dataTypes.DataType;
import org.gvsig.tools.dataTypes.DataTypesManager;

public class ArrayUtils {
    public static Object get(Object[] array, int n, int type) {
        return ArrayUtils.get(array, n, type, null);
    }

    public static Object get(Object[] array, int n, int type, Object defaultValue) {
        if (array == null) {
            return defaultValue;
        }
        if (array.length <= n || n < 0) {
            return defaultValue;
        }
        if (array[n] == null) {
            return defaultValue;
        }
        DataTypesManager typeManager = ToolsLocator.getDataTypesManager();
        DataType t = typeManager.get(type);
        try {
            return t.coerce(array[n]);
        }
        catch (CoercionException ex) {
            return defaultValue;
        }
    }

    public static Object get(Object[] array, int n) {
        if (array == null) {
            return null;
        }
        if (array.length <= n || n < 0) {
            return null;
        }
        return array[n];
    }

    public static Object get(Object[] array, int n, Class elementClass) {
        Object o = ArrayUtils.get(array, n);
        if (elementClass.isInstance(o)) {
            return o;
        }
        return null;
    }

    public static List getListOf(Object[] array, int n, Class elementClass) {
        List list = (List)ArrayUtils.get(array, n, List.class);
        if (list == null) {
            return null;
        }
        if (list.isEmpty()) {
            return null;
        }
        if (elementClass.isInstance(list.get(0))) {
            return list;
        }
        return null;
    }
}

