/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.dynform.spi.dynform;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.CoercionException;
import org.gvsig.tools.dataTypes.DataType;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dynform.DynFormDefinition;
import org.gvsig.tools.dynform.DynFormFieldDefinition;
import org.gvsig.tools.dynform.JDynForm;
import org.gvsig.tools.dynform.JDynFormField;
import org.gvsig.tools.dynform.spi.DynFormSPIManager;
import org.gvsig.tools.dynform.spi.dynform.JDynFormFactory;
import org.gvsig.tools.dynform.spi.dynformfield.AbstractJDynFormField;
import org.gvsig.tools.dynform.spi.dynformfield.AbstractJDynFormFieldWithValueList;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.Tags;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.identitymanagement.SimpleIdentity;
import org.gvsig.tools.resourcesstorage.ResourcesStorage;
import org.gvsig.tools.script.Script;
import org.gvsig.tools.script.ScriptManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.util.PropertiesSupportHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJDynForm
implements JDynForm {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractJDynForm.class);
    private final DynFormSPIManager manager;
    private final DynFormDefinition definition;
    private final JDynFormFactory factory;
    private JDynForm.DynFormContext context;
    private int formWidth = -1;
    private int formHeight = -1;
    private int layoutMode = 0;
    private JLabel jlabel_messages = null;
    private boolean readOnly = true;
    private Set listeners = null;
    private boolean useScrollBars = true;
    private final Map<String, List<Action>> customActions;
    protected JComponent contents = null;
    protected DynObject values = null;
    protected boolean border;
    private final PropertiesSupportHelper propertiesHelper = new PropertiesSupportHelper();
    private Script script;
    private boolean script_initialized = false;

    public AbstractJDynForm(DynFormSPIManager manager, JDynFormFactory factory, DynFormDefinition definition, JDynForm.DynFormContext context) {
        this.manager = manager;
        this.factory = factory;
        this.definition = definition;
        this.context = context;
        this.listeners = new HashSet();
        this.customActions = new HashMap<String, List<Action>>();
        if (definition != null) {
            this.loadDefaultValuesFromTags(definition.getTags());
            SimpleIdentity user = ToolsLocator.getIdentityManager().getCurrentIdentity();
            if (!user.canWrite((Object)this, definition.getName())) {
                this.readOnly = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Script getScript() {
        if (this.script_initialized) {
            return this.script;
        }
        ResourcesStorage resources = null;
        try {
            resources = this.context.getResourcesStorage();
            if (resources == null) {
                this.script = null;
                this.script_initialized = true;
                Script script = null;
                return script;
            }
            ResourcesStorage.Resource res = resources.getResource("jfrms");
            if (res == null || !res.exists()) {
                this.script = null;
                this.script_initialized = true;
                Script script = null;
                return script;
            }
            String source = IOUtils.toString((InputStream)res.asInputStream());
            if (StringUtils.isEmpty((CharSequence)source)) {
                this.script = null;
                this.script_initialized = true;
                Script script = null;
                return script;
            }
            ScriptManager scriptManager = this.context.getScriptManager();
            if (scriptManager == null) {
                this.script = null;
                this.script_initialized = true;
                Script script = null;
                return script;
            }
            this.script = scriptManager.createScript(this.definition.getName(), source, null);
            this.script_initialized = true;
            Script script = this.script;
            return script;
        }
        catch (Exception ex) {
            LOGGER.warn("Can't load resource jfrms.", (Throwable)ex);
            this.script = null;
            this.script_initialized = true;
            Script script = null;
            return script;
        }
        finally {
            DisposeUtils.disposeQuietly((Disposable)resources);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isScriptReadOnly() {
        boolean bl;
        ResourcesStorage.Resource res;
        ResourcesStorage resources;
        block7: {
            block6: {
                resources = null;
                res = null;
                resources = this.context.getResourcesStorage();
                if (resources != null) break block6;
                boolean bl2 = true;
                IOUtils.closeQuietly(res);
                DisposeUtils.disposeQuietly((Disposable)resources);
                return bl2;
            }
            res = resources.getResource("jfrms");
            if (res != null) break block7;
            boolean bl3 = true;
            IOUtils.closeQuietly((Closeable)res);
            DisposeUtils.disposeQuietly((Disposable)resources);
            return bl3;
        }
        try {
            bl = res.isReadOnly();
        }
        catch (Exception ex) {
            boolean bl4;
            try {
                LOGGER.warn("Can't check if script resource jfrms is read-only.", (Throwable)ex);
                bl4 = true;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(res);
                DisposeUtils.disposeQuietly((Disposable)resources);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)res);
            DisposeUtils.disposeQuietly((Disposable)resources);
            return bl4;
        }
        IOUtils.closeQuietly((Closeable)res);
        DisposeUtils.disposeQuietly((Disposable)resources);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putScript(String source) {
        block9: {
            ResourcesStorage resources = null;
            ResourcesStorage.Resource res = null;
            OutputStream os = null;
            try {
                ScriptManager scriptManager = this.context.getScriptManager();
                if (scriptManager == null) {
                    throw new RuntimeException("Can't get the scripting manager.");
                }
                this.script = scriptManager.createScript(this.definition.getName(), source, null);
                this.script_initialized = true;
                resources = this.context.getResourcesStorage();
                if (resources == null) {
                    throw new RuntimeException("Can't get the resources storage.");
                }
                res = resources.getResource("jfrms");
                if (res == null) {
                    throw new RuntimeException("Can't get the resource of this form.");
                }
                if (res.isReadOnly()) {
                    throw new RuntimeException("Can't modify the resource, is read-only.");
                }
                os = res.asOutputStream();
                IOUtils.write((String)source, (OutputStream)os, (Charset)StandardCharsets.UTF_8);
                IOUtils.closeQuietly((OutputStream)os);
            }
            catch (Exception ex) {
                LOGGER.warn("Can't save resource jfrms.", (Throwable)ex);
                break block9;
            }
            finally {
                IOUtils.closeQuietly(os);
                IOUtils.closeQuietly(res);
                DisposeUtils.disposeQuietly(resources);
            }
            IOUtils.closeQuietly((Closeable)res);
            DisposeUtils.disposeQuietly((Disposable)resources);
        }
    }

    public void callUserEvent(String name, Object ... args) {
        Script theScript = this.getScript();
        if (theScript == null) {
            return;
        }
        try {
            theScript.invokeFunction(name, args);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (Exception ex) {
            LOGGER.warn("Error calling form event '" + name + "'.", (Throwable)ex);
        }
    }

    public Object callUserFunction(String function, Object ... args) throws Exception {
        Script theScript = this.getScript();
        if (theScript == null) {
            throw new RuntimeException("Can't exists user code associated to this form.");
        }
        return theScript.invokeFunction(function, args);
    }

    public static int getLayoutFromTags(Tags tags) {
        String layoutMode = (String)tags.get("dynform.layoutmode", 8, (Object)"plain");
        if (!StringUtils.isEmpty((CharSequence)layoutMode)) {
            if (layoutMode.equalsIgnoreCase("0") || layoutMode.equalsIgnoreCase("plain")) {
                return 0;
            }
            if (layoutMode.equalsIgnoreCase("1") || layoutMode.equalsIgnoreCase("tabs")) {
                return 1;
            }
            if (layoutMode.equalsIgnoreCase("2") || layoutMode.equalsIgnoreCase("separators")) {
                return 2;
            }
        }
        return 0;
    }

    public void loadDefaultValuesFromTags(Tags tags) {
        String s2;
        this.setLayoutMode(AbstractJDynForm.getLayoutFromTags(tags));
        try {
            s2 = tags.getString("dynform.width");
            this.formWidth = NumberFormat.getInstance().parse(s2).intValue();
            if (StringUtils.endsWithAny((CharSequence)s2, (CharSequence[])new CharSequence[]{"ch", "char", "cols", "columns"})) {
                this.formWidth = ToolsSwingUtils.cols2px((int)this.formWidth);
            }
        }
        catch (Exception s2) {
            // empty catch block
        }
        try {
            s2 = tags.getString("dynform.height");
            this.formHeight = NumberFormat.getInstance().parse(s2).intValue();
            if (StringUtils.endsWithAny((CharSequence)s2, (CharSequence[])new CharSequence[]{"ch", "char", "rows", "lines"})) {
                this.formHeight = ToolsSwingUtils.rows2px((int)this.formHeight);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.border = tags.getBoolean("dynform.border");
        }
        catch (CoercionException coercionException) {
            // empty catch block
        }
        try {
            this.useScrollBars = tags.getBoolean("dynform.useScrollBars");
        }
        catch (CoercionException coercionException) {
            // empty catch block
        }
        try {
            this.readOnly = tags.getBoolean("dynform.readonly");
        }
        catch (CoercionException coercionException) {
            // empty catch block
        }
    }

    public DynFormSPIManager getServiceManager() {
        return this.manager;
    }

    public JComponent asJComponent() {
        if (this.contents == null) {
            this.initComponents();
        }
        return this.contents;
    }

    protected void initComponents() {
        if (this.contents == null) {
            this.contents = this.addScrollsAndMessageBar(this.getFieldsContainer());
            if (this.values != null) {
                this.setValues(this.values);
            }
            if (this.border) {
                this.contents.setBorder(BorderFactory.createLineBorder(Color.GRAY));
            }
            this.message();
        }
    }

    protected boolean isContentsInitialized() {
        return this.contents != null;
    }

    public void addListener(JDynForm.JDynFormListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(JDynForm.JDynFormListener listener) {
        this.listeners.remove(listener);
    }

    public JLabel getMessagesJLabel() {
        if (this.jlabel_messages == null) {
            this.jlabel_messages = new JLabel();
            this.jlabel_messages.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    int count = evt.getClickCount();
                    if (count == 2) {
                        JOptionPane.showMessageDialog(AbstractJDynForm.this.contents, AbstractJDynForm.this.jlabel_messages.getText(), "Status", 1);
                    }
                }
            });
        }
        return this.jlabel_messages;
    }

    public void setShowMessageStatus(boolean showMessageStatus) {
        this.getMessagesJLabel().setVisible(showMessageStatus);
    }

    public boolean isShowMessageStatus() {
        return this.getMessagesJLabel().isVisible();
    }

    public void message() {
        this.getMessagesJLabel().setText(" ");
    }

    public void message(String msg) {
        this.getMessagesJLabel().setText(msg);
        this.fireMessageEvent(msg);
    }

    protected void fireMessageEvent(String message) {
        for (JDynForm.JDynFormListener listener : this.listeners) {
            try {
                listener.message(message);
            }
            catch (Exception ex) {
                LOGGER.info("Error calling listener " + listener.toString() + "(" + listener.getClass().getName() + ") from " + this.toString() + "(" + this.getClass().getName() + ").", (Throwable)ex);
            }
        }
    }

    protected void fireFieldChangeEvent(JDynFormField field) {
        for (JDynForm.JDynFormListener listener : this.listeners) {
            try {
                listener.fieldChanged(field);
            }
            catch (AbstractJDynFormField.IllegalFieldValue ex) {
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Error calling listener " + listener.toString() + "(" + listener.getClass().getName() + ") from " + this.toString() + "(" + this.getClass().getName() + ").", (Throwable)ex);
            }
            catch (Exception ex) {
                LOGGER.info("Error calling listener " + listener.toString() + "(" + listener.getClass().getName() + ") from " + this.toString() + "(" + this.getClass().getName() + ").", (Throwable)ex);
            }
        }
    }

    protected JPanel addScrollsAndMessageBar(JComponent formPanel) {
        formPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        JScrollPane scroll = new JScrollPane(formPanel);
        scroll.getVerticalScrollBar().setBlockIncrement(30);
        scroll.getVerticalScrollBar().setUnitIncrement(10);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension size = formPanel.getPreferredSize();
        if (this.formHeight < 100) {
            this.formHeight = size.height > screenSize.height - 100 ? screenSize.height - 150 : size.height;
        }
        if (this.formWidth < 100) {
            this.formWidth = size.width > 800 ? 800 : size.width;
        }
        if (this.useScrollBars) {
            int scrollBarWidth = scroll.getVerticalScrollBar().getPreferredSize().width;
            scroll.setPreferredSize(new Dimension(this.formWidth + 4, this.formHeight + 4));
        } else {
            scroll.setPreferredSize(new Dimension(this.formWidth, this.formHeight));
        }
        scroll.setBorder(BorderFactory.createEmptyBorder());
        JPanel jpanel = new JPanel();
        jpanel.setLayout(new BorderLayout());
        jpanel.add((Component)scroll, "Center");
        jpanel.add((Component)this.getMessagesJLabel(), "Last");
        return jpanel;
    }

    public int getLayoutMode() {
        return this.layoutMode;
    }

    public void setLayoutMode(int layoutMode) {
        if (layoutMode < 0 || layoutMode > 2) {
            throw new IllegalArgumentException("layoutMode (" + layoutMode + ") out of range. Valid values are 0 .. " + 2 + ".");
        }
        this.layoutMode = layoutMode;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public int getFormWidth() {
        if (this.contents == null) {
            return this.formWidth;
        }
        JViewport port = ((JScrollPane)this.asJComponent()).getViewport();
        Component comp = port.getView();
        return comp.getWidth();
    }

    public int getFormHeight() {
        if (this.contents == null) {
            return this.formHeight;
        }
        JViewport port = ((JScrollPane)this.asJComponent()).getViewport();
        Component comp = port.getView();
        return comp.getHeight();
    }

    public void setFormSize(int width, int height) {
        this.formHeight = height;
        this.formWidth = width;
        if (this.contents != null) {
            this.asJComponent().setPreferredSize(new Dimension(width, height));
        }
    }

    public void configurePopupMenu(JDynFormField jfield) {
        DynFormFieldDefinition fieldDefinition = jfield.getDefinition();
        List<Action> customActions = this.getCustomActionsForDataType(fieldDefinition.getDataType());
        if (customActions != null && !customActions.isEmpty()) {
            for (Action customAction : customActions) {
                if (customAction != null) {
                    jfield.addActionToPopupMenu((String)customAction.getValue("Name"), customAction);
                    continue;
                }
                jfield.addSeparatorToPopupMenu();
            }
        }
        this.getServiceManager().configurePopupMenu(jfield);
    }

    protected List<Action> getCustomActionsForDataType(DataType dataType) {
        return this.customActions.get(dataType.getName());
    }

    public void addActionToPopupMenu(DataType tipo, String name, Action action) {
        List<Action> acts = this.getCustomActionsForDataType(tipo);
        action.putValue("Name", name);
        if (acts == null) {
            ArrayList<Action> aux = new ArrayList<Action>();
            aux.add(action);
            this.customActions.put(tipo.getName(), aux);
        } else {
            acts.add(action);
        }
    }

    public void addSeparatorToPopupMenu(DataType tipo) {
        List<Action> acts = this.getCustomActionsForDataType(tipo);
        if (acts == null) {
            ArrayList<Object> aux = new ArrayList<Object>();
            aux.add(null);
            this.customActions.put(tipo.getName(), aux);
        } else {
            acts.add(null);
        }
    }

    public DynFormDefinition getDefinition() {
        return this.definition;
    }

    public boolean getUseScrollBars() {
        return this.useScrollBars;
    }

    public void setUseScrollBars(boolean usesScrolls) {
        this.useScrollBars = usesScrolls;
    }

    public void setBorder(boolean border) {
        this.border = border;
        if (this.isContentsInitialized() && border) {
            this.asJComponent().setBorder(BorderFactory.createLineBorder(Color.GRAY));
        }
    }

    public JDynFormField getField(String fieldName) {
        return null;
    }

    public final JDynFormField get(String key) {
        return this.getField(key);
    }

    public Object getProperty(String key) {
        return this.propertiesHelper.getProperty(key);
    }

    public void setProperty(String key, Object obj) {
        this.propertiesHelper.setProperty(key, obj);
    }

    public Map<String, Object> getProperties() {
        return this.propertiesHelper.getProperties();
    }

    public JDynForm.DynFormContext getContext() {
        return this.context;
    }

    public void setContext(JDynForm.DynFormContext context) {
        this.context = context;
    }

    public String toHtml() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        List groups = this.getDefinition().getGroups();
        StringBuilder builder = new StringBuilder();
        builder.append("<html>\n");
        builder.append("<body>\n");
        builder.append("<table style=\"border: none;\" cellspacing=\"2\" cellpadding=\"0\">\n");
        for (String group : groups) {
            String tablabel = group;
            tablabel = StringUtils.isBlank((CharSequence)tablabel) ? i18n.getTranslation("General") : i18n.getTranslation(tablabel);
            builder.append("<tr>\n");
            builder.append("<td colspan=\"2\">\n<br/><i>");
            builder.append(StringEscapeUtils.escapeHtml3((String)tablabel));
            builder.append("</i>");
            builder.append("</td>\n");
            builder.append("</tr>\n");
            List fields = this.getDefinition().getDefinitions(group);
            for (DynFormFieldDefinition fieldDefinition : fields) {
                JDynFormField jfield;
                if (fieldDefinition.isHidden() || (jfield = this.getField(fieldDefinition.getName())) == null) continue;
                String value = jfield.toHTML();
                if (value == null) {
                    if (fieldDefinition.isHidden() || fieldDefinition.getDataType().isContainer()) continue;
                    if (jfield instanceof AbstractJDynFormFieldWithValueList) {
                        value = ((AbstractJDynFormFieldWithValueList)jfield).getFromJComponent();
                    } else {
                        try {
                            value = Objects.toString(jfield.getValue(), "");
                        }
                        catch (Exception e) {
                            value = "#ERROR#";
                        }
                    }
                    value = StringEscapeUtils.escapeHtml3((String)value);
                }
                builder.append("<tr>\n");
                if (jfield.useEmptyLabel()) {
                    builder.append("<td colspan=\"2\">\n");
                    builder.append(value);
                    builder.append("</td>\n");
                } else {
                    builder.append("<td valign=\"top\" nowrap style=\"white-space:nowrap;\">\n");
                    if (fieldDefinition.isMandatory()) {
                        builder.append("<b>");
                        builder.append(StringEscapeUtils.escapeHtml3((String)fieldDefinition.getLabel()));
                        builder.append("</b>");
                    } else {
                        builder.append(StringEscapeUtils.escapeHtml3((String)fieldDefinition.getLabel()));
                    }
                    builder.append(": ");
                    builder.append("</td>\n");
                    builder.append("<td>\n");
                    builder.append(value);
                    builder.append("</td>\n");
                }
                builder.append("</tr>\n");
            }
        }
        builder.append("</table>\n");
        builder.append("</body>\n");
        builder.append("</html>\n");
        return builder.toString();
    }
}

