/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.installer.swing.impl.execution.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.net.URL;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.gui.beans.openfile.FileFilter;
import org.gvsig.gui.beans.openfile.FileTextField;
import org.gvsig.installer.swing.api.SwingInstallerLocator;
import org.gvsig.installer.swing.api.SwingInstallerManager;
import org.gvsig.installer.swing.impl.DefaultSwingInstallerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectBundlesPanel
extends JPanel
implements ItemListener,
DocumentListener {
    protected static final Logger LOG = LoggerFactory.getLogger(SelectBundlesPanel.class);
    private static final long serialVersionUID = -6580729307001414868L;
    protected DefaultSwingInstallerManager swingInstallerManager = null;
    private JRadioButton fileRadioButton;
    private ButtonGroup buttonGroup;
    private JPanel northPanel;
    private FileTextField selectFileText;
    private JRadioButton standardRadioButton;
    private JComboBox downloadURL;
    private JRadioButton urlRadioButton;
    private final List<SwingInstallerManager.UrlAndLabel> defaultDownloadURL;

    public SelectBundlesPanel(List<SwingInstallerManager.UrlAndLabel> defaultDownloadURL2, File installFolder) {
        this.defaultDownloadURL = defaultDownloadURL2;
        this.swingInstallerManager = (DefaultSwingInstallerManager)SwingInstallerLocator.getSwingInstallerManager();
        this.initComponents();
        this.initListeners();
        String[] files = installFolder.list();
        if (files != null && files.length > 0) {
            this.standardRadioButton.setSelected(true);
            this.urlRadioButton.setSelected(false);
        } else {
            this.urlRadioButton.setSelected(true);
            this.standardRadioButton.setEnabled(false);
        }
    }

    private void initListeners() {
        this.standardRadioButton.addItemListener(this);
        this.fileRadioButton.addItemListener(this);
        this.urlRadioButton.addItemListener(this);
        Component obj = this.selectFileText.getComponent(0);
        if (obj != null && obj instanceof JTextField) {
            ((JTextField)obj).getDocument().addDocumentListener(this);
        }
    }

    private void initComponents() {
        this.northPanel = new JPanel();
        this.standardRadioButton = new JRadioButton();
        this.fileRadioButton = new JRadioButton();
        this.urlRadioButton = new JRadioButton();
        this.selectFileText = new FileTextField();
        this.selectFileText.setFileFilter(new FileFilter(){
            private String packageExt;
            private String packageSetExt;
            private String indexSetExt;
            {
                this.packageExt = SelectBundlesPanel.this.swingInstallerManager.getInstallerManager().getDefaultPackageFileExtension();
                this.packageSetExt = SelectBundlesPanel.this.swingInstallerManager.getInstallerManager().getDefaultPackageSetFileExtension();
                this.indexSetExt = SelectBundlesPanel.this.swingInstallerManager.getInstallerManager().getDefaultIndexSetFileExtension();
            }

            public String getDescription() {
                return SelectBundlesPanel.this.swingInstallerManager.getText("_gvSIG_packages_and_packages_and_index_sets") + " (*." + this.packageExt + ", *." + this.packageSetExt + ", *." + this.indexSetExt + ")";
            }

            public boolean accept(File file) {
                if (file.isFile()) {
                    String name = file.getName().toLowerCase();
                    return name.endsWith(this.packageExt) || name.endsWith(this.packageSetExt) || name.endsWith(this.indexSetExt);
                }
                return true;
            }

            public String getDefaultExtension() {
                return this.packageSetExt;
            }
        });
        this.downloadURL = new JComboBox();
        this.downloadURL.setEditable(true);
        if (this.defaultDownloadURL != null) {
            for (int i = 0; i < this.defaultDownloadURL.size(); ++i) {
                this.downloadURL.addItem(this.defaultDownloadURL.get(i));
            }
        }
        this.buttonGroup = new ButtonGroup();
        this.buttonGroup.add(this.standardRadioButton);
        this.buttonGroup.add(this.fileRadioButton);
        this.buttonGroup.add(this.urlRadioButton);
        this.setLayout(new BorderLayout());
        this.northPanel.setLayout(new GridBagLayout());
        this.standardRadioButton.setText(this.swingInstallerManager.getText("_standard_installation") + " (" + this.swingInstallerManager.getText("_install_addons_in_gvsig_standard_dist") + ")");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.northPanel.add((Component)this.standardRadioButton, gridBagConstraints);
        this.fileRadioButton.setText(this.swingInstallerManager.getText("_installation_from_file") + " (" + this.swingInstallerManager.getText("_install_addons_in_gvspki_or_gvspks_file") + ")");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.northPanel.add((Component)this.fileRadioButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 20, 2, 2);
        this.northPanel.add((Component)this.selectFileText, gridBagConstraints);
        this.urlRadioButton.setText(this.swingInstallerManager.getText("_installation_from_url") + " (" + this.swingInstallerManager.getText("_install_addons_from_remote_repo") + ")");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.northPanel.add((Component)this.urlRadioButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 20, 2, 2);
        this.northPanel.add((Component)this.downloadURL, gridBagConstraints);
        this.add((Component)this.northPanel, "North");
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.selectFileText.setEnabled(this.fileRadioButton.isSelected());
        this.downloadURL.setEnabled(this.urlRadioButton.isSelected());
        this.downloadURL.setEditable(this.urlRadioButton.isSelected());
        this.checkNextButtonEnabled();
    }

    public File getSelectedFile() {
        return this.selectFileText.getSelectedFile();
    }

    public URL getSelectedURL() {
        Object value = this.downloadURL.getSelectedItem();
        if (value instanceof SwingInstallerManager.UrlAndLabel) {
            return ((SwingInstallerManager.UrlAndLabel)value).getURL();
        }
        if (value == null) {
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)value.toString())) {
            return null;
        }
        try {
            return new URL(value.toString());
        }
        catch (Exception ex) {
            LOG.warn("The entered url are not valid");
            return null;
        }
    }

    public boolean isStandardSelected() {
        return this.standardRadioButton.isSelected();
    }

    public boolean isFileSelected() {
        return this.fileRadioButton.isSelected();
    }

    public boolean isURLSelected() {
        return this.urlRadioButton.isSelected();
    }

    protected boolean isNextButtonEnabled() {
        if (this.isStandardSelected()) {
            return true;
        }
        if (this.isFileSelected()) {
            File file = this.selectFileText.getSelectedFile();
            if (file == null) {
                return false;
            }
            return file.exists();
        }
        if (this.isURLSelected()) {
            return this.getSelectedURL() != null;
        }
        return false;
    }

    protected void checkNextButtonEnabled() {
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.checkNextButtonEnabled();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.checkNextButtonEnabled();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.checkNextButtonEnabled();
    }
}

