/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.Transient;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.accessibility.AccessibleContext;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ListUI;
import javax.swing.text.Position;
import org.gvsig.tools.swing.api.DefaultCheckListCellRenderer;
import org.gvsig.tools.swing.api.JListWithCheckbox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJListWithCheckbox
extends JListWithCheckbox {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultJListWithCheckbox.class);
    private final JList wrappedList;
    private ListSelectionModel checkedsModel = new DefaultListSelectionModel();
    private Set<ListSelectionListener> checkedsListeners;
    private final ListSelectionListener checksModelListener;
    private final DefaultCheckListCellRenderer checkListCellRenderer;

    public DefaultJListWithCheckbox(final JList wrappedList) {
        this.wrappedList = wrappedList;
        this.checkedsModel.setSelectionMode(2);
        this.checkedsListeners = new HashSet<ListSelectionListener>();
        this.checkListCellRenderer = new DefaultCheckListCellRenderer(this.wrappedList.getCellRenderer(), this.checkedsModel);
        this.wrappedList.setCellRenderer(this.checkListCellRenderer);
        this.wrappedList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                int index = wrappedList.locationToIndex(me.getPoint());
                if (index < 0) {
                    return;
                }
                ListCellRenderer renderer = wrappedList.getCellRenderer();
                int checkBoxWidth = 16;
                if (renderer instanceof DefaultCheckListCellRenderer) {
                    checkBoxWidth = ((DefaultCheckListCellRenderer)renderer).getCheckBoxWidth();
                }
                if ((double)me.getX() > wrappedList.getCellBounds(index, index).getX() + (double)checkBoxWidth) {
                    return;
                }
                DefaultJListWithCheckbox.this.toggleCheck(index);
            }
        });
        this.checksModelListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent lse) {
                wrappedList.repaint();
            }
        };
        this.setCheckedModel(this.checkedsModel);
    }

    public final void setCheckedModel(ListSelectionModel checkedsModel) {
        this.checkedsModel.removeListSelectionListener(this.checksModelListener);
        this.checkedsModel = checkedsModel;
        this.checkedsModel.addListSelectionListener(this.checksModelListener);
        this.checkListCellRenderer.setCheckedModel(checkedsModel);
    }

    public void toggleCheck(int index) {
        if (index < 0) {
            return;
        }
        if (this.checkedsModel.isSelectedIndex(index)) {
            this.checkedsModel.removeSelectionInterval(index, index);
        } else {
            this.checkedsModel.addSelectionInterval(index, index);
        }
        this.fireCheckedsListeners(new ListSelectionEvent((Object)this, index, index, false));
    }

    public ListUI getUI() {
        return this.wrappedList.getUI();
    }

    public void setUI(ListUI ui) {
        this.wrappedList.setUI(ui);
    }

    public void updateUI() {
        if (this.wrappedList != null) {
            this.wrappedList.updateUI();
        }
    }

    public String getUIClassID() {
        return this.wrappedList.getUIClassID();
    }

    public Object getPrototypeCellValue() {
        return this.wrappedList.getPrototypeCellValue();
    }

    public void setPrototypeCellValue(Object prototypeCellValue) {
        this.wrappedList.setPrototypeCellValue(prototypeCellValue);
    }

    public int getFixedCellWidth() {
        return this.wrappedList.getFixedCellWidth();
    }

    public void setFixedCellWidth(int width) {
        this.wrappedList.setFixedCellWidth(width);
    }

    public int getFixedCellHeight() {
        return this.wrappedList.getFixedCellHeight();
    }

    public void setFixedCellHeight(int height) {
        this.wrappedList.setFixedCellHeight(height);
    }

    @Transient
    public ListCellRenderer getCellRenderer() {
        return this.wrappedList.getCellRenderer();
    }

    public void setCellRenderer(ListCellRenderer cellRenderer) {
        this.wrappedList.setCellRenderer(cellRenderer);
    }

    public Color getSelectionForeground() {
        return this.wrappedList.getSelectionForeground();
    }

    public void setSelectionForeground(Color selectionForeground) {
        this.wrappedList.setSelectionForeground(selectionForeground);
    }

    public Color getSelectionBackground() {
        return this.wrappedList.getSelectionBackground();
    }

    public void setSelectionBackground(Color selectionBackground) {
        this.wrappedList.setSelectionBackground(selectionBackground);
    }

    public int getVisibleRowCount() {
        return this.wrappedList.getVisibleRowCount();
    }

    public void setVisibleRowCount(int visibleRowCount) {
        this.wrappedList.setVisibleRowCount(visibleRowCount);
    }

    public int getLayoutOrientation() {
        return this.wrappedList.getLayoutOrientation();
    }

    public void setLayoutOrientation(int layoutOrientation) {
        this.wrappedList.setLayoutOrientation(layoutOrientation);
    }

    public int getFirstVisibleIndex() {
        return this.wrappedList.getFirstVisibleIndex();
    }

    public int getLastVisibleIndex() {
        return this.wrappedList.getLastVisibleIndex();
    }

    public void ensureIndexIsVisible(int index) {
        this.wrappedList.ensureIndexIsVisible(index);
    }

    public void setDragEnabled(boolean b) {
        this.wrappedList.setDragEnabled(b);
    }

    public boolean getDragEnabled() {
        return this.wrappedList.getDragEnabled();
    }

    public int getNextMatch(String prefix, int startIndex, Position.Bias bias) {
        return this.wrappedList.getNextMatch(prefix, startIndex, bias);
    }

    public String getToolTipText(MouseEvent event) {
        return this.wrappedList.getToolTipText(event);
    }

    public int locationToIndex(Point location) {
        return this.wrappedList.locationToIndex(location);
    }

    public Point indexToLocation(int index) {
        return this.wrappedList.indexToLocation(index);
    }

    public Rectangle getCellBounds(int index0, int index1) {
        return this.wrappedList.getCellBounds(index0, index1);
    }

    public ListModel getModel() {
        return this.wrappedList.getModel();
    }

    public void setModel(ListModel model) {
        this.wrappedList.setModel(model);
    }

    public void setListData(Object[] listData) {
        this.wrappedList.setListData(listData);
    }

    public void setListData(Vector listData) {
        this.wrappedList.setListData(listData);
    }

    public ListSelectionModel getSelectionModel() {
        return this.wrappedList.getSelectionModel();
    }

    public ListSelectionModel getCheckedModel() {
        return this.checkedsModel;
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.wrappedList.addListSelectionListener(listener);
    }

    public void addChecksListener(ListSelectionListener listener) {
        this.checkedsListeners.add(listener);
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        this.wrappedList.removeListSelectionListener(listener);
    }

    public void removeChecksListener(ListSelectionListener listener) {
        this.checkedsListeners.remove(listener);
    }

    public ListSelectionListener[] getListSelectionListeners() {
        return this.wrappedList.getListSelectionListeners();
    }

    public ListSelectionListener[] getChecksListeners() {
        return this.checkedsListeners.toArray(new ListSelectionListener[1]);
    }

    protected void fireCheckedsListeners(ListSelectionEvent event) {
        for (ListSelectionListener listener : this.checkedsListeners) {
            try {
                listener.valueChanged(event);
            }
            catch (Throwable th) {
                LOGGER.warn("Problems calling check listener (" + listener + ").", th);
            }
        }
    }

    public void setSelectionModel(ListSelectionModel selectionModel) {
        this.wrappedList.setSelectionModel(selectionModel);
    }

    public void setSelectionMode(int selectionMode) {
        this.wrappedList.setSelectionMode(selectionMode);
    }

    public int getSelectionMode() {
        return this.wrappedList.getSelectionMode();
    }

    public int getAnchorSelectionIndex() {
        return this.wrappedList.getAnchorSelectionIndex();
    }

    public int getLeadSelectionIndex() {
        return this.wrappedList.getLeadSelectionIndex();
    }

    public int getMinSelectionIndex() {
        return this.wrappedList.getMinSelectionIndex();
    }

    public int getMaxSelectionIndex() {
        return this.wrappedList.getMaxSelectionIndex();
    }

    public boolean isSelectedIndex(int index) {
        return this.wrappedList.isSelectedIndex(index);
    }

    public boolean isSelectionEmpty() {
        return this.wrappedList.isSelectionEmpty();
    }

    public void clearSelection() {
        this.wrappedList.clearSelection();
    }

    public void setSelectionInterval(int anchor, int lead) {
        this.wrappedList.setSelectionInterval(anchor, lead);
    }

    public void addSelectionInterval(int anchor, int lead) {
        this.wrappedList.addSelectionInterval(anchor, lead);
    }

    public void removeSelectionInterval(int index0, int index1) {
        this.wrappedList.removeSelectionInterval(index0, index1);
    }

    public void setValueIsAdjusting(boolean b) {
        this.wrappedList.setValueIsAdjusting(b);
    }

    public boolean getValueIsAdjusting() {
        return this.wrappedList.getValueIsAdjusting();
    }

    @Transient
    public int[] getSelectedIndices() {
        return this.wrappedList.getSelectedIndices();
    }

    public void setSelectedIndex(int index) {
        this.wrappedList.setSelectedIndex(index);
    }

    public void setSelectedIndices(int[] indices) {
        this.wrappedList.setSelectedIndices(indices);
    }

    @Deprecated
    public Object[] getSelectedValues() {
        return this.wrappedList.getSelectedValues();
    }

    public List getSelectedValuesList() {
        return this.wrappedList.getSelectedValuesList();
    }

    public int getSelectedIndex() {
        return this.wrappedList.getSelectedIndex();
    }

    public Object getSelectedValue() {
        return this.wrappedList.getSelectedValue();
    }

    public void setSelectedValue(Object anObject, boolean shouldScroll) {
        this.wrappedList.setSelectedValue(anObject, shouldScroll);
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.wrappedList.getPreferredScrollableViewportSize();
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this.wrappedList.getScrollableUnitIncrement(visibleRect, orientation, direction);
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this.wrappedList.getScrollableBlockIncrement(visibleRect, orientation, direction);
    }

    public boolean getScrollableTracksViewportWidth() {
        return this.wrappedList.getScrollableTracksViewportWidth();
    }

    public boolean getScrollableTracksViewportHeight() {
        return this.wrappedList.getScrollableTracksViewportHeight();
    }

    public AccessibleContext getAccessibleContext() {
        return this.wrappedList.getAccessibleContext();
    }
}

