/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl.pickercontroller;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JPopupMenu;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.MaskFormatter;
import org.apache.commons.lang3.StringUtils;
import org.freixas.jcalendar.JCalendar;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.pickercontroller.AbstractPickerController;
import org.gvsig.tools.swing.api.pickercontroller.DatePickerController;
import org.gvsig.tools.swing.impl.ClearButtonUtils;
import org.gvsig.tools.swing.impl.ContextMenuUtils;

public class DatePickerControllerImpl
extends AbstractPickerController<java.util.Date>
implements DatePickerController {
    private final JButton btnDate;
    private final JTextComponent txtDate;
    private JCalendar jcalendar;
    private DateFormat df;
    private final Document document;
    private final DocumentListener documentListener;
    private final Color colorOk;
    private final Color colorErr;
    private String emptyText;
    private MaskFormatter mask;
    private final ActionListener buttonListener;
    private boolean isMyClearButton;

    public static void selfRegister() {
    }

    public DatePickerControllerImpl(JTextComponent txtDate, JButton btnDate) {
        this.txtDate = txtDate;
        this.txtDate.setOpaque(true);
        if (btnDate == null) {
            btnDate = new JButton();
        }
        this.isMyClearButton = false;
        if (!ClearButtonUtils.hasClearButton(txtDate)) {
            ClearButtonUtils.addClearButton(txtDate, e -> this.set(null));
            this.isMyClearButton = true;
        }
        ContextMenuUtils.setDefaultContextMenu(this.txtDate);
        this.df = DateFormat.getDateInstance(3, Locale.getDefault());
        this.df.setLenient(false);
        if (this.df instanceof SimpleDateFormat) {
            try {
                SimpleDateFormat sdf = (SimpleDateFormat)this.df;
                String s = sdf.toPattern();
                if (!s.contains("yyyy")) {
                    if (s.contains("yy")) {
                        s = s.replace("yy", "yyyy");
                    } else if (s.contains("y")) {
                        s = s.replace("y", "yyyy");
                    }
                }
                if (!s.contains("dd") && s.contains("d")) {
                    s = s.replace("d", "dd");
                }
                if (!s.contains("MM") && s.contains("M")) {
                    s = s.replace("M", "MM");
                }
                sdf.applyPattern(s);
                s = s.replace("y", "#");
                s = s.replace("d", "#");
                s = s.replace("M", "#");
                this.mask = new MaskFormatter(s);
                this.mask.setPlaceholderCharacter('_');
                this.emptyText = s.replace("#", "_");
                this.mask.setAllowsInvalid(false);
            }
            catch (Exception ex) {
                LOG.warn("Not been able to create mask", (Throwable)ex);
            }
        }
        if (this.mask != null && this.txtDate instanceof JFormattedTextField) {
            JFormattedTextField ftf = (JFormattedTextField)this.txtDate;
            this.mask.install(ftf);
        }
        this.colorOk = this.txtDate.getBackground();
        this.colorErr = new Color(255, 225, 232);
        this.btnDate = btnDate;
        this.txtDate.setAlignmentX(1.0f);
        this.txtDate.setEditable(true);
        this.document = this.txtDate.getDocument();
        this.documentListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                DatePickerControllerImpl.this.checkContents();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                DatePickerControllerImpl.this.checkContents();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                DatePickerControllerImpl.this.checkContents();
            }
        };
        this.document.addDocumentListener(this.documentListener);
        this.buttonListener = e -> this.doShowCalendar();
        ToolsSwingUtils.configurePickersButton((AbstractButton)this.btnDate, null, (String)"picker-date", (ActionListener)this.buttonListener, null);
    }

    public void uninstall() {
        this.document.removeDocumentListener(this.documentListener);
        if (this.mask != null) {
            this.mask.uninstall();
        }
        this.txtDate.setOpaque(false);
        this.txtDate.setBackground(this.colorOk);
        this.btnDate.removeActionListener(this.buttonListener);
        if (this.isMyClearButton) {
            ToolsSwingLocator.getToolsSwingManager().removeClearButton(this.txtDate);
            this.isMyClearButton = false;
        }
    }

    protected String getText() {
        String s = this.txtDate.getText();
        if (this.emptyText != null && this.emptyText.equals(s)) {
            return "";
        }
        s = s.replace("_", "");
        return s;
    }

    protected void checkContents() {
        if (this.isValid()) {
            this.txtDate.setBackground(this.colorOk);
            try {
                java.util.Date d = this.get();
                if (d != null) {
                    this.txtDate.setText(this.df.format(d));
                }
                this.fireChangeEvent();
            }
            catch (Throwable t) {
                LOG.debug("Can't format date");
            }
        } else {
            this.txtDate.setBackground(this.colorErr);
        }
    }

    public boolean isValid() {
        if (StringUtils.isBlank((CharSequence)this.getText())) {
            return true;
        }
        try {
            java.util.Date date = this.df.parse(this.getText());
            return true;
        }
        catch (ParseException ex) {
            return false;
        }
    }

    public boolean isEmpty() {
        if (StringUtils.isBlank((CharSequence)this.getText())) {
            return true;
        }
        try {
            java.util.Date date = this.df.parse(this.getText());
            return false;
        }
        catch (ParseException ex) {
            return true;
        }
    }

    public java.util.Date get() {
        if (StringUtils.isBlank((CharSequence)this.getText())) {
            return null;
        }
        try {
            java.util.Date date = this.df.parse(this.getText());
            return date;
        }
        catch (Exception ex) {
            throw new NumberFormatException("Unable to parse string into date: " + this.getText());
        }
    }

    public void set(java.util.Date date) {
        if (date == null) {
            this.txtDate.setText("");
            return;
        }
        this.txtDate.setText(this.df.format(date));
    }

    public void setEnabled(boolean enabled) {
        this.btnDate.setEnabled(enabled);
        this.txtDate.setEnabled(enabled);
    }

    public boolean isEnabled() {
        return this.btnDate.isEnabled();
    }

    private void doShowCalendar() {
        if (!this.isEditable()) {
            return;
        }
        JPopupMenu menu = new JPopupMenu();
        menu.add((Component)this.getJCalendar());
        if (!this.isEmpty()) {
            java.util.Date v = this.get();
            this.getJCalendar().setDate(v);
        } else {
            this.jcalendar.setDate(null);
        }
        menu.show(this.txtDate, 0, this.txtDate.getY() + this.txtDate.getPreferredSize().height);
    }

    protected JCalendar getJCalendar() {
        if (this.jcalendar == null) {
            this.jcalendar = new JCalendar();
            this.jcalendar.setNullAllowed(true);
            this.jcalendar.addDateListener(arg0 -> {
                this.set(this.getJCalendar().getDate());
                this.fireChangeEvent();
            });
        }
        return this.jcalendar;
    }

    public void coerceAndSet(Object value) {
        this.set((java.util.Date)this.coerce(9, value, new java.util.Date()));
    }

    public DateFormat getDateFormat() {
        return this.df;
    }

    public MaskFormatter getMask() {
        return this.mask;
    }

    public void setEmptyText(String emptyText) {
        this.emptyText = emptyText;
    }

    public Timestamp getTimestamp() {
        java.util.Date x = this.get();
        if (x == null) {
            return null;
        }
        Timestamp ts = new Timestamp(x.getTime());
        return ts;
    }

    public Date getDate() {
        java.util.Date x = this.get();
        if (x == null) {
            return null;
        }
        Date d = new Date(x.getTime());
        return d;
    }
}

