/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl.task;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Objects;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.task.JTaskStatus;
import org.gvsig.tools.swing.api.task.JTasksStatusList;
import org.gvsig.tools.swing.api.task.TaskStatusSwingManager;
import org.gvsig.tools.task.TaskStatus;
import org.gvsig.tools.task.TaskStatusManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJTasksStatusList
extends JTasksStatusList
implements Observer {
    public static final Logger LOGGER = LoggerFactory.getLogger(DefaultJTasksStatusList.class);
    private static final long serialVersionUID = 7740032506050392725L;
    private final TaskStatusManager manager;
    private JTable table;

    public DefaultJTasksStatusList(TaskStatusManager manager) {
        this.manager = manager;
        this.makeUI();
        this.manager.addObserver((Observer)this);
    }

    public TaskStatusManager getManager() {
        return this.manager;
    }

    private void makeUI() {
        this.setLayout(new BorderLayout());
        final TaskStatusSwingManager swingManager = ToolsSwingLocator.getTaskStatusSwingManager();
        this.table = new JTable();
        DefaultTableColumnModel columnModel = new DefaultTableColumnModel();
        TableColumn tableColumn = new TableColumn(0, 300, new TableCellRenderer(){
            JTaskStatus component;
            JLabel empty;
            {
                this.component = swingManager.createJTaskStatus();
                this.empty = new JLabel("???");
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (value instanceof TaskStatus) {
                    this.component.bind((TaskStatus)value);
                    return this.component;
                }
                this.empty.setText("??? " + Objects.toString(value));
                return this.empty;
            }
        }, new TableCellEditor(){
            JTaskStatus component;
            JLabel empty;
            {
                this.component = swingManager.createJTaskStatus();
                this.empty = new JLabel("???");
            }

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                if (value instanceof TaskStatus) {
                    this.component.bind((TaskStatus)value);
                    return this.component;
                }
                this.empty.setText("??? " + Objects.toString(value));
                return this.empty;
            }

            @Override
            public Object getCellEditorValue() {
                return this.component.getTaskStatus();
            }

            @Override
            public boolean isCellEditable(EventObject anEvent) {
                return true;
            }

            @Override
            public boolean shouldSelectCell(EventObject anEvent) {
                return false;
            }

            @Override
            public boolean stopCellEditing() {
                return true;
            }

            @Override
            public void cancelCellEditing() {
            }

            @Override
            public void addCellEditorListener(CellEditorListener l) {
            }

            @Override
            public void removeCellEditorListener(CellEditorListener l) {
            }
        });
        JTaskStatus taskStatusHeight = swingManager.createJTaskStatus();
        taskStatusHeight.setTitle("WWWMMMGGGgggqqqjjjttt");
        taskStatusHeight.message("WWWMMMGGGgggqqqjjjttt");
        columnModel.addColumn(tableColumn);
        this.table.setColumnModel(columnModel);
        this.table.setRowHeight(taskStatusHeight.getPreferredSize().height);
        this.table.setAutoCreateColumnsFromModel(false);
        this.table.setTableHeader(null);
        this.table.setModel(this.createModel());
        JScrollPane scroller = new JScrollPane(this.table);
        scroller.setAlignmentY(0.0f);
        scroller.setPreferredSize(new Dimension(300, 150));
        this.add(scroller, "Center");
    }

    private TableModel createModel() {
        final ArrayList tasks = new ArrayList(this.manager.getAll().values());
        return new AbstractTableModel(){

            @Override
            public int getRowCount() {
                return tasks.size();
            }

            @Override
            public int getColumnCount() {
                return 1;
            }

            @Override
            public String getColumnName(int columnIndex) {
                return null;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return TaskStatus.class;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return true;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                return tasks.get(rowIndex);
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            }
        };
    }

    public void update(Observable observable, Object notification) {
        if (!(observable instanceof TaskStatusManager)) {
            return;
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> this.update(observable, notification));
            return;
        }
        if (this.table.isEditing()) {
            this.table.editingCanceled(null);
        }
        this.table.setModel(this.createModel());
    }
}

