/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.demo;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.fit.cssbox.css.CSSNorm;
import org.fit.cssbox.css.DOMAnalyzer;
import org.fit.cssbox.io.DOMSource;
import org.fit.cssbox.io.DefaultDOMSource;
import org.fit.cssbox.io.DefaultDocumentSource;
import org.fit.cssbox.io.DocumentSource;
import org.fit.cssbox.layout.BrowserCanvas;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SimpleBrowser
extends JFrame {
    private static final long serialVersionUID = -1336331141597077348L;
    private JPanel browserCanvas;
    private JScrollPane documentScroll;
    private Element docroot;
    private DOMAnalyzer decoder;

    public SimpleBrowser(Element root, URL baseurl, DOMAnalyzer decoder) {
        this.docroot = root;
        this.decoder = decoder;
        this.initComponents(baseurl);
    }

    private void initComponents(URL baseurl) {
        this.documentScroll = new JScrollPane();
        this.browserCanvas = new BrowserCanvas(this.docroot, this.decoder, new Dimension(1000, 600), baseurl);
        this.browserCanvas.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                System.out.println("Click: " + e.getX() + ":" + e.getY());
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.getContentPane().setLayout(new GridLayout(1, 0));
        this.setTitle("CSSBox Browser");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                SimpleBrowser.this.exitForm(evt);
            }
        });
        this.documentScroll.setViewportView(this.browserCanvas);
        this.getContentPane().add(this.documentScroll);
        this.pack();
    }

    private void exitForm(WindowEvent evt) {
        System.exit(0);
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Usage: SimpleBrowser <url>");
            System.exit(0);
        }
        try {
            DefaultDocumentSource docSource = new DefaultDocumentSource(args[0]);
            DefaultDOMSource parser = new DefaultDOMSource(docSource);
            Document doc = ((DOMSource)parser).parse();
            DOMAnalyzer da = new DOMAnalyzer(doc, ((DocumentSource)docSource).getURL());
            da.attributesToStyles();
            da.addStyleSheet(null, CSSNorm.stdStyleSheet(), DOMAnalyzer.Origin.AGENT);
            da.addStyleSheet(null, CSSNorm.userStyleSheet(), DOMAnalyzer.Origin.AGENT);
            da.addStyleSheet(null, CSSNorm.formsStyleSheet(), DOMAnalyzer.Origin.AGENT);
            da.getStyleSheets();
            SimpleBrowser test = new SimpleBrowser(da.getRoot(), ((DocumentSource)docSource).getURL(), da);
            test.setSize(1275, 750);
            test.setVisible(true);
            ((DocumentSource)docSource).close();
        }
        catch (Exception e) {
            System.out.println("Error: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

