/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.layout;

import cz.vutbr.web.css.CSSProperty;
import cz.vutbr.web.css.NodeData;
import cz.vutbr.web.css.Term;
import cz.vutbr.web.css.TermColor;
import cz.vutbr.web.css.TermLengthOrPercent;
import cz.vutbr.web.css.TermList;
import cz.vutbr.web.css.TermNumeric;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.util.ArrayList;
import java.util.List;
import org.fit.cssbox.css.CSSUnits;
import org.fit.cssbox.layout.BoxFactory;
import org.fit.cssbox.layout.Viewport;

public class VisualContext {
    private VisualContext parent;
    private VisualContext rootContext;
    private BoxFactory factory;
    private Viewport viewport;
    private Font font;
    private FontMetrics fm;
    private double fontSize;
    private CSSProperty.FontWeight fontWeight;
    private CSSProperty.FontStyle fontStyle;
    private CSSProperty.FontVariant fontVariant;
    private List<CSSProperty.TextDecoration> textDecoration;
    private double em;
    private double rem;
    private double ex;
    private double ch;
    private double dpi;
    public Color color;

    public VisualContext(VisualContext parent, BoxFactory factory) {
        this.parent = parent;
        this.factory = factory;
        this.rootContext = parent == null ? this : parent.rootContext;
        this.rem = this.em = 16.0;
        this.ex = 0.6 * this.em;
        this.ch = 0.8 * this.ch;
        this.dpi = CSSUnits.dpi;
        this.font = new Font("Serif", 0, 16);
        this.fontSize = CSSUnits.points(16.0);
        this.fontWeight = CSSProperty.FontWeight.NORMAL;
        this.fontStyle = CSSProperty.FontStyle.NORMAL;
        this.fontVariant = CSSProperty.FontVariant.NORMAL;
        this.textDecoration = new ArrayList<CSSProperty.TextDecoration>(2);
        this.color = Color.BLACK;
    }

    public VisualContext create() {
        VisualContext ret = new VisualContext(this, this.factory);
        ret.viewport = this.viewport;
        ret.rootContext = this.rootContext;
        ret.em = this.em;
        ret.rem = this.rem;
        ret.ex = this.ex;
        ret.ch = this.ch;
        ret.dpi = this.dpi;
        ret.font = this.font;
        ret.fontSize = this.fontSize;
        ret.fontWeight = this.fontWeight;
        ret.fontStyle = this.fontStyle;
        ret.fontVariant = this.fontVariant;
        ret.textDecoration = new ArrayList<CSSProperty.TextDecoration>(this.textDecoration);
        ret.color = this.color;
        return ret;
    }

    public VisualContext getParentContext() {
        return this.parent;
    }

    public Viewport getViewport() {
        return this.viewport;
    }

    public void setViewport(Viewport viewport) {
        this.viewport = viewport;
    }

    public boolean isRootContext() {
        return this == this.rootContext;
    }

    public void makeRootContext() {
        if (this.rootContext != null) {
            this.rootContext.rootContext = this;
        }
        this.rootContext = this;
    }

    public Font getFont() {
        return this.font;
    }

    public double getFontSize() {
        return this.fontSize;
    }

    public String getFontVariant() {
        return this.fontVariant.toString();
    }

    public String getTextDecorationString() {
        if (this.textDecoration.isEmpty()) {
            return "none";
        }
        StringBuilder ret = new StringBuilder();
        for (CSSProperty.TextDecoration dec : this.textDecoration) {
            if (ret.length() > 0) {
                ret.append(' ');
            }
            ret.append(dec.toString());
        }
        return ret.toString();
    }

    public List<CSSProperty.TextDecoration> getTextDecoration() {
        return this.textDecoration;
    }

    public Color getColor() {
        return this.color;
    }

    public double getEm() {
        return this.em;
    }

    public double getRem() {
        return this.rem;
    }

    public double getEx() {
        return this.ex;
    }

    public double getCh() {
        return this.ch;
    }

    public double getDpi() {
        return this.dpi;
    }

    public void update(NodeData style) {
        TermColor clr;
        CSSProperty.FontStyle fstyle;
        double size;
        String family = null;
        CSSProperty.FontFamily ff = (CSSProperty.FontFamily)style.getProperty("font-family");
        if (ff == null) {
            family = this.font.getFamily();
        } else if (ff == CSSProperty.FontFamily.list_values) {
            TermList fmlspec = (TermList)style.getValue(TermList.class, "font-family");
            family = fmlspec == null ? this.font.getFamily() : this.getFontName(fmlspec);
        } else {
            if (this.factory != null) {
                family = this.factory.getConfig().getDefaultFont(ff.getAWTValue());
            }
            if (family == null) {
                family = ff.getAWTValue();
            }
        }
        double psize = this.parent == null ? 16.0 : this.parent.getEm();
        CSSProperty.FontSize fsize = (CSSProperty.FontSize)style.getProperty("font-size");
        if (fsize == null) {
            size = this.em;
        } else if (fsize == CSSProperty.FontSize.length || fsize == CSSProperty.FontSize.percentage) {
            TermLengthOrPercent lenspec = (TermLengthOrPercent)style.getValue(TermLengthOrPercent.class, "font-size");
            if (lenspec != null) {
                this.em = psize;
                size = this.pxLength(lenspec, psize);
            } else {
                size = this.em;
            }
        } else {
            size = CSSUnits.convertFontSize(psize, fsize);
        }
        this.fontSize = CSSUnits.points(size);
        this.rem = this.rootContext != null ? this.rootContext.getEm() : this.em;
        CSSProperty.FontWeight weight = (CSSProperty.FontWeight)style.getProperty("font-weight");
        if (weight != null) {
            this.fontWeight = weight;
        }
        if ((fstyle = (CSSProperty.FontStyle)style.getProperty("font-style")) != null) {
            this.fontStyle = fstyle;
        }
        int fs = 0;
        if (this.representsBold(this.fontWeight)) {
            fs = 1;
        }
        if (this.fontStyle == CSSProperty.FontStyle.ITALIC || this.fontStyle == CSSProperty.FontStyle.OBLIQUE) {
            fs |= 2;
        }
        this.font = new Font(family, fs, (int)Math.round(size));
        this.em = size;
        CSSProperty.FontVariant variant = (CSSProperty.FontVariant)style.getProperty("font-variant");
        if (variant != null) {
            this.fontVariant = variant;
        }
        CSSProperty.TextDecoration decor = (CSSProperty.TextDecoration)style.getProperty("text-decoration");
        this.textDecoration.clear();
        if (decor != null) {
            if (decor == CSSProperty.TextDecoration.list_values) {
                TermList list = (TermList)style.getValue(TermList.class, "text-decoration");
                for (Term t : list) {
                    if (!(t.getValue() instanceof CSSProperty.TextDecoration)) continue;
                    this.textDecoration.add((CSSProperty.TextDecoration)t.getValue());
                }
            } else if (decor != CSSProperty.TextDecoration.NONE) {
                this.textDecoration.add(decor);
            }
        }
        if ((clr = (TermColor)style.getValue(TermColor.class, "color")) != null) {
            this.color = (Color)clr.getValue();
        }
    }

    public void updateGraphics(Graphics2D g) {
        g.setFont(this.font);
        g.setColor(this.color);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
    }

    public void updateForGraphics(NodeData style, Graphics2D g) {
        if (style != null) {
            this.update(style);
        }
        this.updateGraphics(g);
        this.fm = g.getFontMetrics();
        FontRenderContext frc = new FontRenderContext(null, false, false);
        TextLayout layout = new TextLayout("x", this.font, frc);
        this.ex = layout.getBounds().getHeight();
        this.ch = this.fm.charWidth('0');
    }

    public int getFontHeight() {
        return this.fm.getHeight();
    }

    public int getBaselineOffset() {
        return this.fm.getAscent();
    }

    public double ptLength(TermLengthOrPercent spec, double whole) {
        float nval = ((Float)spec.getValue()).floatValue();
        if (spec.isPercentage()) {
            return whole * (double)nval / 100.0;
        }
        TermNumeric.Unit unit = spec.getUnit();
        double ret = 0.0;
        if (unit == TermNumeric.Unit.pt) {
            ret = nval;
        } else if (unit == TermNumeric.Unit.in) {
            ret = nval * 72.0f;
        } else if (unit == TermNumeric.Unit.cm) {
            ret = (double)(nval * 72.0f) / 2.54;
        } else if (unit == TermNumeric.Unit.mm) {
            ret = (double)(nval * 72.0f) / 25.4;
        } else if (unit == TermNumeric.Unit.pc) {
            ret = nval * 12.0f;
        } else if (unit == TermNumeric.Unit.px) {
            ret = (double)(nval * 72.0f) / this.dpi;
        } else if (unit == TermNumeric.Unit.em) {
            ret = this.em * (double)nval * 72.0 / this.dpi;
        } else if (unit == TermNumeric.Unit.rem) {
            ret = this.rem * (double)nval * 72.0 / this.dpi;
        } else if (unit == TermNumeric.Unit.ex) {
            ret = this.ex * (double)nval * 72.0 / this.dpi;
        } else if (unit == TermNumeric.Unit.ch) {
            ret = this.ch * (double)nval * 72.0 / this.dpi;
        } else {
            if (unit == TermNumeric.Unit.vw) {
                return this.viewport.getVisibleRect().getWidth() * (double)nval * 72.0 / (100.0 * this.dpi);
            }
            if (unit == TermNumeric.Unit.vh) {
                return this.viewport.getVisibleRect().getHeight() * (double)nval * 72.0 / (100.0 * this.dpi);
            }
            if (unit == TermNumeric.Unit.vmin) {
                return Math.min(this.viewport.getVisibleRect().getWidth(), this.viewport.getVisibleRect().getHeight()) * (double)nval * 72.0 / (100.0 * this.dpi);
            }
            if (unit == TermNumeric.Unit.vmax) {
                return Math.max(this.viewport.getVisibleRect().getWidth(), this.viewport.getVisibleRect().getHeight()) * (double)nval * 72.0 / (100.0 * this.dpi);
            }
        }
        return ret;
    }

    public double ptLength(TermLengthOrPercent spec) {
        return this.ptLength(spec, 0.0);
    }

    public double pxLength(TermLengthOrPercent spec, double whole) {
        float nval = ((Float)spec.getValue()).floatValue();
        if (spec.isPercentage()) {
            return whole * (double)nval / 100.0;
        }
        TermNumeric.Unit unit = spec.getUnit();
        double ret = 0.0;
        if (unit == TermNumeric.Unit.pt) {
            ret = (double)nval * this.dpi / 72.0;
        } else if (unit == TermNumeric.Unit.in) {
            ret = (double)nval * this.dpi;
        } else if (unit == TermNumeric.Unit.cm) {
            ret = (double)nval * this.dpi / 2.54;
        } else if (unit == TermNumeric.Unit.mm) {
            ret = (double)nval * this.dpi / 25.4;
        } else if (unit == TermNumeric.Unit.pc) {
            ret = (double)(nval * 12.0f) * this.dpi / 72.0;
        } else if (unit == TermNumeric.Unit.px) {
            ret = nval;
        } else if (unit == TermNumeric.Unit.em) {
            ret = this.em * (double)nval;
        } else if (unit == TermNumeric.Unit.rem) {
            ret = this.rem * (double)nval;
        } else if (unit == TermNumeric.Unit.ex) {
            ret = this.ex * (double)nval;
        } else if (unit == TermNumeric.Unit.ch) {
            ret = this.ch * (double)nval;
        } else {
            if (unit == TermNumeric.Unit.vw) {
                return this.viewport.getVisibleRect().getWidth() * (double)nval / 100.0;
            }
            if (unit == TermNumeric.Unit.vh) {
                return this.viewport.getVisibleRect().getHeight() * (double)nval / 100.0;
            }
            if (unit == TermNumeric.Unit.vmin) {
                return Math.min(this.viewport.getVisibleRect().getWidth(), this.viewport.getVisibleRect().getHeight()) * (double)nval / 100.0;
            }
            if (unit == TermNumeric.Unit.vmax) {
                return Math.max(this.viewport.getVisibleRect().getWidth(), this.viewport.getVisibleRect().getHeight()) * (double)nval / 100.0;
            }
        }
        return ret;
    }

    public double pxLength(TermLengthOrPercent spec) {
        return this.pxLength(spec, 0.0);
    }

    public boolean representsBold(CSSProperty.FontWeight weight) {
        return weight == CSSProperty.FontWeight.BOLD || weight == CSSProperty.FontWeight.BOLDER || weight == CSSProperty.FontWeight.numeric_600 || weight == CSSProperty.FontWeight.numeric_700 || weight == CSSProperty.FontWeight.numeric_800 || weight == CSSProperty.FontWeight.numeric_900;
    }

    public String getFontName(TermList list) {
        String[] avail = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        for (Term term : list) {
            Object value = term.getValue();
            if (value instanceof CSSProperty.FontFamily) {
                return ((CSSProperty.FontFamily)value).getAWTValue();
            }
            String name = this.fontAvailable(value.toString(), avail);
            if (name == null) continue;
            return name;
        }
        return "Serif";
    }

    private String fontAvailable(String family, String[] avail) {
        for (int i = 0; i < avail.length; ++i) {
            if (!avail[i].equalsIgnoreCase(family)) continue;
            return avail[i];
        }
        return null;
    }

    public Color getColor(String spec) {
        if (spec.startsWith("rgb(")) {
            String s = spec.substring(4, spec.length() - 1);
            String[] lst = s.split(",");
            try {
                int r = Integer.parseInt(lst[0].trim());
                int g = Integer.parseInt(lst[1].trim());
                int b = Integer.parseInt(lst[2].trim());
                return new Color(r, g, b);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }
}

