/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator;

import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.I18N;
import org.gvsig.expressionevaluator.LexicalAnalyzer;

public class ExpressionSyntaxException
extends RuntimeException {
    private final int position;
    private final int line;
    private final int column;
    private final String phrase;
    private final String description;
    private final String tip;

    public ExpressionSyntaxException() {
        super("Syntax error in expression.");
        this.phrase = null;
        this.position = -1;
        this.line = -1;
        this.column = -1;
        this.description = I18N.Syntax_error_in_expression();
        this.tip = null;
    }

    public ExpressionSyntaxException(LexicalAnalyzer lexer) {
        this(null, lexer, null);
    }

    public ExpressionSyntaxException(String msg, LexicalAnalyzer lexer) {
        this(msg, lexer, null);
    }

    public ExpressionSyntaxException(String msg, LexicalAnalyzer lexer, String tip) {
        this(msg, lexer.getSource(), lexer.getMaxPosition(), lexer.getMaxLine(), lexer.getMaxColumn(), tip);
    }

    public ExpressionSyntaxException(String phrase, int position) {
        this(null, phrase, position, -1, -1, null);
    }

    public ExpressionSyntaxException(String msg, String phrase, int position, String tip) {
        this(msg, phrase, position, -1, -1, tip);
    }

    public ExpressionSyntaxException(String msg, String phrase, int position, int line, int column, String tip) {
        super("Syntax error in '" + ExpressionSyntaxException.getSource(phrase, position) + "' near character " + ExpressionSyntaxException.formatPosition(position, line, column) + ". " + StringUtils.trimToEmpty((String)msg));
        this.phrase = phrase;
        this.position = position;
        this.line = line;
        this.column = column;
        this.description = StringUtils.isBlank((CharSequence)msg) ? I18N.Syntax_error_near_character_XPositionX(position) : I18N.Syntax_error_near_character_XPositionX(position) + " " + msg;
        this.tip = tip;
    }

    private static String formatPosition(int position, int line, int column) {
        if (line < 0 || column < 0) {
            return String.valueOf(position);
        }
        return position + " (" + line + ":" + column + ")";
    }

    private static String getSource(String source, int position) {
        String s = StringUtils.left((String)source, (int)position) + "[*]" + StringUtils.mid((String)source, (int)position, (int)200);
        if (s.length() > 200) {
            s = "..." + StringUtils.mid((String)s, (int)(position - 100), (int)200) + "...";
        }
        return s;
    }

    public String getPhrase() {
        return this.phrase;
    }

    public int getPosition() {
        return this.position;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public String getDescription() {
        return this.description;
    }

    public String getTip() {
        return this.tip;
    }
}

