/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator;

import java.awt.Color;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.json.JsonObject;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.Code;
import org.gvsig.expressionevaluator.CodeBuilder;
import org.gvsig.expressionevaluator.Compiler;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.ExpressionEvaluatorLocator;
import org.gvsig.expressionevaluator.ExpressionEvaluatorManager;
import org.gvsig.expressionevaluator.Formatter;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.MutableSymbolTable;
import org.gvsig.expressionevaluator.Optimizer;
import org.gvsig.expressionevaluator.ReprMethod;
import org.gvsig.expressionevaluator.SymbolTable;
import org.gvsig.expressionevaluator.spi.DynObjectSymbolTable;
import org.gvsig.tools.dataTypes.DataTypeUtils;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.resourcesstorage.ResourcesStorage;
import org.gvsig.tools.script.Script;
import org.gvsig.tools.util.ListBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExpressionUtils.class);
    private static final List<String> TRUE_VALUES = ListBuilder.create((Object[])new Object[]{"true", "on", "t", "1", "-1"});
    private static final List<String> FALSE_VALUES = ListBuilder.create((Object[])new Object[]{"false", "off", "f", "0"});
    private static final Pattern COLOR_PATTERN3 = Pattern.compile("COLOR[(][ ]*(?<R>[0-9]{1,3})[ ]*,[ ]*(?<G>[0-9]{1,3})[ ]*,[ ]*(?<B>[0-9]{1,3})[ ]*[)]", 2);
    private static final Pattern COLOR_PATTERN4 = Pattern.compile("COLOR[(][ ]*(?<R>[0-9]{1,3})[ ]*,[ ]*(?<G>[0-9]{1,3})[ ]*,[ ]*(?<B>[0-9]{1,3})[ ]*,[ ]*(?<A>[0-9]{1,3})[ ]*[)]", 2);

    public static boolean isEmpty(Expression expression) {
        return expression == null || expression.isEmpty();
    }

    public static boolean isPhraseEmpty(Expression expression) {
        return expression == null || expression.isPhraseEmpty();
    }

    public static Expression defaultIfEmpty(Expression expression, Expression defaultValue) {
        if (expression == null || expression.isEmpty()) {
            return defaultValue;
        }
        return expression;
    }

    public static Expression defaultNullIfEmpty(Expression expression) {
        if (expression == null || expression.isEmpty()) {
            return null;
        }
        return expression;
    }

    public static Expression defaultIfPhraseEmpty(Expression expression, Expression defaultValue) {
        if (expression == null || expression.isPhraseEmpty()) {
            return defaultValue;
        }
        return expression;
    }

    public static Expression defaultNullIfPhraseEmpty(Expression expression) {
        if (expression == null || expression.isPhraseEmpty()) {
            return null;
        }
        return expression;
    }

    public static Expression createExpression() {
        Expression expression = ExpressionEvaluatorLocator.getManager().createExpression();
        return expression;
    }

    public static Expression createExpression(String phrase) {
        if (StringUtils.isBlank((CharSequence)phrase)) {
            return null;
        }
        Expression expression = ExpressionEvaluatorLocator.getManager().createExpression();
        expression.setPhrase(phrase);
        return expression;
    }

    public static Expression createExpression(Expression expression) {
        return expression;
    }

    public static ExpressionBuilder createExpressionBuilder() {
        ExpressionBuilder builder = ExpressionEvaluatorLocator.getManager().createExpressionBuilder();
        return builder;
    }

    public static Code compile(String expression) {
        if (StringUtils.isBlank((CharSequence)expression)) {
            return null;
        }
        ExpressionEvaluatorManager manager = ExpressionEvaluatorLocator.getManager();
        Code code = manager.compile(expression);
        return code;
    }

    public static Object evaluate(String expression) {
        return ExpressionUtils.evaluate(null, expression);
    }

    public static Object evaluate(SymbolTable symbolTable, String expression) {
        if (StringUtils.isBlank((CharSequence)expression)) {
            return null;
        }
        ExpressionEvaluatorManager manager = ExpressionEvaluatorLocator.getManager();
        Object x = manager.evaluate(symbolTable, expression);
        return x;
    }

    public static Object evaluate(SymbolTable symbolTable, Code code) {
        ExpressionEvaluatorManager manager = ExpressionEvaluatorLocator.getManager();
        Object x = manager.evaluate(symbolTable, code);
        return x;
    }

    public static Code optimize(SymbolTable symbolTable, Code code) {
        ExpressionEvaluatorManager manager = ExpressionEvaluatorLocator.getManager();
        code = manager.optimize(symbolTable, code);
        return code;
    }

    public static String toString(ExpressionBuilder.Value value, Formatter formatter) {
        if (value == null) {
            return null;
        }
        if (formatter == null) {
            ExpressionEvaluatorManager manager = ExpressionEvaluatorLocator.getManager();
            formatter = manager.getExpressionBuilderFormatter();
        }
        return value.toString(formatter);
    }

    public static String toString(ExpressionBuilder.Value value) {
        return ExpressionUtils.toString(value, null);
    }

    public static String toString(Code code, Formatter formatter) {
        if (code == null) {
            return null;
        }
        if (formatter == null) {
            formatter = Code.EMPTY_FORMATTER;
        }
        return code.toString(formatter);
    }

    public static String toString(Code code) {
        return ExpressionUtils.toString(code, null);
    }

    public static Expression createExpressionFromJSON(String json) {
        Expression expression = ExpressionUtils.createExpression();
        expression.fromJSON(json);
        return expression;
    }

    public static Expression createExpressionFromJson(JsonObject json) {
        Expression expression = ExpressionUtils.createExpression();
        expression.fromJson(json);
        return expression;
    }

    public static MutableSymbolTable createSymbolTable() {
        ExpressionEvaluatorManager manager = ExpressionEvaluatorLocator.getManager();
        MutableSymbolTable symbolTable = manager.createSymbolTable();
        return symbolTable;
    }

    public static MutableSymbolTable createSymbolTable(DynObject obj) {
        DynObjectSymbolTable symbolTable = new DynObjectSymbolTable("object", obj);
        return symbolTable;
    }

    public static MutableSymbolTable createSymbolTable(String name, DynObject obj) {
        DynObjectSymbolTable symbolTable = new DynObjectSymbolTable(name, obj);
        return symbolTable;
    }

    public static String surroundByDynamicTextTag(String source) {
        return ExpressionUtils.surroundByDynamicTextTag(source, true);
    }

    public static String surroundByDynamicTextTag(String source, boolean insert) {
        if (source == null) {
            return null;
        }
        if (insert) {
            return "<%=" + source + "%>";
        }
        return "<%" + source + "%>";
    }

    public static boolean isDynamicText(String source) {
        if (StringUtils.isBlank((CharSequence)source) || !source.contains("<%")) {
            return false;
        }
        Object[] sources = StringUtils.substringsBetween((String)source, (String)"<%", (String)"%>");
        return !ArrayUtils.isEmpty((Object[])sources);
    }

    public static String evaluateDynamicText(String source) {
        ExpressionEvaluatorManager manager = ExpressionEvaluatorLocator.getManager();
        return manager.evaluateDynamicText(source);
    }

    public static String evaluateDynamicText(SymbolTable symbolTable, String source) {
        ExpressionEvaluatorManager manager = ExpressionEvaluatorLocator.getManager();
        return manager.evaluateDynamicText(symbolTable, source);
    }

    public static File evaluateFilename(File source) {
        return ExpressionUtils.evaluateFilename(null, source);
    }

    public static URL evaluateURL(URL source) {
        return ExpressionUtils.evaluateURL(null, source);
    }

    public static boolean isDynamicFilename(File source) {
        if (source == null) {
            return false;
        }
        return ExpressionUtils.isDynamicText(source.getPath());
    }

    public static boolean isDynamicURL(URL source) {
        if (source == null) {
            return false;
        }
        return ExpressionUtils.isDynamicText(source.toString());
    }

    public static File createDynamicFile(ExpressionBuilder.Value builder) {
        File f = new File(ExpressionUtils.surroundByDynamicTextTag(builder.toString()));
        return f;
    }

    public static File createDynamicFile(String expression) {
        File f = new File(ExpressionUtils.surroundByDynamicTextTag(expression));
        return f;
    }

    public static File evaluateFilename(SymbolTable symbolTable, File source) {
        String src = source.getPath();
        if (!ExpressionUtils.isDynamicText(src)) {
            return source;
        }
        ExpressionEvaluatorManager manager = ExpressionEvaluatorLocator.getManager();
        String r = manager.evaluateDynamicText(symbolTable, src);
        if (r == src) {
            return source;
        }
        File f = new File(r);
        return f;
    }

    public static URL evaluateURL(SymbolTable symbolTable, URL source) {
        String src = source.toString();
        if (!ExpressionUtils.isDynamicText(src)) {
            return source;
        }
        ExpressionEvaluatorManager manager = ExpressionEvaluatorLocator.getManager();
        String r = manager.evaluateDynamicText(symbolTable, src);
        if (r == src) {
            return source;
        }
        try {
            URL url = new URL(r);
            return url;
        }
        catch (MalformedURLException ex) {
            return source;
        }
    }

    public static int parseInt(String s) throws NumberFormatException {
        Object x;
        if (StringUtils.isBlank((CharSequence)s)) {
            throw new NumberFormatException("Can't get integer from a blank string.");
        }
        ExpressionEvaluatorManager manager = ExpressionEvaluatorLocator.getManager();
        SymbolTable symbolTable = null;
        try {
            x = manager.evaluate(symbolTable, s);
            if (x instanceof Number) {
                return ((Number)x).intValue();
            }
        }
        catch (Exception ex) {
            NumberFormatException ex1 = new NumberFormatException("Can't get integer from '" + s + "'.");
            ex1.initCause(ex);
            throw ex;
        }
        if (x == null) {
            throw new NumberFormatException("Can't get integer from '" + s + "' value is null.");
        }
        throw new NumberFormatException("Can't get integer from '" + s + "' value is a " + x.getClass().getSimpleName() + ".");
    }

    public static long parseLong(String s) throws NumberFormatException {
        if (StringUtils.isBlank((CharSequence)s)) {
            throw new NumberFormatException("Can't get long from a blank string.");
        }
        try {
            int value = Integer.parseInt(s);
            return value;
        }
        catch (Exception value) {
            Object x;
            ExpressionEvaluatorManager manager = ExpressionEvaluatorLocator.getManager();
            SymbolTable symbolTable = null;
            try {
                x = manager.evaluate(symbolTable, s);
                if (x instanceof Number) {
                    return ((Number)x).longValue();
                }
            }
            catch (Exception ex) {
                NumberFormatException ex1 = new NumberFormatException("Can't get long from '" + s + "'.");
                ex1.initCause(ex);
                throw ex;
            }
            if (x == null) {
                throw new NumberFormatException("Can't get long from '" + s + "' value is null.");
            }
            throw new NumberFormatException("Can't get long from '" + s + "' value is a " + x.getClass().getSimpleName() + ".");
        }
    }

    public static double parseDouble(String s) throws NumberFormatException {
        if (StringUtils.isBlank((CharSequence)s)) {
            throw new NumberFormatException("Can't get double from a blank string.");
        }
        try {
            double value = Double.parseDouble(s);
            return value;
        }
        catch (Exception value) {
            Object x;
            ExpressionEvaluatorManager manager = ExpressionEvaluatorLocator.getManager();
            SymbolTable symbolTable = null;
            try {
                x = manager.evaluate(symbolTable, s);
                if (x instanceof Number) {
                    return ((Number)x).doubleValue();
                }
            }
            catch (Exception ex) {
                NumberFormatException ex1 = new NumberFormatException("Can't get double from '" + s + "'.");
                ex1.initCause(ex);
                throw ex;
            }
            if (x == null) {
                throw new NumberFormatException("Can't get double from '" + s + "' value is null.");
            }
            throw new NumberFormatException("Can't get double from '" + s + "' value is a " + x.getClass().getSimpleName() + ".");
        }
    }

    public static Compiler createCompiler() {
        ExpressionEvaluatorManager manager = ExpressionEvaluatorLocator.getManager();
        Compiler compiler = manager.createCompiler();
        return compiler;
    }

    public static Interpreter createInterpreter() {
        ExpressionEvaluatorManager manager = ExpressionEvaluatorLocator.getManager();
        Interpreter interpreter = manager.createInterpreter();
        return interpreter;
    }

    public static Optimizer createOptimizer() {
        ExpressionEvaluatorManager manager = ExpressionEvaluatorLocator.getManager();
        Optimizer optimizer = manager.createOptimizer();
        return optimizer;
    }

    public static String repr(Object value) {
        ExpressionEvaluatorManager manager = ExpressionEvaluatorLocator.getManager();
        ReprMethod method = manager.getReprMethod(value);
        return method.repr(value);
    }

    public static CodeBuilder createCodeBuilder() {
        ExpressionEvaluatorManager manager = ExpressionEvaluatorLocator.getManager();
        return manager.createCodeBuilder();
    }

    public static boolean parseBoolean(SymbolTable symbolTable, String expression, boolean defaultValue) {
        if (StringUtils.isBlank((CharSequence)(expression = StringUtils.trimToNull((String)expression)))) {
            return defaultValue;
        }
        if (TRUE_VALUES.contains(expression.toLowerCase())) {
            return true;
        }
        if (FALSE_VALUES.contains(expression.toLowerCase())) {
            return false;
        }
        try {
            return (Boolean)ExpressionUtils.evaluate(symbolTable, expression);
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    public static boolean parseBoolean(String expression) {
        if (StringUtils.isBlank((CharSequence)(expression = StringUtils.trimToNull((String)expression)))) {
            throw new IllegalArgumentException("Can't get boolean from a blank string.");
        }
        if (TRUE_VALUES.contains(expression.toLowerCase())) {
            return true;
        }
        if (FALSE_VALUES.contains(expression.toLowerCase())) {
            return false;
        }
        try {
            Object x = ExpressionUtils.evaluate(null, expression);
            return (Boolean)x;
        }
        catch (Exception ex) {
            IllegalArgumentException ex1 = new IllegalArgumentException("Can't get boolean from '" + expression + "'.");
            ex1.initCause(ex);
            throw ex;
        }
    }

    public static int parseInt(SymbolTable symbolTable, String expression, int defaultValue) {
        if (StringUtils.isBlank((CharSequence)expression)) {
            return defaultValue;
        }
        try {
            int value = Integer.parseInt(expression);
            return value;
        }
        catch (Exception value) {
            ExpressionEvaluatorManager manager = ExpressionEvaluatorLocator.getManager();
            try {
                Object x = manager.evaluate(symbolTable, expression);
                if (x instanceof Number) {
                    return ((Number)x).intValue();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return defaultValue;
        }
    }

    public static long parseLong(SymbolTable symbolTable, String expression, long defaultValue) {
        if (StringUtils.isBlank((CharSequence)expression)) {
            return defaultValue;
        }
        try {
            int value = Integer.parseInt(expression);
            return value;
        }
        catch (Exception value) {
            ExpressionEvaluatorManager manager = ExpressionEvaluatorLocator.getManager();
            try {
                Object x = manager.evaluate(symbolTable, expression);
                if (x instanceof Number) {
                    return ((Number)x).longValue();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return defaultValue;
        }
    }

    public static double parseDouble(SymbolTable symbolTable, String expression, double defaultValue) {
        if (StringUtils.isBlank((CharSequence)expression)) {
            return defaultValue;
        }
        try {
            double value = Double.parseDouble(expression);
            return value;
        }
        catch (Exception value) {
            ExpressionEvaluatorManager manager = ExpressionEvaluatorLocator.getManager();
            try {
                Object x = manager.evaluate(symbolTable, expression);
                if (x instanceof Number) {
                    return ((Number)x).doubleValue();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return defaultValue;
        }
    }

    public static Color parseColor(SymbolTable symbolTable, String expression, Color defaultValue) {
        if (StringUtils.isBlank((CharSequence)expression)) {
            return defaultValue;
        }
        try {
            ExpressionEvaluatorManager manager;
            Object x;
            if (StringUtils.startsWithIgnoreCase((CharSequence)expression, (CharSequence)"color(") && StringUtils.endsWithIgnoreCase((CharSequence)expression, (CharSequence)")")) {
                Matcher m = COLOR_PATTERN4.matcher(expression);
                if (m != null && m.matches()) {
                    Color color = new Color(Integer.valueOf(m.group("R")), Integer.valueOf(m.group("G")), Integer.valueOf(m.group("B")), Integer.valueOf(m.group("A")));
                    return color;
                }
                m = COLOR_PATTERN3.matcher(expression);
                if (m != null && m.matches()) {
                    Color color = new Color(Integer.valueOf(m.group("R")), Integer.valueOf(m.group("G")), Integer.valueOf(m.group("B")));
                    return color;
                }
            }
            if ((x = (manager = ExpressionEvaluatorLocator.getManager()).evaluate(symbolTable, expression)) instanceof Color) {
                return (Color)x;
            }
            Color color = (Color)DataTypeUtils.coerce((int)96, (Object)expression, null);
            if (color != null) {
                return color;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }

    public static Color parseColor(String expression) {
        Object x;
        if (StringUtils.isBlank((CharSequence)expression)) {
            throw new IllegalArgumentException("Can't get color from a blank string.");
        }
        try {
            ExpressionEvaluatorManager manager;
            if (StringUtils.startsWithIgnoreCase((CharSequence)expression, (CharSequence)"color(") && StringUtils.endsWithIgnoreCase((CharSequence)expression, (CharSequence)")")) {
                Matcher m = COLOR_PATTERN4.matcher(expression);
                if (m != null && m.matches()) {
                    Color color = new Color(Integer.valueOf(m.group("R")), Integer.valueOf(m.group("G")), Integer.valueOf(m.group("B")), Integer.valueOf(m.group("A")));
                    return color;
                }
                m = COLOR_PATTERN3.matcher(expression);
                if (m != null && m.matches()) {
                    Color color = new Color(Integer.valueOf(m.group("R")), Integer.valueOf(m.group("G")), Integer.valueOf(m.group("B")), Integer.valueOf(m.group("A")));
                    return color;
                }
            }
            if ((x = (manager = ExpressionEvaluatorLocator.getManager()).evaluate(null, expression)) instanceof Color) {
                return (Color)x;
            }
            if (x instanceof Number) {
                return new Color(((Number)x).intValue());
            }
        }
        catch (Exception ex) {
            IllegalArgumentException ex1 = new IllegalArgumentException("Can't get color from '" + expression + "'.");
            ex1.initCause(ex);
            throw ex;
        }
        if (x == null) {
            throw new IllegalArgumentException("Can't get double from '" + expression + "' value is null.");
        }
        throw new IllegalArgumentException("Can't get double from '" + expression + "' value is a " + x.getClass().getSimpleName() + ".");
    }

    public static boolean isValidIdentifier(String name) {
        String s = StringUtils.strip((String)name);
        if (StringUtils.isEmpty((CharSequence)s)) {
            return false;
        }
        if (s.charAt(0) == '\"' && s.charAt(s.length() - 1) == '\"') {
            return !StringUtils.contains((CharSequence)(s = StringUtils.unwrap((String)s, (char)'\"')), (int)34);
        }
        char ch = s.charAt(0);
        if (Character.isDigit(ch)) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            ch = s.charAt(i);
            if (Character.isJavaIdentifierPart(ch)) continue;
            return false;
        }
        return true;
    }

    public static Expression resolveHostExpressions(Expression expression, SymbolTable symbolTable) {
        Expression expression1 = ExpressionEvaluatorLocator.getManager().resolveHostExpressions(expression, symbolTable);
        return expression1;
    }

    public static ExpressionBuilder.Value resolveHostExpressions(ExpressionBuilder.Value statement, SymbolTable symbolTable) {
        ExpressionBuilder.Value statement1 = ExpressionEvaluatorLocator.getManager().resolveHostExpressions(statement, symbolTable);
        return statement1;
    }

    public static ExpressionBuilder.Value getHostExpressionValue(ExpressionBuilder.Function hostExpression, ExpressionBuilder expbuilder) {
        ExpressionBuilder.Value statement1 = ExpressionEvaluatorLocator.getManager().getHostExpressionValue(hostExpression, expbuilder);
        return statement1;
    }

    public static ExpressionBuilder.Value getHostExpressionValue(ExpressionBuilder.Function hostExpression, ExpressionBuilder expbuilder, SymbolTable symboltable) {
        ExpressionBuilder.Value statement1 = ExpressionEvaluatorLocator.getManager().getHostExpressionValue(hostExpression, expbuilder, symboltable);
        return statement1;
    }

    public static String getPhrase(Expression expression) {
        if (expression == null) {
            return null;
        }
        String s = expression.getPhrase();
        return (String)StringUtils.defaultIfBlank((CharSequence)s, null);
    }

    public static Script createScript(byte[] bytes, String name) {
        try {
            if (StringUtils.isBlank((CharSequence)name)) {
                return null;
            }
            String source = "";
            if (!ArrayUtils.isEmpty((byte[])bytes)) {
                source = IOUtils.toString((byte[])bytes, (String)StandardCharsets.UTF_8.name());
            }
            ExpressionEvaluatorManager scriptManager = ExpressionEvaluatorLocator.getManager();
            Script script = scriptManager.createScript(name, source, null);
            return script;
        }
        catch (Exception ex) {
            LOGGER.warn("Can't create script " + name + ".", (Throwable)ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Script getScript(ResourcesStorage resources, String resourceName) {
        Script script;
        String source;
        ResourcesStorage.Resource res;
        block9: {
            block8: {
                block7: {
                    res = null;
                    if (resources != null && !StringUtils.isBlank((CharSequence)resourceName)) break block7;
                    Script script2 = null;
                    DisposeUtils.disposeQuietly(res);
                    return script2;
                }
                res = resources.getResource(resourceName);
                if (res != null && res.exists()) break block8;
                Script script3 = null;
                DisposeUtils.disposeQuietly((Object)res);
                return script3;
            }
            source = IOUtils.toString((InputStream)res.asInputStream(), (Charset)StandardCharsets.UTF_8);
            if (!StringUtils.isEmpty((CharSequence)source)) break block9;
            Script script4 = null;
            DisposeUtils.disposeQuietly((Object)res);
            return script4;
        }
        try {
            Script script5;
            ExpressionEvaluatorManager scriptManager = ExpressionEvaluatorLocator.getManager();
            script = script5 = scriptManager.createScript(resourceName, source, null);
        }
        catch (Exception ex) {
            Script script6;
            try {
                LOGGER.warn("Can't load script from resource " + resourceName + ".", (Throwable)ex);
                script6 = null;
            }
            catch (Throwable throwable) {
                DisposeUtils.disposeQuietly(res);
                throw throwable;
            }
            DisposeUtils.disposeQuietly((Object)res);
            return script6;
        }
        DisposeUtils.disposeQuietly((Object)res);
        return script;
    }

    public static MutableSymbolTable createEmptySymbolTable() {
        ExpressionEvaluatorManager manager = ExpressionEvaluatorLocator.getManager();
        MutableSymbolTable symbolTable = manager.createEmptySymbolTable();
        return symbolTable;
    }

    public static SymbolTable createBookmarksSymbolTable(String bookmarkGroup) {
        ExpressionEvaluatorManager manager = ExpressionEvaluatorLocator.getManager();
        SymbolTable symbolTable = manager.createBookmarksSymbolTable(bookmarkGroup);
        return symbolTable;
    }
}

