/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.installer.prov.plugin.execution;

import com.sardak.antform.AntForm;
import com.sardak.antform.AntMenu;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.gvsig.installer.lib.api.InstallerLocator;
import org.gvsig.installer.lib.api.InstallerManager;
import org.gvsig.installer.lib.api.PackageInfo;
import org.gvsig.installer.lib.api.execution.InstallPackageServiceException;
import org.gvsig.installer.lib.spi.InstallPackageProviderServices;
import org.gvsig.installer.lib.spi.InstallerProviderLocator;
import org.gvsig.installer.lib.spi.InstallerProviderManager;
import org.gvsig.installer.lib.spi.execution.InstallPackageProvider;
import org.gvsig.tools.service.spi.AbstractProvider;
import org.gvsig.tools.service.spi.ProviderServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginInstallerExecutionProvider
extends AbstractProvider
implements InstallPackageProvider {
    private static Logger logger = LoggerFactory.getLogger(PluginInstallerExecutionProvider.class);
    private static final String ANT_FILE_NAME = "install.xml";

    public PluginInstallerExecutionProvider(ProviderServices providerServices) {
        super(providerServices);
    }

    public void install(File applicationDirectory, InputStream inputStream, PackageInfo packageInfo) throws InstallPackageServiceException {
        InstallerProviderManager installerProviderManager = InstallerProviderLocator.getProviderManager();
        InstallerManager installerManager = InstallerLocator.getInstallerManager();
        File pluginsDirectory = installerManager.getDefaultLocalAddonRepository("plugin", 1);
        logger.info("Installing package '" + packageInfo.getCode() + "' in '" + pluginsDirectory + "'.");
        try {
            if (!pluginsDirectory.exists()) {
                logger.warn("Can install package '" + packageInfo.getCode() + "', install folder '" + pluginsDirectory + "' does not exists");
                throw new InstallerPluginsDirectoryNotFoundException();
            }
            InstallPackageProviderServices installerProviderServices = installerProviderManager.createInstallerProviderServices();
            installerProviderServices.decompress(inputStream, pluginsDirectory);
            File antFile = new File(pluginsDirectory + File.separator + packageInfo.getCode() + File.separator + "install" + File.separator + ANT_FILE_NAME);
            if (antFile.exists()) {
                this.executeAntFile(applicationDirectory, pluginsDirectory, antFile);
            }
        }
        catch (Exception e) {
            try {
                logger.warn("Can install package '" + packageInfo.getCode() + "'.", (Throwable)e);
                this.installLater(applicationDirectory, inputStream, packageInfo);
            }
            catch (IOException e1) {
                logger.warn("Can install package '" + packageInfo.getCode() + "'.", (Throwable)e1);
                throw new InstallPackageServiceException((Throwable)e1);
            }
        }
    }

    public void installLater(File applicationDirectory, InputStream inputStream, PackageInfo packageInfo) throws InstallPackageServiceException, IOException {
        File filesDirectory;
        InstallerProviderManager installerProviderManager = InstallerProviderLocator.getProviderManager();
        File decompressDir = null;
        logger.info("Delayed the package installation (" + packageInfo.getCode() + ").");
        File updateDirectory = new File(applicationDirectory + File.separator + "update");
        if (!updateDirectory.exists()) {
            this.forceMkdir(updateDirectory);
        }
        if (!(filesDirectory = new File(updateDirectory + File.separator + "files")).exists()) {
            this.forceMkdir(filesDirectory);
        }
        File scriptsFile = new File(updateDirectory + File.separator + "scripts.lst");
        decompressDir = new File(filesDirectory.toString() + File.separator + packageInfo.getCode());
        if (decompressDir.exists()) {
            this.deleteDir(decompressDir);
        }
        InstallPackageProviderServices installerProviderServices = installerProviderManager.createInstallerProviderServices();
        installerProviderServices.decompress(inputStream, filesDirectory);
        File antFile = new File(decompressDir + File.separator + "install" + File.separator + ANT_FILE_NAME);
        if (antFile.exists()) {
            if (!scriptsFile.exists()) {
                this.forceMkdir(scriptsFile);
                scriptsFile.createNewFile();
            }
            FileWriter writer = new FileWriter(scriptsFile, true);
            BufferedWriter out = new BufferedWriter(writer);
            String str = antFile.toString();
            out.append(str + "\n");
            out.close();
        }
    }

    private void forceMkdir(File file) throws IOException {
        if (file.isDirectory()) {
            FileUtils.forceMkdir((File)file);
        } else {
            FileUtils.forceMkdir((File)file.getParentFile());
        }
    }

    private void executeAntFile(File applicationDirectory, File pluginsDirectory, File file) {
        logger.info("Running install script '" + file.getAbsolutePath() + "'.");
        try {
            Project p = new Project();
            p.setUserProperty("ant.file", file.getAbsolutePath());
            p.setUserProperty("gvsig_dir", applicationDirectory.getAbsolutePath());
            p.setUserProperty("extensions_dir", pluginsDirectory.getAbsolutePath());
            p.setBaseDir(file.getParentFile());
            p.addTaskDefinition("antform", AntForm.class);
            p.addTaskDefinition("antmenu", AntMenu.class);
            p.init();
            ProjectHelper helper = ProjectHelper.getProjectHelper();
            p.addReference("ant.projectHelper", (Object)helper);
            helper.parse(p, (Object)file);
            p.executeTarget(p.getDefaultTarget());
        }
        catch (Exception ex) {
            logger.warn("Problems executing installation script.", (Throwable)ex);
        }
    }

    private boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = this.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public class InstallerPluginsDirectoryNotFoundException
    extends InstallPackageServiceException {
        private static final long serialVersionUID = 4416143986837955880L;
        private static final String message = "Plugins directory not found";
        private static final String KEY = "plugins_directory_not_found";

        public InstallerPluginsDirectoryNotFoundException() {
            super(message, KEY, 4416143986837955880L);
        }
    }
}

