/*
 * Decompiled with CFR 0.152.
 */
package com.sardak.antform.gui;

import com.sardak.antform.gui.CallBack;
import com.sardak.antform.gui.CallBackDialog;
import com.sardak.antform.gui.ControlPanel;
import com.sardak.antform.types.AntMenuItem;
import com.sardak.antform.util.FocusedComponent;
import com.sardak.antform.util.MnemonicsUtil;
import com.sardak.antform.util.StyleUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class Control {
    private CallBackDialog dialog;
    private Properties properties = new Properties();
    private CallBack callBack;
    private ControlPanel panel;
    private int width = -1;
    private int height = -1;
    private String title;
    private File image;
    private JScrollPane scrollPane;
    private boolean firstShow = true;
    private List menuItems;
    private JMenuBar menuBar;
    private FocusedComponent focusedComponent = null;

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public ControlPanel getPanel() {
        return this.panel;
    }

    public Control(CallBack antCallBack, String title, File iconFile, File image, boolean tabbed) {
        this.init(antCallBack, title, iconFile, image, tabbed);
    }

    public void init(CallBack antCallBack, String title, File iconFile, File image, boolean tabbed) {
        this.callBack = antCallBack;
        if (this.dialog == null) {
            this.dialog = new CallBackDialog();
            this.dialog.setTitle(title);
            this.dialog.setIcon(iconFile);
            this.title = title;
            this.image = image;
            this.newPanel(tabbed);
            this.init();
            this.getPanel().init();
        }
    }

    public void init() {
        this.menuItems = new ArrayList();
    }

    public void newPanel(boolean tabbed) {
        this.panel = new ControlPanel(this, tabbed);
        JPanel container = new JPanel();
        container.setBorder(null);
        container.setLayout(new BorderLayout());
        container.setBackground(Color.white);
        this.dialog.setContentPane(container);
        if (this.title != null) {
            this.panel.setTitle(this.title);
        }
        if (this.image != null) {
            this.panel.setImage(this.image);
        }
        this.scrollPane = new JScrollPane(this.panel);
        this.dialog.getContentPane().add((Component)this.scrollPane, "Center");
    }

    public void updateLookAndFeel(String lookAndFeel) {
        try {
            UIManager.setLookAndFeel(lookAndFeel);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
        SwingUtilities.updateComponentTreeUI(this.dialog);
    }

    public void setTitle(String title) {
        this.dialog.setTitle(title);
    }

    public void setFocusedComponent(FocusedComponent focusedComponent) {
        this.focusedComponent = focusedComponent;
    }

    public void pack() {
        this.dialog.pack();
    }

    public void show() {
        if (this.firstShow) {
            this.pack();
            if (this.width != -1) {
                this.dialog.setSize(this.width, this.dialog.getHeight());
            }
            if (this.height != -1) {
                this.dialog.setSize(this.dialog.getWidth(), this.height);
            }
            this.center();
            if (this.height == -1 && this.width == -1) {
                this.pack();
                this.pack();
            }
            this.firstShow = false;
        }
        if (this.focusedComponent != null && this.focusedComponent.getComponent() != null) {
            this.getPanel().activateTab(this.focusedComponent.getTabIndex());
            this.focusedComponent.getComponent().requestFocus();
        }
        this.dialog.display();
    }

    private void center() {
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension size = this.dialog.getSize();
        this.dialog.setLocation(d.width / 2 - size.width / 2, d.height / 2 - size.height / 2);
    }

    public void close() {
        this.dialog.dispose();
    }

    public Properties getProperties() {
        return this.properties;
    }

    public JMenuBar getMenuBar() {
        if (this.menuBar == null) {
            this.menuBar = new JMenuBar();
            this.dialog.setJMenuBar(this.menuBar);
        }
        return this.menuBar;
    }

    public void addAntMenuItem(AntMenuItem antMenuItem, JMenuItem parentMenu) {
        JMenuItem item = antMenuItem.getSubMenuItems().size() == 0 ? new JMenuItem() : new JMenu();
        item.setText(antMenuItem.getName());
        String sToUse = MnemonicsUtil.newMnemonic(antMenuItem.getName(), this.panel.getUsedLetters());
        if (sToUse != null) {
            item.setMnemonic(sToUse.charAt(0));
        }
        if (parentMenu == null) {
            this.getMenuBar().add(item);
            if (antMenuItem.getSubMenuItems().size() != 0) {
                this.addMenu((JMenu)item);
            }
        } else {
            parentMenu.add(item);
        }
        if (antMenuItem.getSubMenuItems().size() == 0) {
            antMenuItem.setComponent(item);
            antMenuItem.register(this.callBack.getActionRegistry());
        } else {
            for (int i = 0; i < antMenuItem.getSubMenuItems().size(); ++i) {
                AntMenuItem childItem = (AntMenuItem)antMenuItem.getSubMenuItems().get(i);
                this.addAntMenuItem(childItem, item);
            }
        }
    }

    public void setStyleSheet(File stylesheet) throws FileNotFoundException, IOException {
        Properties props = new Properties();
        props.load(new FileInputStream(stylesheet));
        StyleUtil.styleComponents("menu", props, this.menuItems);
        this.getPanel().setStyleSheet(stylesheet);
    }

    public void setFalse(String propertyName) {
        this.callBack.setFalse(propertyName);
    }

    public void addMenu(JMenu menu) {
        this.menuItems.add(menu);
    }
}

