/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.api;

import java.util.Objects;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListModel;
import org.gvsig.tools.util.LabeledValue;
import org.gvsig.tools.util.LabeledValueImpl;

public class ListElement<T>
extends LabeledValueImpl<T> {
    public ListElement(String label, T value) {
        super(label, value);
    }

    public static void setSelected(JList list, Object anObject) {
        ListElement.setSelectedValue(list, anObject);
    }

    public static void setSelected(JComboBox combo, Object anObject) {
        ListElement.setSelectedItem(combo, anObject);
    }

    public static Object getSelected(JList list) {
        return ListElement.getSelectedValue(list);
    }

    public static Object getSelected(JComboBox combo) {
        return ListElement.getSelectedItem(combo);
    }

    public static void setSelectedValue(JList list, Object anObject) {
        if (anObject == null) {
            list.setSelectedIndex(-1);
            return;
        }
        ListModel dataModel = list.getModel();
        for (int i = 0; i < dataModel.getSize(); ++i) {
            Object element = dataModel.getElementAt(i);
            if (element instanceof LabeledValue) {
                element = ((LabeledValue)element).getValue();
            }
            if (!anObject.equals(element)) continue;
            list.setSelectedIndex(i);
            return;
        }
        list.setSelectedIndex(-1);
    }

    public static Object getSelectedValue(JList list) {
        Object element = list.getSelectedValue();
        if (element == null) {
            return null;
        }
        if (element instanceof LabeledValue) {
            return ((LabeledValue)element).getValue();
        }
        return element;
    }

    public static void setSelectedItem(JComboBox combo, Object anObject) {
        if (anObject == null) {
            combo.setSelectedIndex(-1);
            return;
        }
        ComboBoxModel dataModel = combo.getModel();
        for (int i = 0; i < dataModel.getSize(); ++i) {
            Object element = dataModel.getElementAt(i);
            if (element instanceof LabeledValue) {
                element = ((LabeledValue)element).getValue();
            }
            if (!Objects.equals(anObject, element)) continue;
            combo.setSelectedIndex(i);
            return;
        }
        combo.setSelectedIndex(-1);
        if (combo.isEditable()) {
            combo.setSelectedItem(anObject);
        }
    }

    public static Object getSelectedItem(JComboBox combo) {
        Object element = combo.getSelectedItem();
        if (element == null) {
            return null;
        }
        if (element instanceof LabeledValue) {
            return ((LabeledValue)element).getValue();
        }
        return element;
    }
}

