/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.dynform.services.dynformfield.Float;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.dynform.DynFormFieldDefinition;
import org.gvsig.tools.dynform.JDynFormField;
import org.gvsig.tools.dynform.spi.DynFormSPIManager;
import org.gvsig.tools.dynform.spi.dynformfield.AbstractJDynFormField;
import org.gvsig.tools.dynform.spi.dynformfield.AbstractJDynFormFieldWithValueList;
import org.gvsig.tools.dynform.spi.dynformfield.JDynFormFieldFactory;
import org.gvsig.tools.dynobject.exception.DynFieldValidateException;

public class JDynFormFieldFloat
extends AbstractJDynFormFieldWithValueList {
    public JDynFormFieldFloat(DynFormSPIManager serviceManager, DynFormSPIManager.ComponentsFactory componentsFactory, JDynFormFieldFactory factory, DynFormFieldDefinition definition, Object value) {
        super(serviceManager, componentsFactory, factory, definition, value);
    }

    public Object getValue() {
        Float value = null;
        String s = this.getValueFromJComponent();
        if (StringUtils.isBlank((CharSequence)s)) {
            value = null;
        } else {
            try {
                value = Float.valueOf(s);
            }
            catch (Exception ex) {
                throw new AbstractJDynFormField.IllegalFieldValue((AbstractJDynFormField)this, (JDynFormField)this, "Is not a valid float.");
            }
        }
        try {
            this.getDefinition().validate((Object)value);
            this.problemIndicator().clear();
        }
        catch (DynFieldValidateException e) {
            throw new AbstractJDynFormField.IllegalFieldValue((AbstractJDynFormField)this, (JDynFormField)this, e.getLocalizedMessage());
        }
        return value;
    }

    public String getJTextFieldRegex() {
        return "[-+]?[0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?$";
    }

    public boolean isModified() {
        String s = this.getValueFromJComponent();
        Float assigned = (Float)this.getAssignedValue();
        if (StringUtils.isBlank((CharSequence)s)) {
            return assigned != null;
        }
        try {
            Float value = Float.valueOf(s);
            return !Objects.equals(value, assigned);
        }
        catch (Exception ex) {
            return false;
        }
    }
}

