/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.dynform.services.dynformfield.URI;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.dynform.DynFormFieldDefinition;
import org.gvsig.tools.dynform.services.dynformfield.File.JDynFormFieldFile;
import org.gvsig.tools.dynform.spi.DynFormSPIManager;
import org.gvsig.tools.dynform.spi.dynformfield.JDynFormFieldFactory;

public class JDynFormFieldURI
extends JDynFormFieldFile {
    protected URI assignedValue = null;
    protected URI currentValue = null;

    public JDynFormFieldURI(DynFormSPIManager serviceManager, DynFormSPIManager.ComponentsFactory componentsFactory, JDynFormFieldFactory factory, DynFormFieldDefinition definition, Object value) {
        super(serviceManager, componentsFactory, factory, definition, value);
        this.assignedValue = (URI)value;
    }

    @Override
    public Object getValue() {
        URI value = null;
        String s = "";
        s = this.jtext.getText();
        if (StringUtils.isBlank((CharSequence)s)) {
            return null;
        }
        try {
            value = new URI(s);
        }
        catch (URISyntaxException e) {
            LOGGER.info("Error. URI Syntax: " + s);
            value = null;
        }
        return value;
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            this.jtext.setText("");
            this.assignedValue = null;
        } else {
            if (!(value instanceof URI)) {
                LOGGER.info("setValue invoked with non URI value (" + value.toString() + ").");
                return;
            }
            this.jtext.setText(((URI)value).toString());
            this.fixPreferredWidth(this.jtext);
            try {
                this.assignedValue = new URI(((URI)value).toString());
            }
            catch (URISyntaxException e) {
                LOGGER.info("Error in URI creation.");
                this.assignedValue = null;
            }
        }
        this.currentValue = this.assignedValue;
    }

    public File[] showOpenFileDialog(String title, File initialPath) {
        return this.showChooserDialog(title, 0, 2, false, initialPath, null, false);
    }

    @Override
    public boolean isModified() {
        String s = this.jtext.getText();
        URI assigned = (URI)this.getAssignedValue();
        if (StringUtils.isBlank((CharSequence)s)) {
            return assigned != null;
        }
        try {
            URI value = new URI(s);
            return !Objects.equals(value, assigned);
        }
        catch (Exception ex) {
            return false;
        }
    }
}

