/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.installer.lib.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.gvsig.installer.lib.api.Dependencies;
import org.gvsig.installer.lib.api.DependenciesCalculator;
import org.gvsig.installer.lib.api.Dependency;
import org.gvsig.installer.lib.api.PackageInfo;
import org.gvsig.installer.lib.api.Version;
import org.gvsig.installer.lib.api.execution.InstallPackageService;
import org.gvsig.installer.lib.impl.DefaultDependencies;
import org.gvsig.installer.lib.impl.DefaultDependenciesCalculator;
import org.gvsig.tools.packageutils.StringWithAlias;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependenciesCalculatorV2
implements DependenciesCalculator {
    private static Logger logger = LoggerFactory.getLogger(DefaultDependenciesCalculator.class);
    private InstallPackageService installService = null;
    private List<PackageInfo> packagesInstalleds = null;
    private List<PackageInfo> packagesToInstall = null;
    private List<PackageInfo> requieredPackages = null;
    private List<PackageInfo> conflictsPackages = null;
    private Dependencies unresolvedDependencies = null;

    public DependenciesCalculatorV2(InstallPackageService installService) {
        this.installService = installService;
        this.packagesInstalleds = new ArrayList<PackageInfo>();
        this.packagesToInstall = new ArrayList<PackageInfo>();
    }

    public void addPackageToInstall(PackageInfo packageInfo) {
        this.packagesToInstall.add(packageInfo);
    }

    public void addPackageToInstall(Collection<PackageInfo> packages) {
        Iterator<PackageInfo> it = packages.iterator();
        while (it.hasNext()) {
            this.addPackageToInstall(it.next());
        }
    }

    public void addInstalledPackage(PackageInfo packageInfo) {
        this.packagesInstalleds.add(packageInfo);
    }

    public void addInstalledPackage(PackageInfo[] packages) {
        for (int i = 0; i < packages.length; ++i) {
            this.addInstalledPackage(packages[i]);
        }
    }

    public List<PackageInfo> getRequiredPackages() {
        return this.requieredPackages;
    }

    public List<PackageInfo> getConflictPackages() {
        return this.conflictsPackages;
    }

    public Dependencies getUnresolvedDependencies() {
        return this.unresolvedDependencies;
    }

    public void calculate() {
        int retryCount = 1;
        boolean retry = true;
        this.conflictsPackages = new ArrayList<PackageInfo>();
        this.requieredPackages = new ArrayList<PackageInfo>();
        this.unresolvedDependencies = new DefaultDependencies();
        if (logger.isInfoEnabled()) {
            logger.info("Installeds packages:\n" + this.dumpPackages(this.packagesInstalleds));
            logger.info("Packages to install:\n" + this.dumpPackages(this.packagesToInstall));
        }
        while (retry) {
            if (retryCount > 50) {
                logger.info("Too many retries to calculate dependencies.");
                throw new RuntimeException("Too many retries to calculate dependencies");
            }
            ArrayList<PackageInfo> packages = new ArrayList<PackageInfo>();
            packages.addAll(this.packagesInstalleds);
            packages.addAll(this.packagesToInstall);
            packages.addAll(this.requieredPackages);
            DefaultDependencies dependencies = new DefaultDependencies();
            for (PackageInfo packageInfo : packages) {
                Dependencies pkgDependencies = packageInfo.getDependencies();
                for (int i = 0; i < pkgDependencies.size(); ++i) {
                    Dependency dependency = (Dependency)pkgDependencies.get(i);
                    List x = dependencies.findAll(dependency.getType(), dependency.getCode(), dependency.getVersion());
                    if (x == null) {
                        dependencies.add(new DependencyAndPackages(dependency, packageInfo));
                        continue;
                    }
                    if (x.size() == 1) {
                        ((DependencyAndPackages)x.get(0)).addPackage(packageInfo);
                        continue;
                    }
                    Collections.sort(x, new Comparator<Dependency>(){

                        @Override
                        public int compare(Dependency arg0, Dependency arg1) {
                            return -arg0.getVersion().compareTo((Object)arg1.getVersion());
                        }
                    });
                    ((DependencyAndPackages)x.get(0)).addPackage(packageInfo);
                }
            }
            retry = this.calculateRequiredPackagesAndUnresolvedDependencies(dependencies);
            if (retry) {
                ++retryCount;
                continue;
            }
            this.calculateConflictPackages(dependencies);
        }
        if (this.requieredPackages != null && !this.requieredPackages.isEmpty()) {
            Collections.sort(this.requieredPackages, new Comparator<PackageInfo>(){

                @Override
                public int compare(PackageInfo o1, PackageInfo o2) {
                    return o1.getCode().compareTo(o2.getCode());
                }
            });
        }
        if (this.conflictsPackages != null && !this.conflictsPackages.isEmpty()) {
            Collections.sort(this.conflictsPackages, new Comparator<PackageInfo>(){

                @Override
                public int compare(PackageInfo o1, PackageInfo o2) {
                    return o1.getCode().compareTo(o2.getCode());
                }
            });
        }
        if (this.unresolvedDependencies != null && !this.unresolvedDependencies.isEmpty()) {
            Collections.sort(this.unresolvedDependencies, new Comparator<Dependency>(){

                @Override
                public int compare(Dependency o1, Dependency o2) {
                    return o1.getCode().compareTo(o2.getCode());
                }
            });
        }
        if (logger.isInfoEnabled()) {
            logger.info("Required packages:\n" + this.dumpPackages(this.requieredPackages));
            logger.info("Unresolved dependencies:\n" + this.dumpDependencies((Collection<Dependency>)this.unresolvedDependencies));
            logger.info("Conflict packages:\n" + this.dumpPackages(this.conflictsPackages));
            logger.info("Attempts Requireds: " + retryCount);
        }
    }

    private boolean calculateRequiredPackagesAndUnresolvedDependencies(Dependencies dependencies) {
        boolean retry = false;
        for (int i = 0; i < dependencies.size(); ++i) {
            PackageInfo availablePackage;
            DependencyAndPackages dependency = (DependencyAndPackages)dependencies.get(i);
            if (!"required".equals(dependency.getType()) || (availablePackage = this.getInstalledOrToInstallOrRequiredsPackage(dependency)) != null) continue;
            availablePackage = this.getAvalible(dependency);
            if (availablePackage != null) {
                logger.info("Added new package " + availablePackage.getCode() + " required by dependency " + dependency.toString() + ".");
                this.requieredPackages.add(availablePackage);
                retry = true;
                continue;
            }
            this.unresolvedDependencies.add((Object)dependency);
        }
        return retry;
    }

    private void calculateConflictPackages(Dependencies dependencies) {
        for (int i = 0; i < dependencies.size(); ++i) {
            PackageInfo pkg;
            DependencyAndPackages dependency = (DependencyAndPackages)dependencies.get(i);
            if (!"conflict".equals(dependency.getType()) || (pkg = this.getInstalledOrToInstallOrRequiredsPackage(dependency)) == null) continue;
            this.conflictsPackages.addAll(dependency.getPackages());
        }
    }

    private PackageInfo getInstalledOrToInstallOrRequiredsPackage(DependencyAndPackages dependency) {
        for (PackageInfo pkg : this.packagesInstalleds) {
            if (!dependency.match(dependency.getType(), pkg.getAllCodes(), pkg.getVersion())) continue;
            return pkg;
        }
        for (PackageInfo pkg : this.packagesToInstall) {
            if (!dependency.match(dependency.getType(), pkg.getAllCodes(), pkg.getVersion())) continue;
            return pkg;
        }
        for (PackageInfo pkg : this.requieredPackages) {
            if (!dependency.match(dependency.getType(), pkg.getAllCodes(), pkg.getVersion())) continue;
            return pkg;
        }
        return null;
    }

    private PackageInfo getAvalible(DependencyAndPackages dependency) {
        for (int i = 0; i < this.installService.getPackageCount(); ++i) {
            PackageInfo pkg = this.installService.getPackageInfo(i);
            if (!dependency.match(dependency.getType(), pkg.getAllCodes(), pkg.getVersion())) continue;
            return pkg;
        }
        return null;
    }

    private String dumpPackages(Collection<PackageInfo> pkgs) {
        StringBuffer s = new StringBuffer();
        Iterator<PackageInfo> it = pkgs.iterator();
        while (it.hasNext()) {
            s.append(it.next().toStringCompact());
            s.append("\n");
        }
        return s.toString();
    }

    private String dumpDependencies(Collection<Dependency> dependencies) {
        StringBuffer s = new StringBuffer();
        Iterator<Dependency> it = dependencies.iterator();
        while (it.hasNext()) {
            s.append(it.next().toString());
            s.append("\n");
        }
        return s.toString();
    }

    private class DependencyAndPackages
    implements Dependency {
        private List<PackageInfo> packages = null;
        private Dependency delegate = null;

        DependencyAndPackages(Dependency dependency, PackageInfo packageInfo) {
            this.delegate = dependency;
            this.packages = new ArrayList<PackageInfo>();
            this.packages.add(packageInfo);
        }

        public List<PackageInfo> getPackages() {
            return this.packages;
        }

        public void addPackage(PackageInfo packageInfo) {
            if (this.packages.contains(packageInfo)) {
                return;
            }
            this.packages.add(packageInfo);
        }

        public Dependency parse(String dependency) {
            return this.delegate.parse(dependency);
        }

        public String getType() {
            return this.delegate.getType();
        }

        public String getCode() {
            return this.delegate.getCode();
        }

        public String getOp() {
            return this.delegate.getOp();
        }

        public Version getVersion() {
            return this.delegate.getVersion();
        }

        public boolean match(String type, String code, Version version) {
            return this.delegate.match(type, code, version);
        }

        public boolean match(String type, StringWithAlias code, Version version) {
            return this.delegate.match(type, code, version);
        }

        public Object clone() throws CloneNotSupportedException {
            DependencyAndPackages x = (DependencyAndPackages)super.clone();
            x.packages = new ArrayList<PackageInfo>();
            for (PackageInfo packageInfo : this.packages) {
                x.packages.add(packageInfo);
            }
            return x;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.delegate.toString());
            buffer.append(" ( ");
            for (PackageInfo packageInfo : this.packages) {
                buffer.append(packageInfo.getCode());
                buffer.append(" ");
            }
            buffer.append(" )");
            return buffer.toString();
        }
    }
}

