/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.imageviewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;
import org.gvsig.imageviewer.ImageViewer;
import org.gvsig.tools.swing.api.ChangeListenerHelper;
import org.gvsig.tools.swing.api.SimpleImage;
import org.gvsig.tools.swing.api.ToolsSwingLocator;

public class DefaultImageViewer
extends JPanel
implements ImageViewer {
    private JLabel label;
    private final ChangeListenerHelper changeListener = ToolsSwingLocator.getToolsSwingManager().createChangeListenerHelper();
    private SimpleImage currentImage = null;

    public DefaultImageViewer() {
        this.initComponents();
    }

    private void initComponents() {
        this.label = new JLabel();
        this.setLayout(new BorderLayout());
        this.add((Component)this.label, "Center");
        this.setPreferredSize(new Dimension(200, 350));
    }

    private void setImage(ImageIcon image) {
        this.label.setIcon(image);
        this.setPreferredSize(new Dimension(image.getIconWidth(), image.getIconHeight()));
        this.changeListener.fireEvent();
    }

    public void setImage(Object source) {
        if (source == null) {
            this.clean();
            return;
        }
        if (source instanceof SimpleImage) {
            this.setImage((SimpleImage)source);
            return;
        }
        SimpleImage img = ToolsSwingLocator.getToolsSwingManager().createSimpleImage(source);
        this.setImage(img);
    }

    private void setImage(SimpleImage image) {
        if (image == null) {
            this.clean();
            return;
        }
        this.currentImage = image;
        BufferedImage bufferedImage = this.currentImage.getBufferedImage();
        if (bufferedImage == null) {
            this.clean();
        } else {
            ImageIcon img = new ImageIcon(bufferedImage);
            this.setImage(img);
            this.changeListener.fireEvent();
        }
    }

    public JComponent asJComponent() {
        return this;
    }

    public void clean() {
        this.currentImage = null;
        this.label.setIcon(null);
        this.changeListener.fireEvent();
    }

    public void addAction(Action action) {
    }

    public SimpleImage getImage() {
        return this.currentImage;
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeListener.addChangeListener(listener);
    }

    public ChangeListener[] getChangeListeners() {
        return this.changeListener.getChangeListeners();
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeListener.removeChangeListener(listener);
    }

    public void removeAllChangeListener() {
        this.changeListener.removeAllChangeListener();
    }

    public boolean hasChangeListeners() {
        return this.hasChangeListeners();
    }
}

