/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.dynobject.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.AbstractDynMethod;
import org.gvsig.tools.dynobject.DynClass;
import org.gvsig.tools.dynobject.DynClassName;
import org.gvsig.tools.dynobject.DynClass_v2;
import org.gvsig.tools.dynobject.DynField;
import org.gvsig.tools.dynobject.DynField_LabelAttribute;
import org.gvsig.tools.dynobject.DynField_v2;
import org.gvsig.tools.dynobject.DynMethod;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.DynObjectEncoder;
import org.gvsig.tools.dynobject.DynObjectManager;
import org.gvsig.tools.dynobject.DynObjectPagingHelper;
import org.gvsig.tools.dynobject.DynObjectRuntimeException;
import org.gvsig.tools.dynobject.DynObjectSet;
import org.gvsig.tools.dynobject.DynObjectValueItem;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.dynobject.DynStruct_v2;
import org.gvsig.tools.dynobject.exception.DuplicateDynClassException;
import org.gvsig.tools.dynobject.exception.DynFieldNotFoundException;
import org.gvsig.tools.dynobject.exception.DynMethodException;
import org.gvsig.tools.dynobject.exception.DynMethodIllegalCodeException;
import org.gvsig.tools.dynobject.exception.DynMethodNotSupportedException;
import org.gvsig.tools.dynobject.exception.IllegalDynMethodException;
import org.gvsig.tools.dynobject.exception.IllegalDynMethodInvocationException;
import org.gvsig.tools.dynobject.impl.DefaultDynClass;
import org.gvsig.tools.dynobject.impl.DefaultDynClassName;
import org.gvsig.tools.dynobject.impl.DefaultDynField;
import org.gvsig.tools.dynobject.impl.DefaultDynObject;
import org.gvsig.tools.dynobject.impl.DefaultDynObjectPagingHelper;
import org.gvsig.tools.dynobject.impl.DynClassExportHelper;
import org.gvsig.tools.dynobject.impl.DynClassImportHelper;
import org.gvsig.tools.dynobject.impl.SimpleDynObjectEncoder;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.util.UnmodifiableBasicMap;
import org.gvsig.tools.util.UnmodifiableBasicMapAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class DefaultDynObjectManager
implements DynObjectManager {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultDynObjectManager.class);
    private static DefaultDynObjectManager manager = null;
    private Map anonymousClasses;
    private ClassesNamespaces classes = new ClassesNamespaces();
    private Map methodsMap;
    private List<MethodInfo> methods = null;
    private Map<String, DynField> tags;

    public static DefaultDynObjectManager getManager() {
        if (manager == null) {
            manager = new DefaultDynObjectManager();
        }
        return manager;
    }

    static String getKey(Class theClass, DynClass dynClass, DynMethod dynMethod) {
        return DefaultDynObjectManager.getKey(theClass, dynClass, dynMethod.getName());
    }

    static String getKey(Class theClass, DynClass dynClass, String methodName) {
        if (dynClass == null) {
            if (theClass == null) {
                return "__anonymous__:" + methodName;
            }
            return theClass.getName() + ":" + methodName;
        }
        return dynClass.getName() + ":" + methodName;
    }

    public DefaultDynObjectManager() {
        this.anonymousClasses = new HashMap();
        this.methodsMap = new HashMap();
    }

    @Override
    public DynClass_v2 createDynClass(String name, String description) {
        return new DefaultDynClass((DynObjectManager)this, name, description);
    }

    @Override
    public DynClass_v2 createDynClass(String namespace, String name, String description) {
        return new DefaultDynClass((DynObjectManager)this, namespace, name, description);
    }

    @Override
    public void add(DynClass dynClass) {
        try {
            ((DefaultDynClass)dynClass).check();
        }
        catch (Exception ex) {
            throw new DynObjectRuntimeException((Throwable)ex);
        }
        this.classes.add(dynClass);
        LOG.trace("Add DynClass definition {}.", new Object[]{dynClass.getFullName()});
    }

    @Override
    public DynClass add(String name, String description) {
        DynClass dynClass = this.classes.get(name.toLowerCase(), null);
        if (dynClass == null) {
            dynClass = this.createDynClass(name, description);
            this.add(dynClass);
        }
        return dynClass;
    }

    @Override
    public DynClass add(String name) {
        return this.add(name, null);
    }

    @Override
    public void remove(DynStruct dynClass) {
        this.classes.remove(dynClass);
    }

    @Override
    public DynClass get(String theName) {
        DynClassName name = this.createDynClassName(theName);
        return this.get(name.getNamespace(), name.getName());
    }

    @Override
    public DynClass get(String namespace, String name) {
        return this.classes.get(name, namespace);
    }

    public DynClass get(DynClass[] superClasses) {
        StringBuffer name = new StringBuffer();
        for (int i = 0; i < superClasses.length; ++i) {
            name.append(superClasses[i].getName()).append("+");
        }
        DefaultDynClass dynClass = (DefaultDynClass)this.anonymousClasses.get(name.toString());
        if (dynClass == null) {
            dynClass = new DefaultDynClass((DynObjectManager)this, name.toString(), null, superClasses);
            dynClass.setAnonymous(true);
        }
        return dynClass;
    }

    @Override
    public int getCount() {
        return this.classes.size();
    }

    @Override
    public List getNames() {
        Object[] names = (String[])this.classes.keySet().toArray();
        Arrays.sort(names);
        return Collections.unmodifiableList(Arrays.asList(names));
    }

    @Override
    public boolean has(String name) {
        return this.classes.containsClass(name);
    }

    @Override
    public boolean has(String namespace, String name) {
        return this.classes.containsClass(namespace, name);
    }

    @Override
    public Iterator iterator() {
        return this.classes.iterator();
    }

    @Override
    public DynObject createDynObject(String dynClassName) {
        DynClassName name = this.createDynClassName(dynClassName);
        return this.createDynObject(name.getName(), name.getNamespace());
    }

    @Override
    public DynObject createDynObject(String dynClassName, String namespace) {
        DynClass dynClass = this.classes.get(dynClassName, namespace);
        if (dynClass == null) {
            throw new IllegalArgumentException("Can't locate class '" + this.createDynClassName(namespace, dynClassName).getFullName() + "'.");
        }
        return this.createDynObject(dynClass);
    }

    @Override
    public DynObject createDynObject(DynStruct dynClass) {
        return new DefaultDynObject(dynClass);
    }

    @Override
    public void consolide() {
        Iterator it = this.classes.iterator();
        while (it.hasNext()) {
            DefaultDynClass dc = (DefaultDynClass)it.next();
            dc.consolide();
        }
        for (DefaultDynClass dc : this.anonymousClasses.values()) {
            dc.consolide();
        }
    }

    @Override
    public int registerDynMethod(DynClass dynClass, DynMethod dynMethod) {
        ((DefaultDynClass)dynClass).addMethod(dynMethod);
        return this.registerDynMethod(null, dynClass, dynMethod);
    }

    @Override
    public int registerDynMethod(Class theClass, DynMethod dynMethod) {
        return this.registerDynMethod(theClass, null, dynMethod);
    }

    @Override
    public int registerDynMethod(DynMethod dynMethod) {
        return this.registerDynMethod(null, null, dynMethod);
    }

    int registerDynMethod(Class theClass, DynClass dynClass, DynMethod dynMethod) {
        MethodInfo info = new MethodInfo(theClass, dynClass, dynMethod, 0);
        MethodInfo oldInfo = (MethodInfo)this.methodsMap.get(info.getKey());
        if (oldInfo != null) {
            oldInfo.dynClass = dynClass;
            oldInfo.dynMethod = dynMethod;
            return oldInfo.code;
        }
        if (this.methods == null) {
            this.methods = new ArrayList<MethodInfo>();
        }
        info.code = this.methods.size();
        this.methods.add(info);
        this.methodsMap.put(info.getKey(), info);
        try {
            if (dynMethod instanceof AbstractDynMethod && dynMethod.getCode() < 0) {
                ((AbstractDynMethod)dynMethod).setCode(info.code);
            }
        }
        catch (DynMethodNotSupportedException dynMethodNotSupportedException) {
            // empty catch block
        }
        return info.code;
    }

    @Override
    public Object invokeDynMethod(Object self, int code, DynObject context) throws DynMethodException {
        try {
            return this.methods.get((int)code).dynMethod.invoke((DynObject)self, new Object[]{context});
        }
        catch (RuntimeException e) {
            this.getDynMethod(self, code);
            throw e;
        }
        catch (DynMethodException e) {
            this.getDynMethod(self, code);
            throw e;
        }
    }

    public int getDynMethodCode(DynClass dynClass, String methodName) throws DynMethodException {
        String key = DefaultDynObjectManager.getKey(null, dynClass, methodName);
        MethodInfo info = (MethodInfo)this.methodsMap.get(key);
        if (info == null) {
            throw new IllegalDynMethodException(methodName, dynClass);
        }
        info.check(dynClass, info.code);
        return info.code;
    }

    public int getDynMethodCode(Class theClass, String methodName) throws DynMethodException {
        String key = DefaultDynObjectManager.getKey(theClass, null, methodName);
        MethodInfo info = (MethodInfo)this.methodsMap.get(key);
        if (info == null) {
            throw new IllegalDynMethodException(methodName, theClass);
        }
        info.check(theClass, info.code);
        return info.code;
    }

    @Override
    public DynMethod getDynMethod(int code) throws DynMethodException {
        if (code >= this.methods.size()) {
            throw new DynMethodNotSupportedException(code, "{null}");
        }
        MethodInfo info = this.methods.get(code);
        info.check((Class)null, code);
        return info.dynMethod;
    }

    @Override
    public DynMethod getDynMethod(String methodName) throws DynMethodException {
        String key = DefaultDynObjectManager.getKey(null, null, methodName);
        MethodInfo info = (MethodInfo)this.methodsMap.get(key);
        if (info == null) {
            throw new IllegalDynMethodException(methodName);
        }
        return info.dynMethod;
    }

    @Override
    public DynMethod getDynMethod(Object obj, int code) throws DynMethodException {
        return this.getDynMethod(obj.getClass(), code);
    }

    @Override
    public DynMethod getDynMethod(Class theClass, int code) throws DynMethodException {
        if (code >= this.methods.size()) {
            throw new DynMethodNotSupportedException(code, theClass.getName());
        }
        MethodInfo info = this.methods.get(code);
        info.check(theClass, code);
        return info.dynMethod;
    }

    @Override
    public DynMethod getDynMethod(DynClass dynClass, int code) throws DynMethodException {
        if (code >= this.methods.size()) {
            throw new DynMethodNotSupportedException(code, dynClass.getName());
        }
        MethodInfo info = this.methods.get(code);
        info.check(dynClass, code);
        return info.dynMethod;
    }

    @Override
    public DynMethod getDynMethod(DynObject dynObject, int code) throws DynMethodException {
        return this.getDynMethod(dynObject.getDynClass(), code);
    }

    @Override
    public void validate(DynObject object) {
    }

    @Override
    public Class getDefaultClassOfType(int type) {
        return ToolsLocator.getDataTypesManager().getDefaultClass(type);
    }

    @Override
    public String exportSimpleDynClassDefinitions(DynClass dynClass) {
        DynClassExportHelper exporter = new DynClassExportHelper();
        return exporter.exportSimpleDefinition(dynClass);
    }

    @Override
    public void exportSimpleDynClassDefinitions(File out, DynClass dynClass) throws FileNotFoundException {
        DynClassExportHelper exporter = new DynClassExportHelper();
        exporter.exportSimpleDefinition(out, dynClass);
    }

    @Override
    public void exportSimpleDynClassDefinitions(OutputStream out, DynClass dynClass) {
        DynClassExportHelper exporter = new DynClassExportHelper();
        exporter.exportSimpleDefinition(out, dynClass);
    }

    @Override
    public Map importDynClassDefinitions(InputStream resource, ClassLoader loader) throws XmlPullParserException, IOException {
        return new DynClassImportHelper().importDefinitions(resource, loader, null);
    }

    @Override
    public Map importDynClassDefinitions(XmlPullParser parser, ClassLoader loader, String defaultNamespace) throws XmlPullParserException, IOException {
        return new DynClassImportHelper().importDefinitions(parser, loader, defaultNamespace);
    }

    @Override
    public Map importDynClassDefinitions(InputStream resource, ClassLoader loader, String defaultNamespace) throws XmlPullParserException, IOException {
        return new DynClassImportHelper().importDefinitions(resource, loader, defaultNamespace);
    }

    @Override
    public DynObjectPagingHelper createDynObjectPagingHelper(DynObjectSet set) throws BaseException {
        return new DefaultDynObjectPagingHelper(set);
    }

    @Override
    public DynObjectPagingHelper createDynObjectPagingHelper(DynObjectSet set, int pageSize) throws BaseException {
        return new DefaultDynObjectPagingHelper(set, pageSize);
    }

    @Override
    public DynClassName createDynClassName(String namespace, String name) {
        return new DefaultDynClassName(namespace, name);
    }

    @Override
    public DynClassName createDynClassName(String name) {
        return new DefaultDynClassName(name);
    }

    @Override
    public Iterator iterator(String nameSpace) {
        return this.iterator(nameSpace, false);
    }

    private Iterator iterator(String nameSpace, boolean exactMatchingRequired) {
        ArrayList<DynStruct> list = new ArrayList<DynStruct>();
        Iterator it = this.classes.iterator();
        if (nameSpace == null) {
            nameSpace = "";
        }
        while (it.hasNext()) {
            Object obj = it.next();
            DynStruct dynStruct = (DynStruct)obj;
            String dynNameSpace = dynStruct.getNamespace();
            dynNameSpace = dynNameSpace == null || dynNameSpace.equals("") ? null : dynNameSpace.toLowerCase();
            nameSpace = nameSpace.toLowerCase();
            if (exactMatchingRequired) {
                if (!nameSpace.equalsIgnoreCase(dynNameSpace)) continue;
                list.add(dynStruct);
                continue;
            }
            if (dynNameSpace == null || nameSpace.indexOf(dynNameSpace) <= -1) continue;
            list.add(dynStruct);
        }
        return list.iterator();
    }

    @Override
    public Object getAttributeValue(Object obj, String name) {
        if ("label".equalsIgnoreCase(name)) {
            if (obj instanceof DynField_LabelAttribute) {
                return ((DynField_LabelAttribute)obj).getLabel();
            }
        } else if ("StructWhenTypeIsDynObject".equalsIgnoreCase(name) && obj instanceof DynField_v2) {
            return ((DynField_v2)obj).getDynClassOfValue();
        }
        return null;
    }

    @Override
    public void setAttributeValue(Object obj, String name, Object value) {
        if ("label".equalsIgnoreCase(name)) {
            if (obj instanceof DynField_LabelAttribute) {
                ((DynField_LabelAttribute)obj).setLabel((String)value);
            }
        } else if ("StructWhenTypeIsDynObject".equalsIgnoreCase(name) && obj instanceof DynField_v2) {
            ((DynField_v2)obj).setClassOfValue((DynStruct)value);
        }
    }

    @Override
    public DynObjectEncoder createSimpleDynObjectEncoder() {
        return new SimpleDynObjectEncoder();
    }

    @Override
    public void copy(DynObject source, DynObject target) {
        for (DynField field : target.getDynClass().getDynFields()) {
            String name = field.getName();
            try {
                Object value = source.getDynValue(name);
                target.setDynValue(name, value);
            }
            catch (DynFieldNotFoundException | DefaultDynObject.CoerceValueException dynObjectRuntimeException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean equals(DynObject obj1, DynObject obj2) {
        if (!StringUtils.equalsIgnoreCase((CharSequence)obj1.getDynClass().getFullName(), (CharSequence)obj2.getDynClass().getFullName())) {
            return false;
        }
        for (DynField field : obj1.getDynClass().getDynFields()) {
            String name = field.getName();
            if (Objects.equals(obj1.getDynValue(name), obj2.getDynValue(name))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode(DynObject obj) {
        DynField[] fields = obj.getDynClass().getDynFields();
        Object[] values = new Object[fields.length];
        int n = 0;
        for (DynField field : fields) {
            String name = field.getName();
            values[n++] = obj.getDynValue(name);
        }
        return Arrays.hashCode(values);
    }

    @Override
    public void clear(DynObject obj) {
        for (DynField field : obj.getDynClass().getDynFields()) {
            String name = field.getName();
            try {
                Object value = field.getDefaultValue();
                obj.setDynValue(name, value);
            }
            catch (DefaultDynObject.CoerceValueException coerceValueException) {
                // empty catch block
            }
        }
    }

    @Override
    public DynField_v2 createDynField(String name) {
        return new DefaultDynField(name, 8);
    }

    @Override
    public DynClass_v2 createCopy(DynClass source) {
        DynClass_v2 target = this.createDynClass(source.getNamespace(), source.getName(), source.getDescription());
        if (source instanceof DynStruct_v2) {
            DynField[] source2 = (DynField[])source;
            target.setLabel(source2.getLabel());
            target.getTags().add(source2.getTags());
        }
        for (DynField sourceField : source.getDynFields()) {
            DynField_v2 targetField = (DynField_v2)target.addDynField(sourceField.getName());
            targetField.copyFrom(sourceField);
        }
        try {
            DynMethod[] x = source.getDynMethods();
            if (x != null) {
                for (DynMethod sourceMethod : x) {
                    target.addDynMethod(sourceMethod);
                }
            }
        }
        catch (DynMethodException dynMethodException) {
            // empty catch block
        }
        return target;
    }

    @Override
    public UnmodifiableBasicMap<String, DynField> getTags() {
        if (this.tags == null) {
            this.tags = new HashMap<String, DynField>();
        }
        return new UnmodifiableBasicMapAdapter<String, DynField>(this.tags);
    }

    @Override
    public DynField registerTag(String name, String description) {
        return this.registerTag(name, description, (String[])null);
    }

    @Override
    public DynField registerTag(String name, String description, String[] values) {
        if (this.tags == null) {
            this.tags = new HashMap<String, DynField>();
        }
        DefaultDynField definition = new DefaultDynField(name, 8);
        definition.setDescription(description);
        if (values != null) {
            DynObjectValueItem[] x = new DynObjectValueItem[values.length];
            for (int i = 0; i < values.length; ++i) {
                x[i] = new DynObjectValueItem(values[i], values[i]);
            }
            definition.setAvailableValues(x);
        }
        this.tags.put(name, definition);
        return definition;
    }

    @Override
    public DynField registerTag(String name, String description, DynMethod valuesMethod) {
        if (this.tags == null) {
            this.tags = new HashMap<String, DynField>();
        }
        DefaultDynField definition = new DefaultDynField(name, 8);
        definition.setDescription(description);
        definition.setAvailableValues(valuesMethod);
        this.tags.put(name, definition);
        return definition;
    }

    private class ClassesNamespaces {
        private Map defaultNamespace;
        private Map namespaces = new HashMap();

        ClassesNamespaces() {
            this.defaultNamespace = new HashMap();
        }

        public Map addNamespace(String name) {
            HashMap namespace = new HashMap();
            this.namespaces.put(name.toLowerCase(), namespace);
            return namespace;
        }

        public Map getNamespace(String name) {
            return (Map)this.namespaces.get(name.toLowerCase());
        }

        public boolean containsClass(String name) {
            if (this.defaultNamespace.containsKey(name = name.toLowerCase())) {
                return true;
            }
            for (Map names : this.namespaces.values()) {
                if (!names.containsKey(name)) continue;
                return true;
            }
            return false;
        }

        public boolean containsClass(String namespace, String name) {
            name = name.toLowerCase();
            if (namespace == null) {
                return this.defaultNamespace.containsKey(name);
            }
            Map space = this.getNamespace(namespace);
            if (space == null) {
                return false;
            }
            return space.containsKey(name);
        }

        public DynClass get(String name, String namespace) {
            if (namespace == null) {
                return (DynClass)this.defaultNamespace.get(name.toLowerCase());
            }
            Map space = this.getNamespace(namespace);
            if (space == null) {
                return null;
            }
            DefaultDynClassName className = new DefaultDynClassName(name);
            if (className.getNamespace() == null) {
                return (DynClass)space.get(name.toLowerCase());
            }
            if (!namespace.equalsIgnoreCase(className.getNamespace())) {
                return null;
            }
            return (DynClass)space.get(className.getName().toLowerCase());
        }

        public Set keySet() {
            HashSet<String> keyset = new HashSet<String>();
            Iterator it = this.iterator();
            while (it.hasNext()) {
                DynClass dynClass = (DynClass)it.next();
                keyset.add(dynClass.getFullName());
            }
            return keyset;
        }

        public Iterator iterator() {
            final class MyIterator
            implements Iterator {
                Iterator current;
                Iterator others;

                MyIterator(Iterator main, Iterator others) {
                    this.current = main;
                    this.others = others;
                }

                @Override
                public boolean hasNext() {
                    if (this.current.hasNext()) {
                        return true;
                    }
                    while (this.others.hasNext()) {
                        Object obj = this.others.next();
                        this.current = ((HashMap)obj).values().iterator();
                        if (!this.current.hasNext()) continue;
                        return true;
                    }
                    return false;
                }

                public Object next() {
                    if (this.current.hasNext()) {
                        return this.current.next();
                    }
                    while (this.others.hasNext()) {
                        Object obj = this.others.next();
                        this.current = ((HashMap)obj).values().iterator();
                        if (!this.current.hasNext()) continue;
                        return this.current.next();
                    }
                    return null;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            }
            return new MyIterator(this.defaultNamespace.values().iterator(), this.namespaces.values().iterator());
        }

        public Object add(DynStruct dynClass) {
            Map namespace;
            String name = dynClass.getName().toLowerCase();
            if (dynClass.getNamespace() != null) {
                namespace = this.getNamespace(dynClass.getNamespace());
                if (namespace == null) {
                    namespace = this.addNamespace(dynClass.getNamespace());
                }
            } else {
                namespace = this.defaultNamespace;
            }
            if (namespace.containsKey(name)) {
                throw new DuplicateDynClassException(dynClass);
            }
            return namespace.put(name, dynClass);
        }

        public void remove(DynStruct dynClass) {
            Map namespace;
            String name = dynClass.getName().toLowerCase();
            if (dynClass.getNamespace() != null) {
                namespace = this.getNamespace(dynClass.getNamespace());
                if (namespace == null) {
                    namespace = this.addNamespace(dynClass.getNamespace());
                }
            } else {
                namespace = this.defaultNamespace;
            }
            if (namespace.containsKey(name)) {
                namespace.remove(name);
            }
        }

        public int size() {
            int count = this.defaultNamespace.size();
            for (Map names : this.namespaces.values()) {
                count += names.size();
            }
            return count;
        }
    }

    private class MethodInfo {
        int code;
        DynClass dynClass;
        DynMethod dynMethod;
        Class theClass;

        MethodInfo(Class theClass, DynClass dynClass, DynMethod dynMethod, int code) {
            this.code = code;
            this.dynClass = dynClass;
            this.dynMethod = dynMethod;
            this.theClass = theClass;
        }

        String getKey() {
            return DefaultDynObjectManager.getKey(this.theClass, this.dynClass, this.dynMethod);
        }

        void check(Class theClass, int code) throws DynMethodException {
            if (code != this.code) {
                throw new DynMethodIllegalCodeException(this.dynMethod.getName(), this.code, code);
            }
            if (theClass != null) {
                if (this.theClass == null) {
                    throw new IllegalDynMethodInvocationException(this.dynMethod.getName(), theClass);
                }
                if (!this.theClass.isAssignableFrom(theClass)) {
                    throw new IllegalDynMethodInvocationException(this.dynMethod.getName(), theClass);
                }
            }
        }

        void check(DynClass dynClass, int code) throws DynMethodException {
            if (code != this.code) {
                throw new DynMethodIllegalCodeException(this.dynMethod.getName(), this.code, code);
            }
            if (dynClass != null) {
                if (this.dynClass == null) {
                    throw new IllegalDynMethodInvocationException(this.dynMethod.getName(), dynClass);
                }
                if (dynClass != this.dynClass || !dynClass.getName().equalsIgnoreCase(this.dynClass.getName())) {
                    throw new IllegalDynMethodInvocationException(this.dynMethod.getName(), dynClass);
                }
            }
        }
    }
}

