/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.dynobject.impl;

import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.DynObjectSet;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.visitor.Visitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiDynObjectSet
implements DynObjectSet {
    private static final Logger LOG = LoggerFactory.getLogger(MultiDynObjectSet.class);
    private final DynObjectSet[] innerSets;

    public MultiDynObjectSet(DynObjectSet[] innerSets) {
        this.innerSets = innerSets == null ? new DynObjectSet[]{} : innerSets;
    }

    @Override
    public void dispose() {
        for (int i = 0; i < this.innerSets.length; ++i) {
            this.innerSets[i].dispose();
        }
    }

    @Override
    public void accept(Visitor visitor, long firstValueIndex) throws BaseException {
        int currentSet = 0;
        long currentIndex = 0L;
        while (currentIndex + this.innerSets[currentSet].getSize() <= firstValueIndex) {
            currentIndex += this.innerSets[currentSet].getSize();
            ++currentSet;
        }
        long firstIndexFromCurrentSet = firstValueIndex - currentIndex;
        this.innerSets[currentSet].accept(visitor, firstIndexFromCurrentSet);
        for (int i = currentSet; i < this.innerSets.length; ++i) {
            this.innerSets[i].accept(visitor);
        }
    }

    @Override
    public void accept(Visitor visitor) throws BaseException {
        this.accept(visitor, 0L);
    }

    @Override
    public long getSize() throws BaseException {
        long size = 0L;
        for (int i = 0; i < this.innerSets.length; ++i) {
            size += this.innerSets[i].getSize();
        }
        return size;
    }

    @Override
    public DisposableIterator iterator(long index) throws BaseException {
        return new MultiDynObjectSetDisposableIterator(this.innerSets);
    }

    @Override
    public DisposableIterator iterator() throws BaseException {
        return this.iterator(0L);
    }

    @Override
    public boolean isEmpty() throws BaseException {
        for (int i = 0; i < this.innerSets.length; ++i) {
            if (this.innerSets[i].isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void addObserver(Observer o) {
        throw new UnsupportedOperationException("This DynObjectSet implementation does not support edition, so it doesn't provide notifications");
    }

    @Override
    public void deleteObserver(Observer o) {
        throw new UnsupportedOperationException("This DynObjectSet implementation does not support edition, so it doesn't provide notifications");
    }

    @Override
    public void deleteObservers() {
        throw new UnsupportedOperationException("This DynObjectSet implementation does not support edition, so it doesn't provide notifications");
    }

    @Override
    public boolean isDeleteEnabled() {
        return false;
    }

    @Override
    public void delete(DynObject dynObject) throws BaseException {
        throw new UnsupportedOperationException("This DynObjectSet implementation does not support DynObject deletion");
    }

    @Override
    public boolean isUpdateEnabled() {
        return false;
    }

    @Override
    public void update(DynObject dynObject) throws BaseException {
        throw new UnsupportedOperationException("This DynObjectSet implementation does not support DynObject update");
    }

    public static class MultiDynObjectSetDisposableIterator
    implements DisposableIterator {
        private DisposableIterator currentIterator = null;
        private int currentSet = 0;
        private final DynObjectSet[] innerSets;

        public MultiDynObjectSetDisposableIterator(DynObjectSet[] innerSets) throws BaseException {
            this.innerSets = innerSets;
            if (this.currentIterator == null && this.currentSet < innerSets.length) {
                this.currentIterator = innerSets[this.currentSet].iterator();
            }
        }

        @Override
        public void dispose() {
            if (this.currentIterator != null) {
                this.currentIterator.dispose();
            }
        }

        private DisposableIterator getCurrentIterator() {
            while (!this.currentIterator.hasNext() && this.currentSet < this.innerSets.length - 1) {
                ++this.currentSet;
                try {
                    this.currentIterator = this.innerSets[this.currentSet].iterator();
                }
                catch (BaseException e) {
                    LOG.error("Could no get the iterator of the internal DynObjectSet num. " + this.currentSet + ": " + this.innerSets[this.currentSet], (Throwable)e);
                }
            }
            return this.currentIterator;
        }

        @Override
        public boolean hasNext() {
            DisposableIterator currentIterator = this.getCurrentIterator();
            return currentIterator == null ? false : currentIterator.hasNext();
        }

        @Override
        public Object next() {
            DisposableIterator currentIterator = this.getCurrentIterator();
            return currentIterator == null ? null : currentIterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Unable to remove on composed DynObjectSet iterator");
        }
    }
}

