/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.observer.impl;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gvsig.tools.observer.ComplexObserver;
import org.gvsig.tools.observer.ComplexWeakReferencingObservable;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.observer.WeakReferencingObservable;
import org.gvsig.tools.observer.impl.DefaultComplexNotification;
import org.gvsig.tools.visitor.Visitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseWeakReferencingObservable
implements ComplexWeakReferencingObservable,
Cloneable {
    private static final Logger LOG = LoggerFactory.getLogger(BaseWeakReferencingObservable.class);
    private boolean propageNotifications = true;
    private DefaultComplexNotification complexNotification = null;
    private boolean changed = false;
    private List obs = new ArrayList();
    private int inComplexCount = 0;

    @Override
    public void addObserver(Observer observer) {
        this.addObserver(new WeakReference<Observer>(observer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObserver(Reference ref) {
        if (ref == null || ref.get() == null) {
            throw new NullPointerException();
        }
        Observer observer = (Observer)ref.get();
        List list = this.obs;
        synchronized (list) {
            if (!this.contains(observer)) {
                this.obs.add(ref);
            }
        }
    }

    public void addObservers(BaseWeakReferencingObservable observable) {
        observable.clearDeadReferences();
        Iterator iter = observable.obs.iterator();
        while (iter.hasNext()) {
            this.addObserver((Reference)iter.next());
        }
    }

    @Override
    public void deleteObserver(Observer observer) {
        this.deleteObserverReferenced(observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteObserver(Reference ref) {
        List list = this.obs;
        synchronized (list) {
            this.obs.remove(ref);
        }
        this.deleteObserverReferenced((Observer)ref.get());
    }

    public void notifyObservers() {
        this.notifyObservers(null);
    }

    public void notifyObservers(Object arg) {
        if (!this.inComplex()) {
            this.setChanged();
            this.notify(this, arg);
        } else {
            this.complexNotification.addNotification(arg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteObservers() {
        List list = this.obs;
        synchronized (list) {
            this.obs.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countObservers() {
        this.clearDeadReferences();
        List list = this.obs;
        synchronized (list) {
            return this.obs.size();
        }
    }

    @Override
    public void enableNotifications() {
        this.clearDeadReferences();
        this.propageNotifications = true;
    }

    @Override
    public void disableNotifications() {
        this.propageNotifications = false;
    }

    public boolean isEnabledNotifications() {
        return this.propageNotifications;
    }

    public boolean inComplex() {
        return this.inComplexCount > 0;
    }

    @Override
    public void beginComplexNotification() {
        if (this.inComplexCount == 0) {
            this.clearDeadReferences();
            this.clearChanged();
            this.complexNotification = new DefaultComplexNotification();
        }
        ++this.inComplexCount;
    }

    @Override
    public void endComplexNotification() {
        if (this.inComplexCount > 0) {
            if (this.inComplexCount == 1) {
                this.setChanged();
                this.notify(this, this.complexNotification);
                this.complexNotification = null;
            }
            --this.inComplexCount;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        BaseWeakReferencingObservable clone = (BaseWeakReferencingObservable)super.clone();
        if (this.countObservers() > 0) {
            clone.setObservers(this.getObservers());
        }
        return clone;
    }

    private void setObservers(List observers) {
        this.obs = new ArrayList(observers);
    }

    private List getObservers() {
        return this.obs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notify(final WeakReferencingObservable observable, Object notification) {
        Object[] arrLocal;
        if (!this.isEnabledNotifications()) {
            return;
        }
        List list = this.obs;
        synchronized (list) {
            if (!this.changed) {
                return;
            }
            arrLocal = this.obs.toArray();
            this.clearChanged();
        }
        for (int i = arrLocal.length - 1; i >= 0; --i) {
            final Observer observer = (Observer)((Reference)arrLocal[i]).get();
            if (observer == null) {
                this.obs.remove(arrLocal[i]);
                continue;
            }
            try {
                if (notification instanceof DefaultComplexNotification && !(observer instanceof ComplexObserver)) {
                    ((DefaultComplexNotification)notification).accept(new Visitor(){

                        @Override
                        public void visit(Object simpleNotification) {
                            BaseWeakReferencingObservable.this.setChanged();
                            observer.update(observable, simpleNotification);
                        }
                    });
                    continue;
                }
                observer.update(observable, notification);
                continue;
            }
            catch (Exception e) {
                LOG.error("Error notifying the observer", (Throwable)e);
            }
        }
    }

    protected boolean hasChanged() {
        return this.changed;
    }

    protected void setChanged() {
        this.changed = true;
    }

    protected void clearChanged() {
        this.changed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearDeadReferences() {
        List list = this.obs;
        synchronized (list) {
            Iterator iter = this.obs.iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (!(obj instanceof Reference) || ((Reference)obj).get() != null) continue;
                iter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean contains(Observer observer) {
        List list = this.obs;
        synchronized (list) {
            for (Object obj : this.obs) {
                Object value;
                if (!(obj instanceof Reference) || !observer.equals(value = ((Reference)obj).get())) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteObserverReferenced(Observer observer) {
        if (observer == null) {
            return;
        }
        List list = this.obs;
        synchronized (list) {
            Iterator iter = this.obs.iterator();
            while (iter.hasNext()) {
                Object value;
                Object obj = iter.next();
                if (!(obj instanceof Reference) || (value = ((Reference)obj).get()) != null && !observer.equals(value)) continue;
                iter.remove();
            }
        }
    }
}

